/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena;

import com.github.owlcs.ontapi.jena.impl.OntGraphModelImpl;
import com.github.owlcs.ontapi.jena.impl.conf.OntModelConfig;
import com.github.owlcs.ontapi.jena.impl.conf.OntPersonality;
import com.github.owlcs.ontapi.jena.model.OntModel;
import org.apache.jena.graph.Graph;
import org.apache.jena.mem.GraphMem;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sys.JenaSystem;

public class OntModelFactory {
    public static final PrefixMapping STANDARD;

    public static void init() {
        JenaSystem.init();
    }

    public static Graph createDefaultGraph() {
        return new GraphMem();
    }

    public static Model createDefaultModel() {
        return new ModelCom(OntModelFactory.createDefaultGraph());
    }

    public static OntModel createModel() {
        return OntModelFactory.createModel(OntModelFactory.createDefaultGraph());
    }

    public static OntModel createModel(Graph graph) {
        return OntModelFactory.createModel(graph, OntModelConfig.getPersonality());
    }

    public static OntModel createModel(Graph graph, OntPersonality personality) {
        return new OntGraphModelImpl(graph, personality);
    }

    static {
        OntModelFactory.init();
        STANDARD = PrefixMapping.Factory.create().setNsPrefix("owl", "http://www.w3.org/2002/07/owl#").setNsPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#").setNsPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#").setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#").lock();
    }
}

