/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena;

import com.github.owlcs.ontapi.jena.utils.Graphs;
import com.github.owlcs.ontapi.jena.utils.Iter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEventManager;
import org.apache.jena.graph.GraphStatisticsHandler;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.SimpleEventManager;
import org.apache.jena.graph.impl.SimpleTransactionHandler;
import org.apache.jena.mem.GraphMem;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.FilterIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class RWLockedGraph
implements Graph {
    protected final Graph base;
    protected final ReadWriteLock lock;
    protected final long delay;
    protected final Collection<WIT<?>> iterators = Collections.newSetFromMap(new WeakHashMap());
    protected final GraphEventManager gem;

    public RWLockedGraph(Graph base, ReadWriteLock lock) {
        this(base, lock, 500L);
    }

    public RWLockedGraph(Graph base, ReadWriteLock lock, long delayInMilliseconds) {
        this(base, lock, delayInMilliseconds, (GraphEventManager)new SimpleEventManager());
    }

    protected RWLockedGraph(Graph base, ReadWriteLock lock, long delayInMilliseconds, GraphEventManager gem) {
        this.base = Objects.requireNonNull(base, "Null base graph");
        this.lock = Objects.requireNonNull(lock, "Null lock");
        this.gem = Objects.requireNonNull(gem, "Null event manager");
        if (delayInMilliseconds <= 0L) {
            throw new IllegalArgumentException("Non-positive delay specified.");
        }
        this.delay = delayInMilliseconds;
    }

    public static long currentTimeInMilliSeconds() {
        return System.currentTimeMillis();
    }

    public Graph get() {
        return this.base;
    }

    public ReadWriteLock lock() {
        return this.lock;
    }

    public void add(Triple t) throws AddDeniedException {
        this.lock.writeLock().lock();
        try {
            if (!this.base.getCapabilities().addAllowed()) {
                throw new AddDeniedException("Attempt to add triple " + t);
            }
            this.waitForEmptyIterators();
            this.base.add(t);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void delete(Triple t) throws DeleteDeniedException {
        this.lock.writeLock().lock();
        try {
            if (!this.base.getCapabilities().deleteAllowed()) {
                throw new DeleteDeniedException("Attempt to delete triple " + t);
            }
            this.waitForEmptyIterators();
            this.base.delete(t);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Node s, Node p, Node o) {
        this.lock.writeLock().lock();
        try {
            if (!this.base.getCapabilities().deleteAllowed()) {
                throw new DeleteDeniedException("Attempt to remove triple " + Triple.createMatch((Node)s, (Node)p, (Node)o));
            }
            this.waitForEmptyIterators();
            this.base.remove(s, p, o);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            if (!this.base.getCapabilities().deleteAllowed()) {
                throw new DeleteDeniedException("Attempt to clear");
            }
            this.waitForEmptyIterators();
            this.base.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ExtendedIterator<Triple> find(Triple m) {
        this.lock.readLock().lock();
        try {
            WIT wIT = new WIT(this.base.find(m));
            return wIT;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedIterator<Triple> find(Node s, Node p, Node o) {
        this.lock.readLock().lock();
        try {
            WIT wIT = new WIT(this.base.find(s, p, o));
            return wIT;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean contains(Node s, Node p, Node o) {
        return this.withReadLock(() -> this.base.contains(s, p, o));
    }

    public boolean contains(Triple t) {
        return this.withReadLock(() -> this.base.contains(t));
    }

    public boolean isIsomorphicWith(Graph other) {
        this.lock.readLock().lock();
        try {
            if (this == other) {
                boolean bl = true;
                return bl;
            }
            if (other instanceof RWLockedGraph) {
                other = ((RWLockedGraph)other).get();
            }
            boolean bl = this.base.isIsomorphicWith(other);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean dependsOn(Graph other) {
        this.lock.readLock().lock();
        try {
            if (this == other) {
                boolean bl = true;
                return bl;
            }
            if (other instanceof RWLockedGraph) {
                other = ((RWLockedGraph)other).get();
            }
            boolean bl = Graphs.dependsOn(this.base, other);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void close() {
        this.lock.writeLock().lock();
        try {
            this.base.close();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            if (this.base instanceof GraphMem) {
                boolean bl = this.base.isEmpty();
                return bl;
            }
            boolean bl = !Iter.findFirst(this.find()).isPresent();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int size() {
        return this.withReadLock(() -> ((Graph)this.base).size());
    }

    public boolean isClosed() {
        return this.withReadLock(() -> ((Graph)this.base).isClosed());
    }

    public Capabilities getCapabilities() {
        return this.base.getCapabilities();
    }

    public TransactionHandler getTransactionHandler() {
        return new SimpleTransactionHandler();
    }

    public GraphEventManager getEventManager() {
        return this.gem;
    }

    public GraphStatisticsHandler getStatisticsHandler() {
        return (s, p, o) -> this.withReadLock(() -> this.base.getStatisticsHandler().getStatistic(s, p, o));
    }

    public PrefixMapping getPrefixMapping() {
        return new WPM();
    }

    protected <X> X withWriteLock(Supplier<X> op) {
        this.lock.writeLock().lock();
        try {
            X x = op.get();
            return x;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected <X> X withReadLock(Supplier<X> op) {
        this.lock.readLock().lock();
        try {
            X x = op.get();
            return x;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected void waitForEmptyIterators() {
        Collection<WIT<?>> iterators;
        while (!(iterators = this.findOtherIterators()).isEmpty()) {
            this.selectOldestIterator(iterators).ifPresent(this::makeIteratorSnapshot);
        }
    }

    protected void makeIteratorSnapshot(WIT<?> it) {
        ExtendedIterator<?> base = it.setBase(null);
        ArrayList<Object> res = new ArrayList<Object>();
        while (base.hasNext()) {
            res.add(base.next());
        }
        res.trimToSize();
        it.setBase(Iter.create(res.iterator()));
        this.removeIterator(it);
    }

    protected Optional<WIT<?>> selectOldestIterator(Collection<WIT<?>> iterators) {
        return iterators.stream().filter(WIT::isExpired).min(Comparator.comparingLong(WIT::timestamp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<WIT<?>> findOtherIterators() {
        Collection<WIT<?>> collection = this.iterators;
        synchronized (collection) {
            if (this.iterators.isEmpty()) {
                return Collections.emptySet();
            }
            Thread th = Thread.currentThread();
            return this.iterators.stream().filter(x -> th != x.thread).collect(Collectors.toSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putIterator(WIT<?> it) {
        Collection<WIT<?>> collection = this.iterators;
        synchronized (collection) {
            this.iterators.add(it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeIterator(WIT<?> it) {
        Collection<WIT<?>> collection = this.iterators;
        synchronized (collection) {
            this.iterators.remove(it);
        }
    }

    protected class WPM
    implements PrefixMapping {
        private final PrefixMapping pm;

        protected WPM() {
            this.pm = Objects.requireNonNull(RWLockedGraph.this.base.getPrefixMapping());
        }

        public PrefixMapping setNsPrefix(String prefix, String uri) {
            return RWLockedGraph.this.withWriteLock(() -> this.pm.setNsPrefix(prefix, uri));
        }

        public PrefixMapping removeNsPrefix(String prefix) {
            return RWLockedGraph.this.withWriteLock(() -> this.pm.removeNsPrefix(prefix));
        }

        public PrefixMapping clearNsPrefixMap() {
            return RWLockedGraph.this.withWriteLock(() -> ((PrefixMapping)this.pm).clearNsPrefixMap());
        }

        public PrefixMapping setNsPrefixes(PrefixMapping other) {
            return RWLockedGraph.this.withWriteLock(() -> this.pm.setNsPrefixes(other));
        }

        public PrefixMapping setNsPrefixes(Map<String, String> map) {
            return RWLockedGraph.this.withWriteLock(() -> this.pm.setNsPrefixes(map));
        }

        public PrefixMapping withDefaultMappings(PrefixMapping map) {
            return RWLockedGraph.this.withWriteLock(() -> this.pm.withDefaultMappings(map));
        }

        public PrefixMapping lock() {
            return RWLockedGraph.this.withWriteLock(() -> ((PrefixMapping)this.pm).lock());
        }

        public String getNsPrefixURI(String prefix) {
            return RWLockedGraph.this.withReadLock(() -> this.pm.getNsPrefixURI(prefix));
        }

        public String getNsURIPrefix(String uri) {
            return RWLockedGraph.this.withReadLock(() -> this.pm.getNsURIPrefix(uri));
        }

        public Map<String, String> getNsPrefixMap() {
            return RWLockedGraph.this.withReadLock(() -> ((PrefixMapping)this.pm).getNsPrefixMap());
        }

        public String expandPrefix(String prefixed) {
            return RWLockedGraph.this.withReadLock(() -> this.pm.expandPrefix(prefixed));
        }

        public String shortForm(String uri) {
            return RWLockedGraph.this.withReadLock(() -> this.pm.shortForm(uri));
        }

        public String qnameFor(String uri) {
            return RWLockedGraph.this.withReadLock(() -> this.pm.qnameFor(uri));
        }

        public int numPrefixes() {
            return RWLockedGraph.this.withReadLock(() -> ((PrefixMapping)this.pm).numPrefixes());
        }

        public boolean samePrefixMappingAs(PrefixMapping other) {
            return RWLockedGraph.this.withReadLock(() -> this.pm.samePrefixMappingAs(other));
        }

        public String toString() {
            if (this.pm instanceof PrefixMappingImpl) {
                return RWLockedGraph.this.withReadLock(this.pm::toString);
            }
            return super.toString();
        }
    }

    public class WIT<X>
    extends WrappedIterator<X> {
        protected final Thread thread;
        protected volatile ExtendedIterator<X> base;
        protected long timestamp;

        protected WIT(ExtendedIterator<X> base) {
            super((Iterator)Objects.requireNonNull(base));
            this.base = base;
            this.thread = Thread.currentThread();
            this.timestamp = RWLockedGraph.currentTimeInMilliSeconds();
            RWLockedGraph.this.putIterator(this);
        }

        protected ExtendedIterator<X> base() {
            while (this.base == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("Unexpected interruption", e);
                }
            }
            return this.base;
        }

        protected ExtendedIterator<X> setBase(ExtendedIterator<X> base) {
            ExtendedIterator<X> res = this.base;
            this.base = base;
            return res;
        }

        protected void refreshTimestamp() {
            this.timestamp = RWLockedGraph.currentTimeInMilliSeconds();
        }

        protected long timestamp() {
            return this.timestamp;
        }

        protected boolean isExpired() {
            return RWLockedGraph.currentTimeInMilliSeconds() - this.timestamp > RWLockedGraph.this.delay;
        }

        protected void deleteFromCollection() {
            RWLockedGraph.this.removeIterator(this);
        }

        public boolean hasNext() {
            this.refreshTimestamp();
            try {
                boolean res = this.base().hasNext();
                if (!res) {
                    this.deleteFromCollection();
                }
                return res;
            }
            catch (Exception e) {
                this.deleteFromCollection();
                throw e;
            }
        }

        public X next() {
            this.refreshTimestamp();
            try {
                return (X)this.base().next();
            }
            catch (Exception e) {
                this.deleteFromCollection();
                throw e;
            }
        }

        public void remove() {
            this.refreshTimestamp();
            this.base().remove();
        }

        public X removeNext() {
            X res = this.next();
            this.remove();
            return res;
        }

        public <X1 extends X> ExtendedIterator<X> andThen(Iterator<X1> other) {
            this.refreshTimestamp();
            return super.andThen(other);
        }

        public FilterIterator<X> filterKeep(Predicate<X> test) {
            this.refreshTimestamp();
            return super.filterKeep(test);
        }

        public FilterIterator<X> filterDrop(Predicate<X> test) {
            this.refreshTimestamp();
            return super.filterDrop(test);
        }

        public <U> ExtendedIterator<U> mapWith(Function<X, U> map) {
            this.refreshTimestamp();
            return super.mapWith(map);
        }

        public List<X> toList() {
            this.refreshTimestamp();
            try {
                List list = WIT.asList((ExtendedIterator)this);
                return list;
            }
            finally {
                this.deleteFromCollection();
            }
        }

        public Set<X> toSet() {
            this.refreshTimestamp();
            try {
                Set set = WIT.asSet((ExtendedIterator)this);
                return set;
            }
            finally {
                this.deleteFromCollection();
            }
        }

        public void close() {
            this.refreshTimestamp();
            try {
                WIT.close(this.base());
            }
            finally {
                this.deleteFromCollection();
            }
        }

        public void forEachRemaining(Consumer<? super X> action) {
            this.refreshTimestamp();
            Objects.requireNonNull(action);
            try {
                while (this.hasNext()) {
                    action.accept(this.next());
                }
            }
            finally {
                this.deleteFromCollection();
            }
        }
    }
}

