/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena;

import com.github.owlcs.ontapi.jena.utils.Graphs;
import com.github.owlcs.ontapi.jena.utils.Iter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphListener;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.CompositionBase;
import org.apache.jena.graph.impl.SimpleEventManager;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.CollectionFactory;
import org.apache.jena.util.iterator.ClosableIterator;
import org.apache.jena.util.iterator.ExtendedIterator;

public class UnionGraph
extends CompositionBase {
    protected final Graph base;
    protected final Underlying sub;
    protected final boolean distinct;
    protected Set<UnionGraph> parents = Collections.newSetFromMap(new WeakHashMap());
    protected Set<Graph> graphs;

    public UnionGraph(Graph base) {
        this(base, true);
    }

    public UnionGraph(Graph base, boolean distinct) {
        this(base, null, null, distinct);
    }

    public UnionGraph(Graph base, Underlying sub, OntEventManager gem, boolean distinct) {
        this.base = Objects.requireNonNull(base, "Null base graph.");
        this.sub = sub == null ? new Underlying() : sub;
        this.gem = gem == null ? new OntEventManager() : gem;
        this.distinct = distinct;
    }

    public PrefixMapping getPrefixMapping() {
        return this.getBaseGraph().getPrefixMapping();
    }

    public OntEventManager getEventManager() {
        return (OntEventManager)this.gem;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public Graph getBaseGraph() {
        return this.base;
    }

    public Underlying getUnderlying() {
        return this.sub;
    }

    public void performAdd(Triple t) {
        if (!this.sub.contains(t)) {
            this.base.add(t);
        }
    }

    public void performDelete(Triple t) {
        this.base.delete(t);
    }

    public UnionGraph addGraph(Graph graph) {
        this.checkOpen();
        this.getUnderlying().add(graph);
        this.addParent(graph);
        this.resetGraphsCache();
        return this;
    }

    protected void addParent(Graph graph) {
        if (!(graph instanceof UnionGraph)) {
            return;
        }
        ((UnionGraph)graph).parents.add(this);
    }

    public UnionGraph removeGraph(Graph graph) {
        this.checkOpen();
        this.getUnderlying().remove(graph);
        this.removeParent(graph);
        this.resetGraphsCache();
        return this;
    }

    protected void removeParent(Graph graph) {
        if (!(graph instanceof UnionGraph)) {
            return;
        }
        ((UnionGraph)graph).parents.remove((Object)this);
    }

    protected void resetGraphsCache() {
        this.collectAllUnionGraphs().forEach(x -> {
            x.graphs = null;
        });
    }

    public ExtendedIterator<Graph> listBaseGraphs() {
        return Iter.create(this.graphs == null ? (this.graphs = this.collectBaseGraphs()) : this.graphs);
    }

    public ExtendedIterator<UnionGraph> listUnionGraphs() {
        return Iter.create(this.collectUnionGraphs());
    }

    protected final ExtendedIterator<Triple> graphBaseFind(Triple m) {
        return SimpleEventManager.notifyingRemove((Graph)this, this.createFindIterator(m));
    }

    public boolean graphBaseContains(Triple t) {
        if (this.base.contains(t)) {
            return true;
        }
        if (this.sub.isEmpty()) {
            return false;
        }
        ExtendedIterator<Graph> graphs = this.listBaseGraphs();
        while (graphs.hasNext()) {
            Graph g = (Graph)graphs.next();
            if (g == this.base || !g.contains(t)) continue;
            return true;
        }
        return false;
    }

    public int graphBaseSize() {
        if (this.sub.isEmpty()) {
            return this.base.size();
        }
        return super.graphBaseSize();
    }

    public boolean isEmpty() {
        return !Iter.findFirst(this.find()).isPresent();
    }

    protected ExtendedIterator<Triple> createFindIterator(Triple m) {
        if (this.sub.isEmpty()) {
            return this.base.find(m);
        }
        if (!this.distinct) {
            return Iter.flatMap(this.listBaseGraphs(), x -> x.find(m));
        }
        Set<Triple> seen = this.createSet();
        return Iter.flatMap(this.listBaseGraphs(), x -> UnionGraph.recording((ClosableIterator)UnionGraph.rejecting((ExtendedIterator)x.find(m), (Set)seen), (Set)seen));
    }

    protected Set<Triple> createSet() {
        return CollectionFactory.createHashedSet();
    }

    public void close() {
        this.listBaseGraphs().forEachRemaining(Graph::close);
        this.collectUnionGraphs().forEach(x -> {
            x.closed = true;
        });
    }

    public boolean dependsOn(Graph other) {
        return other instanceof UnionGraph && this.collectUnionGraphs().contains(other) || Iter.anyMatch(this.listBaseGraphs(), x -> Graphs.dependsOn(x, other));
    }

    protected Set<Graph> collectBaseGraphs() {
        LinkedHashSet<Graph> res = new LinkedHashSet<Graph>();
        this.collectBaseGraphs(res, new HashSet<UnionGraph>());
        return res;
    }

    private void collectBaseGraphs(Set<Graph> res, Set<UnionGraph> seen) {
        Graph base = this.getBaseGraph();
        LinkedHashSet<Graph> graphs = new LinkedHashSet<Graph>();
        graphs.add(base);
        graphs.addAll(this.getUnderlying().graphs);
        graphs.forEach(g -> {
            if (!(g instanceof UnionGraph)) {
                res.add((Graph)g);
                return;
            }
            UnionGraph u = (UnionGraph)((Object)g);
            if (seen.add(u)) {
                u.collectBaseGraphs(res, seen);
            }
        });
    }

    protected Set<UnionGraph> collectAllUnionGraphs() {
        Set<UnionGraph> res = this.collectUnionGraphs();
        this.collectParents(res);
        return res;
    }

    protected Set<UnionGraph> collectUnionGraphs() {
        HashSet<UnionGraph> res = new HashSet<UnionGraph>();
        res.add(this);
        this.collectChildren(res);
        return res;
    }

    private void collectParents(Set<UnionGraph> res) {
        this.parents.stream().filter(res::add).forEach(u -> u.collectParents(res));
    }

    private void collectChildren(Set<UnionGraph> res) {
        this.getUnderlying().graphs().filter(x -> x instanceof UnionGraph).map(UnionGraph.class::cast).filter(res::add).forEach(u -> u.collectChildren(res));
    }

    public String toString() {
        return String.format("%s(%s)@%s", ((Object)((Object)this)).getClass().getName(), Graphs.getName((Graph)this), Integer.toHexString(((Object)((Object)this)).hashCode()));
    }

    public static class OntEventManager
    extends SimpleEventManager {
        public Stream<GraphListener> listeners() {
            return this.listeners.stream();
        }

        public boolean hasListeners(Class<? extends GraphListener> view) {
            return this.listeners().anyMatch(l -> view.isAssignableFrom(l.getClass()));
        }
    }

    public static class Underlying {
        protected final Collection<Graph> graphs;

        protected Underlying() {
            this(new ArrayList<Graph>());
        }

        protected Underlying(Collection<Graph> graphs) {
            this.graphs = Objects.requireNonNull(graphs);
        }

        public ExtendedIterator<Graph> listGraphs() {
            return Iter.create(this.graphs);
        }

        public Stream<Graph> graphs() {
            return this.graphs.stream();
        }

        public boolean isEmpty() {
            return this.graphs.isEmpty();
        }

        protected void remove(Graph graph) {
            this.graphs.remove(graph);
        }

        protected void add(Graph graph) {
            this.graphs.add(Objects.requireNonNull(graph));
        }

        protected boolean contains(Triple t) {
            if (this.graphs.isEmpty()) {
                return false;
            }
            for (Graph g : this.graphs) {
                if (!g.contains(t)) continue;
                return true;
            }
            return false;
        }
    }
}

