/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl;

import com.github.owlcs.ontapi.jena.impl.Factories;
import com.github.owlcs.ontapi.jena.impl.OntAPropertyImpl;
import com.github.owlcs.ontapi.jena.impl.OntClassImpl;
import com.github.owlcs.ontapi.jena.impl.OntDPropertyImpl;
import com.github.owlcs.ontapi.jena.impl.OntDatatypeImpl;
import com.github.owlcs.ontapi.jena.impl.OntIndividualImpl;
import com.github.owlcs.ontapi.jena.impl.OntOPEImpl;
import com.github.owlcs.ontapi.jena.impl.OntObjectImpl;
import com.github.owlcs.ontapi.jena.impl.PersonalityModel;
import com.github.owlcs.ontapi.jena.impl.conf.ObjectFactory;
import com.github.owlcs.ontapi.jena.impl.conf.OntFilter;
import com.github.owlcs.ontapi.jena.impl.conf.OntFinder;
import com.github.owlcs.ontapi.jena.impl.conf.OntMaker;
import com.github.owlcs.ontapi.jena.impl.conf.OntPersonality;
import com.github.owlcs.ontapi.jena.impl.conf.Vocabulary;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntEntity;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public enum Entities {
    CLASS(OWL.Class, OntClass.Named.class, OntClassImpl.class, Vocabulary.Entities::getClasses),
    DATATYPE(RDFS.Datatype, OntDataRange.Named.class, OntDatatypeImpl.class, Vocabulary.Entities::getDatatypes),
    ANNOTATION_PROPERTY(OWL.AnnotationProperty, OntAnnotationProperty.class, OntAPropertyImpl.class, Vocabulary.Entities::getAnnotationProperties),
    DATA_PROPERTY(OWL.DatatypeProperty, OntDataProperty.class, OntDPropertyImpl.class, Vocabulary.Entities::getDatatypeProperties),
    OBJECT_PROPERTY(OWL.ObjectProperty, OntObjectProperty.Named.class, OntOPEImpl.NamedPropertyImpl.class, Vocabulary.Entities::getObjectProperties),
    INDIVIDUAL(OWL.NamedIndividual, OntIndividual.Named.class, OntIndividualImpl.NamedImpl.class, Vocabulary.Entities::getIndividuals){

        @Override
        OntFilter createPrimaryFilter() {
            return (n, g) -> n.isURI() && this.filterType(n, g);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean filterType(Node n, EnhGraph g) {
            if (this.builtInURIs(g).contains(n)) {
                return true;
            }
            Set<Node> forbidden = this.bannedTypes(g);
            ArrayList<Node> candidates = new ArrayList<Node>();
            boolean hasDeclaration = false;
            try (ExtendedIterator it = g.asGraph().find(n, RDF.Nodes.type, Node.ANY);){
                while (it.hasNext()) {
                    Node type = ((Triple)it.next()).getObject();
                    if (forbidden.contains(type)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (this.resourceType.asNode().equals((Object)type)) {
                        hasDeclaration = true;
                        continue;
                    }
                    candidates.add(type);
                }
            }
            if (hasDeclaration) {
                return true;
            }
            for (Node c : candidates) {
                if (!PersonalityModel.canAs(OntClass.class, c, g)) continue;
                return true;
            }
            return false;
        }
    };

    private static final OntFinder ENTITY_FINDER;
    public static final ObjectFactory ALL;
    final Class<? extends OntObjectImpl> impl;
    final Class<? extends OntEntity> classType;
    final Resource resourceType;
    final Function<Vocabulary.Entities, Set<Node>> extractNodeSet;

    private Entities(Resource resourceType, Class<? extends OntEntity> classType, Class<? extends OntObjectImpl> impl, Function<Vocabulary.Entities, Set<Node>> extractNodeSet) {
        this.classType = classType;
        this.resourceType = resourceType;
        this.impl = impl;
        this.extractNodeSet = extractNodeSet;
    }

    public Class<? extends OntEntity> getActualType() {
        return this.classType;
    }

    public Resource getResourceType() {
        return this.resourceType;
    }

    private OntPersonality personality(EnhGraph g) {
        return PersonalityModel.asPersonalityModel(g).getOntPersonality();
    }

    Set<Node> bannedTypes(EnhGraph g) {
        return this.extractNodeSet.apply(this.personality(g).getPunnings());
    }

    Set<Node> builtInURIs(EnhGraph g) {
        return this.extractNodeSet.apply(this.personality(g).getBuiltins());
    }

    public ObjectFactory createFactory() {
        OntFinder.ByType finder = new OntFinder.ByType(this.resourceType);
        OntFilter filter = this.createPrimaryFilter();
        OntMaker maker = new OntMaker.WithType(this.impl, this.resourceType).restrict(this.createIllegalPunningsFilter());
        return Factories.createCommon(this.classType, maker, finder, filter);
    }

    OntFilter createIllegalPunningsFilter() {
        return (n, eg) -> {
            Graph g = eg.asGraph();
            for (Node t : this.bannedTypes(eg)) {
                if (!g.contains(n, RDF.Nodes.type, t)) continue;
                return false;
            }
            return true;
        };
    }

    OntFilter createPrimaryFilter() {
        OntFilter builtInEntity = (n, g) -> this.builtInURIs(g).contains(n);
        OntFilter modelEntity = new OntFilter.HasType(this.resourceType).and(this.createIllegalPunningsFilter());
        OntFilter entity = modelEntity.or(builtInEntity);
        return OntFilter.URI.and(entity);
    }

    public static Optional<Entities> find(Resource type) {
        return Entities.find(type.asNode());
    }

    public static Optional<Entities> find(Node type) {
        for (Entities e : Entities.values()) {
            if (!Objects.equals(e.getResourceType().asNode(), type)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public static Optional<Entities> find(Class<? extends OntEntity> type) {
        for (Entities e : Entities.values()) {
            if (!Objects.equals(e.getActualType(), type)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    static {
        ENTITY_FINDER = Factories.createFinder(e -> e.getResourceType().asNode(), Entities.values());
        ALL = Factories.createFrom(ENTITY_FINDER, Arrays.stream(Entities.values()).map(Entities::getActualType));
    }
}

