/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl;

import com.github.owlcs.ontapi.jena.impl.OntObjectImpl;
import com.github.owlcs.ontapi.jena.impl.WrappedFactoryImpl;
import com.github.owlcs.ontapi.jena.impl.conf.CommonFactoryImpl;
import com.github.owlcs.ontapi.jena.impl.conf.MultiFactoryImpl;
import com.github.owlcs.ontapi.jena.impl.conf.ObjectFactory;
import com.github.owlcs.ontapi.jena.impl.conf.OntFilter;
import com.github.owlcs.ontapi.jena.impl.conf.OntFinder;
import com.github.owlcs.ontapi.jena.impl.conf.OntMaker;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.utils.Iter;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;

class Factories {
    Factories() {
    }

    @SafeVarargs
    static ObjectFactory createFrom(OntFinder finder, Class<? extends OntObject> ... types) {
        return Factories.createFrom(finder, Arrays.stream(types));
    }

    static ObjectFactory createFrom(OntFinder finder, Stream<Class<? extends OntObject>> types) {
        return Factories.createMulti(finder, types.map(WrappedFactoryImpl::new));
    }

    private static ObjectFactory createMulti(OntFinder finder, Stream<ObjectFactory> factories) {
        return new MultiFactoryImpl(Objects.requireNonNull(finder, "Null finder"), null, (ObjectFactory[])factories.peek(x -> Objects.requireNonNull(x, "Null component-factory")).toArray(ObjectFactory[]::new));
    }

    static ObjectFactory createCommon(Class<? extends OntObjectImpl> impl, OntFinder finder, OntFilter filter, OntFilter ... additional) {
        return Factories.createCommon(new OntMaker.Default(impl), finder, filter, additional);
    }

    static ObjectFactory createCommon(OntMaker maker, OntFinder finder, OntFilter primary, OntFilter ... additional) {
        return new CommonFactoryImpl(Objects.requireNonNull(maker, "Null maker"), Objects.requireNonNull(finder, "Null finder"), Objects.requireNonNull(primary, "Null filter").accumulate(additional));
    }

    static ObjectFactory createCommon(final Class<? extends OntObject> type, OntMaker maker, OntFinder finder, OntFilter filter) {
        Objects.requireNonNull(type, "Null type");
        return new CommonFactoryImpl(Objects.requireNonNull(maker, "Null maker"), Objects.requireNonNull(finder, "Null finder"), Objects.requireNonNull(filter, "Null filter")){

            public String toString() {
                return String.format("ObjectFactory[%s]", OntObjectImpl.viewAsString(type));
            }
        };
    }

    static OntFinder createFinder(Resource ... types) {
        return Factories.createFinder(FrontsNode::asNode, types);
    }

    @SafeVarargs
    static <R> OntFinder createFinder(Function<R, Node> asNode, R ... types) {
        return eg -> Iter.distinct(Factories.listTriplesForTypes(eg.asGraph(), asNode, types).mapWith(Triple::getSubject));
    }

    @SafeVarargs
    private static <R> ExtendedIterator<Triple> listTriplesForTypes(Graph g, Function<R, Node> asNode, R ... types) {
        return Iter.flatMap(Iter.of(types).mapWith(asNode), t -> g.find(Node.ANY, RDF.Nodes.type, t));
    }
}

