/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.Factories;
import com.github.owlcs.ontapi.jena.impl.OntGraphModelImpl;
import com.github.owlcs.ontapi.jena.impl.OntListImpl;
import com.github.owlcs.ontapi.jena.impl.OntObjectImpl;
import com.github.owlcs.ontapi.jena.impl.PersonalityModel;
import com.github.owlcs.ontapi.jena.impl.WrappedFactoryImpl;
import com.github.owlcs.ontapi.jena.impl.conf.BaseFactoryImpl;
import com.github.owlcs.ontapi.jena.impl.conf.ObjectFactory;
import com.github.owlcs.ontapi.jena.impl.conf.OntFilter;
import com.github.owlcs.ontapi.jena.impl.conf.OntFinder;
import com.github.owlcs.ontapi.jena.impl.conf.OntMaker;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntList;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntProperty;
import com.github.owlcs.ontapi.jena.model.OntRealProperty;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.utils.Models;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.XSD;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.impl.RDFListImpl;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public abstract class OntCEImpl
extends OntObjectImpl
implements OntClass {
    public static final OntFinder CLASS_FINDER = new OntFinder.ByType(OWL.Class);
    public static final OntFinder RESTRICTION_FINDER = new OntFinder.ByType(OWL.Restriction);
    public static final OntFilter RESTRICTION_FILTER = OntFilter.BLANK.and(new OntFilter.HasType(OWL.Restriction));
    public static ObjectFactory unionOfCEFactory = OntCEImpl.createCEFactory(UnionOfImpl.class, OWL.unionOf, RDFList.class);
    public static ObjectFactory intersectionOfCEFactory = OntCEImpl.createCEFactory(IntersectionOfImpl.class, OWL.intersectionOf, RDFList.class);
    public static ObjectFactory oneOfCEFactory = OntCEImpl.createCEFactory(OneOfImpl.class, OWL.oneOf, RDFList.class);
    public static ObjectFactory complementOfCEFactory = OntCEImpl.createCEFactory(ComplementOfImpl.class, OWL.complementOf, OntClass.class);
    public static ObjectFactory objectSomeValuesOfCEFactory = OntCEImpl.createRestrictionFactory(ObjectSomeValuesFromImpl.class, RestrictionType.OBJECT, ObjectRestrictionType.CLASS, OWL.someValuesFrom);
    public static ObjectFactory dataSomeValuesOfCEFactory = OntCEImpl.createRestrictionFactory(DataSomeValuesFromImpl.class, RestrictionType.DATA, ObjectRestrictionType.DATA_RANGE, OWL.someValuesFrom);
    public static ObjectFactory objectAllValuesOfCEFactory = OntCEImpl.createRestrictionFactory(ObjectAllValuesFromImpl.class, RestrictionType.OBJECT, ObjectRestrictionType.CLASS, OWL.allValuesFrom);
    public static ObjectFactory dataAllValuesOfCEFactory = OntCEImpl.createRestrictionFactory(DataAllValuesFromImpl.class, RestrictionType.DATA, ObjectRestrictionType.DATA_RANGE, OWL.allValuesFrom);
    public static ObjectFactory objectHasValueCEFactory = OntCEImpl.createRestrictionFactory(ObjectHasValueImpl.class, RestrictionType.OBJECT, ObjectRestrictionType.INDIVIDUAL, OWL.hasValue);
    public static ObjectFactory dataHasValueCEFactory = OntCEImpl.createRestrictionFactory(DataHasValueImpl.class, RestrictionType.DATA, ObjectRestrictionType.LITERAL, OWL.hasValue);
    public static ObjectFactory dataMinCardinalityCEFactory = OntCEImpl.createRestrictionFactory(DataMinCardinalityImpl.class, RestrictionType.DATA, ObjectRestrictionType.DATA_RANGE, CardinalityType.MIN);
    public static ObjectFactory objectMinCardinalityCEFactory = OntCEImpl.createRestrictionFactory(ObjectMinCardinalityImpl.class, RestrictionType.OBJECT, ObjectRestrictionType.CLASS, CardinalityType.MIN);
    public static ObjectFactory dataMaxCardinalityCEFactory = OntCEImpl.createRestrictionFactory(DataMaxCardinalityImpl.class, RestrictionType.DATA, ObjectRestrictionType.DATA_RANGE, CardinalityType.MAX);
    public static ObjectFactory objectMaxCardinalityCEFactory = OntCEImpl.createRestrictionFactory(ObjectMaxCardinalityImpl.class, RestrictionType.OBJECT, ObjectRestrictionType.CLASS, CardinalityType.MAX);
    public static ObjectFactory dataCardinalityCEFactory = OntCEImpl.createRestrictionFactory(DataCardinalityImpl.class, RestrictionType.DATA, ObjectRestrictionType.DATA_RANGE, CardinalityType.EXACTLY);
    public static ObjectFactory objectCardinalityCEFactory = OntCEImpl.createRestrictionFactory(ObjectCardinalityImpl.class, RestrictionType.OBJECT, ObjectRestrictionType.CLASS, CardinalityType.EXACTLY);
    public static ObjectFactory hasSelfCEFactory = Factories.createCommon(new HasSelfMaker(), RESTRICTION_FINDER, OntFilter.BLANK.and(new HasSelfFilter()), new OntFilter[0]);
    public static ObjectFactory naryDataAllValuesFromCEFactory = OntCEImpl.createNaryFactory(NaryDataAllValuesFromImpl.class, OWL.allValuesFrom);
    public static ObjectFactory naryDataSomeValuesFromCEFactory = OntCEImpl.createNaryFactory(NaryDataSomeValuesFromImpl.class, OWL.someValuesFrom);
    public static ObjectFactory abstractComponentsCEFactory = Factories.createFrom(CLASS_FINDER, OntClass.UnionOf.class, OntClass.IntersectionOf.class, OntClass.OneOf.class);
    public static ObjectFactory abstractCardinalityRestrictionCEFactory = Factories.createFrom(RESTRICTION_FINDER, OntClass.ObjectMaxCardinality.class, OntClass.DataMaxCardinality.class, OntClass.ObjectMinCardinality.class, OntClass.DataMinCardinality.class, OntClass.ObjectCardinality.class, OntClass.DataCardinality.class);
    public static ObjectFactory abstractComponentRestrictionCEFactory = Factories.createFrom(RESTRICTION_FINDER, OntClass.ObjectMaxCardinality.class, OntClass.DataMaxCardinality.class, OntClass.ObjectMinCardinality.class, OntClass.DataMinCardinality.class, OntClass.ObjectCardinality.class, OntClass.DataCardinality.class, OntClass.ObjectSomeValuesFrom.class, OntClass.DataSomeValuesFrom.class, OntClass.ObjectAllValuesFrom.class, OntClass.DataAllValuesFrom.class, OntClass.ObjectHasValue.class, OntClass.DataHasValue.class);
    public static ObjectFactory abstractPropertyRestrictionCEFactory = Factories.createFrom(RESTRICTION_FINDER, OntClass.ObjectMaxCardinality.class, OntClass.DataMaxCardinality.class, OntClass.ObjectMinCardinality.class, OntClass.DataMinCardinality.class, OntClass.ObjectCardinality.class, OntClass.DataCardinality.class, OntClass.ObjectSomeValuesFrom.class, OntClass.DataSomeValuesFrom.class, OntClass.ObjectAllValuesFrom.class, OntClass.DataAllValuesFrom.class, OntClass.ObjectHasValue.class, OntClass.DataHasValue.class, OntClass.HasSelf.class);
    public static ObjectFactory abstractRestrictionCEFactory = Factories.createFrom(RESTRICTION_FINDER, OntClass.ObjectMaxCardinality.class, OntClass.DataMaxCardinality.class, OntClass.ObjectMinCardinality.class, OntClass.DataMinCardinality.class, OntClass.ObjectCardinality.class, OntClass.DataCardinality.class, OntClass.ObjectSomeValuesFrom.class, OntClass.DataSomeValuesFrom.class, OntClass.ObjectAllValuesFrom.class, OntClass.DataAllValuesFrom.class, OntClass.ObjectHasValue.class, OntClass.DataHasValue.class, OntClass.NaryDataSomeValuesFrom.class, OntClass.NaryDataAllValuesFrom.class, OntClass.HasSelf.class);
    public static ObjectFactory abstractCEFactory = ClassExpressionFactory.createFactory();

    public OntCEImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    protected static ObjectFactory createCEFactory(Class<? extends OntCEImpl> impl, Property predicate, Class<? extends RDFNode> view) {
        OntMaker.WithType maker = new OntMaker.WithType(impl, OWL.Class);
        OntFilter filter = OntFilter.BLANK.and(new OntFilter.HasType(OWL.Class)).and((n, g) -> {
            try (ExtendedIterator res = g.asGraph().find(n, predicate.asNode(), Node.ANY);){
                while (res.hasNext()) {
                    if (!PersonalityModel.canAs(view, ((Triple)res.next()).getObject(), g)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        });
        return Factories.createCommon(maker, CLASS_FINDER, filter, new OntFilter[0]);
    }

    protected static ObjectFactory createRestrictionFactory(Class<? extends CardinalityRestrictionCEImpl<?, ?, ?>> impl, RestrictionType restrictionType, ObjectRestrictionType objectType, CardinalityType cardinalityType) {
        OntMaker.WithType maker = new OntMaker.WithType(impl, OWL.Restriction);
        OntFilter filter = RESTRICTION_FILTER.and(cardinalityType.getFilter(objectType.view())).and(restrictionType.getFilter());
        return Factories.createCommon(maker, RESTRICTION_FINDER, filter, new OntFilter[0]);
    }

    protected static ObjectFactory createRestrictionFactory(Class<? extends ComponentRestrictionCEImpl<?, ?, ?>> impl, RestrictionType propertyType, ObjectRestrictionType objectType, Property predicate) {
        OntMaker.WithType maker = new OntMaker.WithType(impl, OWL.Restriction);
        OntFilter filter = RESTRICTION_FILTER.and(propertyType.getFilter()).and(objectType.getFilter(predicate));
        return Factories.createCommon(maker, RESTRICTION_FINDER, filter, new OntFilter[0]);
    }

    protected static ObjectFactory createNaryFactory(Class<? extends NaryRestrictionCEImpl<?, ?, ?>> impl, Property predicate) {
        OntMaker.WithType maker = new OntMaker.WithType(impl, OWL.Restriction);
        OntFilter filter = RESTRICTION_FILTER.and(new OntFilter.HasPredicate(OWL.onProperties)).and(new OntFilter.HasPredicate(predicate));
        return Factories.createCommon(maker, RESTRICTION_FINDER, filter, new OntFilter[0]);
    }

    public static boolean isQualified(OntObject c) {
        return c != null && !OWL.Thing.equals((Object)c) && !RDFS.Literal.equals((Object)c);
    }

    protected static CardinalityType getCardinalityType(Class<? extends OntClass.CardinalityRestrictionCE<?, ?>> view) {
        if (OntClass.ObjectMinCardinality.class.equals(view) || OntClass.DataMinCardinality.class.equals(view)) {
            return CardinalityType.MIN;
        }
        if (OntClass.ObjectMaxCardinality.class.equals(view) || OntClass.DataMaxCardinality.class.equals(view)) {
            return CardinalityType.MAX;
        }
        return CardinalityType.EXACTLY;
    }

    protected static Literal createNonNegativeIntegerLiteral(int n) {
        if (n < 0) {
            throw new OntJenaException.IllegalArgument("Can't accept negative value: " + n);
        }
        return ResourceFactory.createTypedLiteral((String)String.valueOf(n), (RDFDatatype)CardinalityType.NON_NEGATIVE_INTEGER);
    }

    private static Resource createRestriction(OntModel model) {
        return model.createResource(OWL.Restriction);
    }

    protected static Resource createOnPropertyRestriction(OntGraphModelImpl model, OntProperty onProperty) {
        OntJenaException.notNull(onProperty, "Null property.");
        return OntCEImpl.createRestriction(model).addProperty(OWL.onProperty, (RDFNode)onProperty);
    }

    public static <CE extends OntClass.ComponentRestrictionCE<?, ?>> CE createComponentRestrictionCE(OntGraphModelImpl model, Class<CE> view, OntProperty onProperty, RDFNode other, Property predicate) {
        OntJenaException.notNull(other, "Null expression.");
        Resource res = OntCEImpl.createOnPropertyRestriction(model, onProperty).addProperty(predicate, other);
        return (CE)((OntClass.ComponentRestrictionCE)model.getNodeAs(res.asNode(), view));
    }

    public static <CE extends OntClass.CardinalityRestrictionCE<?, ?>> CE createCardinalityRestrictionCE(OntGraphModelImpl model, Class<CE> view, OntProperty onProperty, int cardinality, OntObject object) {
        Literal value = OntCEImpl.createNonNegativeIntegerLiteral(cardinality);
        Resource res = OntCEImpl.createOnPropertyRestriction(model, onProperty);
        boolean qualified = OntCEImpl.isQualified(object);
        model.add(res, OntCEImpl.getCardinalityType(view).getPredicate(qualified), (RDFNode)value);
        if (qualified) {
            model.add(res, onProperty instanceof OntObjectProperty ? OWL.onClass : OWL.onDataRange, (RDFNode)object);
        }
        return (CE)((OntClass.CardinalityRestrictionCE)model.getNodeAs(res.asNode(), view));
    }

    public static <CE extends OntClass.NaryRestrictionCE<?, ?>> CE createNaryRestrictionCE(OntGraphModelImpl model, Class<CE> type, OntDataRange dr, Collection<OntDataProperty> properties) {
        NaryRestrictionCEImpl.validateArity(dr, properties);
        Property predicate = OntClass.NaryDataAllValuesFrom.class.equals(type) ? OWL.allValuesFrom : OWL.someValuesFrom;
        Resource res = OntCEImpl.createRestriction(model).addProperty(predicate, (RDFNode)dr).addProperty(OWL.onProperties, (RDFNode)model.createList(properties.iterator()));
        return (CE)((OntClass.NaryRestrictionCE)model.getNodeAs(res.asNode(), type));
    }

    public static <CE extends OntClass.ComponentsCE<?>, R extends OntObject> CE createComponentsCE(OntGraphModelImpl model, Class<CE> returnType, Class<R> componentType, Property predicate, Stream<R> components) {
        OntJenaException.notNull(components, "Null components stream.");
        Resource res = model.createResource(OWL.Class).addProperty(predicate, (RDFNode)model.createList(components.peek(x -> OntJenaException.notNull(x, OntCEImpl.viewAsString(returnType) + ": null " + OntCEImpl.viewAsString(componentType) + " member")).iterator()));
        return (CE)((OntClass.ComponentsCE)model.getNodeAs(res.asNode(), returnType));
    }

    public static OntClass.HasSelf createHasSelf(OntGraphModelImpl model, OntObjectProperty onProperty) {
        Resource res = OntCEImpl.createOnPropertyRestriction(model, onProperty).addProperty(OWL.hasSelf, (RDFNode)Models.TRUE);
        return model.getNodeAs(res.asNode(), OntClass.HasSelf.class);
    }

    public static OntClass.ComplementOf createComplementOf(OntGraphModelImpl model, OntClass other) {
        OntJenaException.notNull(other, "Null class expression.");
        Resource res = model.createResource(OWL.Class).addProperty(OWL.complementOf, (RDFNode)other);
        return model.getNodeAs(res.asNode(), OntClass.ComplementOf.class);
    }

    public static OntIndividual.Anonymous createAnonymousIndividual(OntGraphModelImpl model, OntClass source) {
        return model.getNodeAs(model.createResource(source).asNode(), OntIndividual.Anonymous.class);
    }

    public static OntIndividual.Named createNamedIndividual(OntGraphModelImpl model, OntClass source, String uri) {
        OntIndividual.Named res = model.createIndividual(OntJenaException.notNull(uri, "Null uri"));
        res.attachClass(source);
        return res;
    }

    public static OntList<OntRealProperty> createHasKey(OntGraphModelImpl m, OntClass clazz, Stream<? extends OntRealProperty> collection) {
        return m.createOntList(clazz, OWL.hasKey, OntRealProperty.class, collection.distinct().map(OntRealProperty.class::cast).iterator());
    }

    public static Stream<OntList<OntRealProperty>> listHasKeys(OntGraphModelImpl m, OntClass clazz) {
        return OntListImpl.stream(m, clazz, OWL.hasKey, OntRealProperty.class);
    }

    public static void removeHasKey(OntGraphModelImpl model, OntClass clazz, RDFNode rdfList) throws OntJenaException.IllegalArgument {
        model.deleteOntList(clazz, OWL.hasKey, clazz.findHasKey(rdfList).orElse(null));
    }

    @Override
    public Optional<OntStatement> findRootStatement() {
        return OntCEImpl.getRequiredRootStatement(this, OWL.Class);
    }

    public abstract Class<? extends OntClass> getActualClass();

    @Override
    public OntIndividual.Anonymous createIndividual() {
        return OntCEImpl.createAnonymousIndividual(this.getModel(), this);
    }

    @Override
    public OntIndividual.Named createIndividual(String uri) {
        return OntCEImpl.createNamedIndividual(this.getModel(), this, uri);
    }

    @Override
    public OntList<OntRealProperty> createHasKey(Collection<OntObjectProperty> ope, Collection<OntDataProperty> dpe) {
        return OntCEImpl.createHasKey(this.getModel(), this, Stream.of(ope, dpe).flatMap(Collection::stream));
    }

    @Override
    public OntStatement addHasKeyStatement(OntRealProperty ... properties) {
        return OntCEImpl.createHasKey(this.getModel(), this, Arrays.stream(properties)).getMainStatement();
    }

    @Override
    public Stream<OntList<OntRealProperty>> hasKeys() {
        return OntCEImpl.listHasKeys(this.getModel(), this);
    }

    @Override
    public OntCEImpl removeHasKey(Resource list) throws OntJenaException.IllegalArgument {
        OntCEImpl.removeHasKey(this.getModel(), this, (RDFNode)list);
        return this;
    }

    @Override
    public Stream<OntClass> superClasses(boolean direct) {
        return OntCEImpl.hierarchy(this, OntClass.class, RDFS.subClassOf, false, direct);
    }

    @Override
    public Stream<OntClass> subClasses(boolean direct) {
        return OntCEImpl.hierarchy(this, OntClass.class, RDFS.subClassOf, true, direct);
    }

    public static class ClassExpressionFactory
    extends BaseFactoryImpl {
        private static final Node ANY = Node.ANY;
        private static final Node TYPE = RDF.Nodes.type;
        private static final Node CLASS = OWL.Class.asNode();
        private static final Node RESTRICTION = OWL.Restriction.asNode();
        private static final Node ON_PROPERTY = OWL.onProperty.asNode();
        private static final Node HAS_VALUE = OWL.hasValue.asNode();
        private static final Node QUALIFIED_CARDINALITY = OWL.qualifiedCardinality.asNode();
        private static final Node CARDINALITY = OWL.cardinality.asNode();
        private static final Node MIN_QUALIFIED_CARDINALITY = OWL.minQualifiedCardinality.asNode();
        private static final Node MIN_CARDINALITY = OWL.minCardinality.asNode();
        private static final Node MAX_QUALIFIED_CARDINALITY = OWL.maxQualifiedCardinality.asNode();
        private static final Node MAX_CARDINALITY = OWL.maxCardinality.asNode();
        private static final Node SOME_VALUES_FROM = OWL.someValuesFrom.asNode();
        private static final Node ALL_VALUES_FROM = OWL.allValuesFrom.asNode();
        private static final Node ON_CLASS = OWL.onClass.asNode();
        private static final Node ON_DATA_RANGE = OWL.onDataRange.asNode();
        private static final Node HAS_SELF = OWL.hasSelf.asNode();
        private static final Node ON_PROPERTIES = OWL.onProperties.asNode();
        private static final Node INTERSECTION_OF = OWL.intersectionOf.asNode();
        private static final Node UNION_OF = OWL.unionOf.asNode();
        private static final Node ONE_OF = OWL.oneOf.asNode();
        private static final Node COMPLEMENT_OF = OWL.complementOf.asNode();
        private static final Node TRUE = NodeFactory.createLiteralByValue((Object)Boolean.TRUE, (RDFDatatype)XSDDatatype.XSDboolean);
        private static final String NON_NEGATIVE_INTEGER_URI = XSD.nonNegativeInteger.getURI();
        protected static final Implementation LIST_FACTORY = RDFListImpl.factory;
        protected final ObjectFactory objectPropertyFactory = WrappedFactoryImpl.of(OntObjectProperty.class);
        protected final ObjectFactory dataPropertyFactory = WrappedFactoryImpl.of(OntDataProperty.class);

        public static ObjectFactory createFactory() {
            return new ClassExpressionFactory();
        }

        private static boolean isDataCardinality(Node n, EnhGraph eg, Node p, Node qp) {
            return ClassExpressionFactory.isCardinality(n, eg, p) || ClassExpressionFactory.isQualifiedCardinality(n, eg, qp, ON_DATA_RANGE, OntDataRange.class);
        }

        private static boolean isObjectCardinality(Node n, EnhGraph eg, Node p, Node qp) {
            return ClassExpressionFactory.isCardinality(n, eg, p) || ClassExpressionFactory.isQualifiedCardinality(n, eg, qp, ON_CLASS, OntClass.class);
        }

        private static boolean isQualifiedCardinality(Node n, EnhGraph eg, Node p, Node o, Class<? extends OntObject> t) {
            return ClassExpressionFactory.isCardinality(n, eg, p) && ClassExpressionFactory.isObjectOfType(n, eg, o, t);
        }

        private static boolean isCardinality(Node n, EnhGraph eg, Node p) {
            return Iter.findFirst(ClassExpressionFactory.objects(n, eg, p).filterKeep(x -> ClassExpressionFactory.isLiteral(x.getObject(), NON_NEGATIVE_INTEGER_URI))).isPresent();
        }

        private static boolean isList(Node n, EnhGraph eg, Node p) {
            return Iter.findFirst(ClassExpressionFactory.objects(n, eg, p).filterKeep(x -> LIST_FACTORY.canWrap(x.getObject(), eg))).isPresent();
        }

        private static boolean isLiteral(Node n, String dt) {
            return n.isLiteral() && dt.equals(n.getLiteralDatatypeURI());
        }

        private static boolean isObjectOfType(Node n, EnhGraph eg, Node p, Class<? extends OntObject> t) {
            return Iter.findFirst(ClassExpressionFactory.objects(n, eg, p).filterKeep(x -> ClassExpressionFactory.hasType(x.getObject(), eg, t))).isPresent();
        }

        private static boolean hasType(Node n, EnhGraph eg, Class<? extends OntObject> type) {
            return PersonalityModel.canAs(type, n, eg);
        }

        private static ExtendedIterator<Triple> objects(Node n, EnhGraph eg, Node p) {
            return eg.asGraph().find(n, p, ANY);
        }

        @Override
        public ExtendedIterator<EnhNode> iterator(EnhGraph g) {
            return g.asGraph().find(ANY, RDF.Nodes.type, CLASS).mapWith(t -> {
                Node n = t.getSubject();
                return n.isURI() ? ClassExpressionFactory.safeWrap(n, g, Factory.CLASS.factory) : ClassExpressionFactory.safeWrap(n, g, Factory.ANONYMOUS);
            }).andThen((Iterator)g.asGraph().find(ANY, RDF.Nodes.type, RESTRICTION).mapWith(t -> ClassExpressionFactory.safeWrap(t.getSubject(), g, Factory.RESTRICTIONS))).filterDrop(Objects::isNull);
        }

        @Override
        public EnhNode createInstance(Node node, EnhGraph eg) {
            Factory f = this.map(node, eg);
            if (f == null) {
                return null;
            }
            return f.factory.createInstance(node, eg);
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            return this.map(node, eg) != null;
        }

        @Override
        public EnhNode wrap(Node node, EnhGraph eg) throws OntJenaException {
            Factory f = this.map(node, eg);
            if (f == null) {
                throw new OntJenaException.Conversion("Can't convert node " + node + " to Class Expression.");
            }
            EnhNode res = f.factory.createInstance(node, eg);
            if (res == null) {
                throw new OntJenaException.IllegalState("Can't create Class Expression for node " + node);
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Factory map(Node n, EnhGraph eg) {
            if (n.isURI()) {
                if (!Factory.CLASS.factory.canWrap(n, eg)) return null;
                return Factory.CLASS;
            }
            if (!n.isBlank()) {
                return null;
            }
            Graph g = eg.asGraph();
            if (g.contains(n, TYPE, RESTRICTION)) {
                try (ExtendedIterator props = ClassExpressionFactory.objects(n, eg, ON_PROPERTY).mapWith(Triple::getObject);){
                    while (props.hasNext()) {
                        Node p = (Node)props.next();
                        if (this.objectPropertyFactory.canWrap(p, eg)) {
                            if (ClassExpressionFactory.isObjectOfType(n, eg, SOME_VALUES_FROM, OntClass.class)) {
                                Factory factory = Factory.OBJECT_SOME_VALUES_FROM;
                                return factory;
                            }
                            if (ClassExpressionFactory.isObjectOfType(n, eg, ALL_VALUES_FROM, OntClass.class)) {
                                Factory factory = Factory.OBJECT_ALL_VALUES_FROM;
                                return factory;
                            }
                            if (ClassExpressionFactory.isObjectCardinality(n, eg, MIN_CARDINALITY, MIN_QUALIFIED_CARDINALITY)) {
                                Factory factory = Factory.OBJECT_MIN_CARDINALITY;
                                return factory;
                            }
                            if (ClassExpressionFactory.isObjectCardinality(n, eg, MAX_CARDINALITY, MAX_QUALIFIED_CARDINALITY)) {
                                Factory factory = Factory.OBJECT_MAX_CARDINALITY;
                                return factory;
                            }
                            if (ClassExpressionFactory.isObjectCardinality(n, eg, CARDINALITY, QUALIFIED_CARDINALITY)) {
                                Factory factory = Factory.OBJECT_EXACT_CARDINALITY;
                                return factory;
                            }
                            if (ClassExpressionFactory.isObjectOfType(n, eg, HAS_VALUE, OntIndividual.class)) {
                                Factory factory = Factory.OBJECT_HAS_VALUE;
                                return factory;
                            }
                            if (Iter.findFirst(ClassExpressionFactory.objects(n, eg, HAS_SELF).filterKeep(x -> TRUE.equals((Object)x.getObject()))).isPresent()) {
                                Factory factory = Factory.OBJECT_HAS_SELF;
                                return factory;
                            }
                        }
                        if (!this.dataPropertyFactory.canWrap(p, eg)) continue;
                        if (ClassExpressionFactory.isObjectOfType(n, eg, SOME_VALUES_FROM, OntDataRange.class)) {
                            Factory factory = Factory.DATA_SOME_VALUES_FROM;
                            return factory;
                        }
                        if (ClassExpressionFactory.isObjectOfType(n, eg, ALL_VALUES_FROM, OntDataRange.class)) {
                            Factory factory = Factory.DATA_ALL_VALUES_FROM;
                            return factory;
                        }
                        if (ClassExpressionFactory.isDataCardinality(n, eg, MIN_CARDINALITY, MIN_QUALIFIED_CARDINALITY)) {
                            Factory factory = Factory.DATA_MIN_CARDINALITY;
                            return factory;
                        }
                        if (ClassExpressionFactory.isDataCardinality(n, eg, MAX_CARDINALITY, MAX_QUALIFIED_CARDINALITY)) {
                            Factory factory = Factory.DATA_MAX_CARDINALITY;
                            return factory;
                        }
                        if (ClassExpressionFactory.isDataCardinality(n, eg, CARDINALITY, QUALIFIED_CARDINALITY)) {
                            Factory factory = Factory.DATA_EXACT_CARDINALITY;
                            return factory;
                        }
                        if (!Iter.findFirst(ClassExpressionFactory.objects(n, eg, HAS_VALUE).filterKeep(x -> x.getObject().isLiteral())).isPresent()) continue;
                        Factory factory = Factory.DATA_HAS_VALUE;
                        return factory;
                    }
                }
                if (g.contains(n, ON_PROPERTIES, ANY)) {
                    if (Iter.findFirst(ClassExpressionFactory.objects(n, eg, SOME_VALUES_FROM)).isPresent()) {
                        return Factory.DATA_NARY_SOME_VALUES_FROM;
                    }
                    if (Iter.findFirst(ClassExpressionFactory.objects(n, eg, ALL_VALUES_FROM)).isPresent()) {
                        return Factory.DATA_NARY_ALL_VALUES_FROM;
                    }
                }
            }
            if (!g.contains(n, TYPE, CLASS)) return null;
            if (ClassExpressionFactory.isObjectOfType(n, eg, COMPLEMENT_OF, OntClass.class)) {
                return Factory.COMPLEMENT_OF;
            }
            if (ClassExpressionFactory.isList(n, eg, INTERSECTION_OF)) {
                return Factory.INTERSECTION_OF;
            }
            if (ClassExpressionFactory.isList(n, eg, UNION_OF)) {
                return Factory.UNION_OF;
            }
            if (!ClassExpressionFactory.isList(n, eg, ONE_OF)) return null;
            return Factory.ONE_OF;
        }

        static enum Factory {
            CLASS(OntClass.Named.class, false),
            OBJECT_SOME_VALUES_FROM(OntClass.ObjectSomeValuesFrom.class),
            OBJECT_ALL_VALUES_FROM(OntClass.ObjectAllValuesFrom.class),
            OBJECT_MIN_CARDINALITY(OntClass.ObjectMinCardinality.class),
            OBJECT_MAX_CARDINALITY(OntClass.ObjectMaxCardinality.class),
            OBJECT_EXACT_CARDINALITY(OntClass.ObjectCardinality.class),
            OBJECT_HAS_VALUE(OntClass.ObjectHasValue.class),
            OBJECT_HAS_SELF(OntClass.HasSelf.class),
            DATA_SOME_VALUES_FROM(OntClass.DataSomeValuesFrom.class),
            DATA_ALL_VALUES_FROM(OntClass.DataAllValuesFrom.class),
            DATA_MIN_CARDINALITY(OntClass.DataMinCardinality.class),
            DATA_MAX_CARDINALITY(OntClass.DataMaxCardinality.class),
            DATA_EXACT_CARDINALITY(OntClass.DataCardinality.class),
            DATA_HAS_VALUE(OntClass.DataHasValue.class),
            DATA_NARY_SOME_VALUES_FROM(OntClass.NaryDataSomeValuesFrom.class),
            DATA_NARY_ALL_VALUES_FROM(OntClass.NaryDataAllValuesFrom.class),
            UNION_OF(OntClass.UnionOf.class, false),
            INTERSECTION_OF(OntClass.IntersectionOf.class, false),
            ONE_OF(OntClass.OneOf.class, false),
            COMPLEMENT_OF(OntClass.ComplementOf.class, false);

            private static final Collection<ObjectFactory> RESTRICTIONS;
            private static final Collection<ObjectFactory> ANONYMOUS;
            private final ObjectFactory factory;
            private final boolean isRestriction;

            private Factory(Class<? extends OntObject> type) {
                this(type, true);
            }

            private Factory(Class<? extends OntObject> type, boolean restriction) {
                this.factory = WrappedFactoryImpl.of(type);
                this.isRestriction = restriction;
            }

            static {
                RESTRICTIONS = Arrays.stream(Factory.values()).filter(x -> x.isRestriction).map(x -> x.factory).collect(Iter.toUnmodifiableList());
                ANONYMOUS = Arrays.stream(Factory.values()).filter(x -> !x.isRestriction && CLASS != x).map(x -> x.factory).collect(Iter.toUnmodifiableList());
            }
        }
    }

    protected static class HasSelfMaker
    extends OntMaker.WithType {
        protected HasSelfMaker() {
            super(HasSelfImpl.class, OWL.Restriction);
        }

        @Override
        public void make(Node node, EnhGraph eg) {
            super.make(node, eg);
            eg.asGraph().add(Triple.create((Node)node, (Node)OWL.hasSelf.asNode(), (Node)Models.TRUE.asNode()));
        }
    }

    protected static class HasSelfFilter
    implements OntFilter {
        protected HasSelfFilter() {
        }

        @Override
        public boolean test(Node n, EnhGraph g) {
            return g.asGraph().contains(n, OWL.hasSelf.asNode(), Models.TRUE.asNode());
        }
    }

    protected static abstract class NaryRestrictionCEImpl<O extends OntObject, P extends OntRealProperty, R extends NaryRestrictionCEImpl<?, ?, ?>>
    extends OntCEImpl
    implements OntClass.NaryRestrictionCE<O, P> {
        protected final Property predicate;
        protected final Class<O> objectType;
        protected final Class<P> propertyType;

        protected NaryRestrictionCEImpl(Node n, EnhGraph m, Property predicate, Class<O> objectType, Class<P> propertyType) {
            super(n, m);
            this.predicate = predicate;
            this.objectType = objectType;
            this.propertyType = propertyType;
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return NaryRestrictionCEImpl.getRequiredRootStatement(this, OWL.Restriction);
        }

        @Override
        public O getValue() {
            return (O)((OntObject)this.getRequiredObject(this.predicate, this.objectType));
        }

        public R setValue(O value) {
            Objects.requireNonNull(value);
            this.removeAll(this.predicate).addProperty(this.predicate, value);
            return (R)this;
        }

        public R setComponents(Collection<P> properties) {
            NaryRestrictionCEImpl.validateArity((OntDataRange)this.getValue(), properties);
            ((OntListImpl)this.getList()).clear().addAll(properties);
            return (R)this;
        }

        @Override
        public Class<? extends OntClass> getActualClass() {
            return OntClass.NaryRestrictionCE.class;
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iter.concat(super.listSpec(), this.listRequired(this.predicate), ((OntListImpl)this.getList()).listContent());
        }

        @Override
        public OntListImpl<P> getList() {
            return this.getModel().asOntList(this.getRequiredObject(OWL.onProperties, RDFList.class), this, OWL.onProperties, this.propertyType);
        }

        public static void validateArity(OntDataRange dr, Collection<OntDataProperty> properties) {
            properties.forEach(x -> OntJenaException.notNull(x, "Null data property"));
            if (dr.arity() == properties.size()) {
                return;
            }
            throw new OntJenaException.IllegalArgument("The number of data properties (" + properties.size() + ") must be equal to the data range arity (" + dr.arity() + ").");
        }
    }

    protected static abstract class CardinalityRestrictionCEImpl<O extends OntObject, P extends OntRealProperty, R extends CardinalityRestrictionCEImpl<?, ?, ?>>
    extends ComponentRestrictionCEImpl<O, P, R>
    implements OntClass.CardinalityRestrictionCE<O, P> {
        protected final CardinalityType cardinalityType;

        protected CardinalityRestrictionCEImpl(Node n, EnhGraph m, Property predicate, Class<O> objectView, Class<P> propertyView, CardinalityType cardinalityType) {
            super(n, m, predicate, objectView, propertyView);
            this.cardinalityType = cardinalityType;
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            boolean q = this.isQualified();
            return Iter.concat(super.listSpec(q), this.listRequired(this.getCardinalityPredicate(q)));
        }

        @Override
        public O getValue() {
            return (O)this.object(this.predicate, this.objectView).orElseGet(this::getUnqualifiedValue);
        }

        private O getUnqualifiedValue() {
            OntGraphModelImpl m = this.getModel();
            return (O)(OntClass.class.isAssignableFrom(this.objectView) ? m.getOWLThing() : m.getRDFSLiteral());
        }

        @Override
        public R setValue(O value) {
            Literal c = this.getCardinalityLiteral();
            this.removeAll(this.predicate);
            if (!CardinalityRestrictionCEImpl.isQualified(value)) {
                this.removeAll(this.getCardinalityPredicate(true)).addProperty(this.getCardinalityPredicate(false), (RDFNode)c);
            } else {
                this.removeAll(this.getCardinalityPredicate(false)).addProperty(this.getCardinalityPredicate(true), (RDFNode)c).addProperty(this.predicate, value);
            }
            return (R)this;
        }

        @Override
        public int getCardinality() {
            return this.getCardinalityLiteral().getInt();
        }

        private Literal getCardinalityLiteral() {
            return this.getRequiredObject(this.getCardinalityPredicate(), Literal.class);
        }

        public R setCardinality(int cardinality) {
            Literal value = CardinalityRestrictionCEImpl.createNonNegativeIntegerLiteral(cardinality);
            Property property = this.getCardinalityPredicate();
            this.removeAll(property).addLiteral(property, value);
            return (R)this;
        }

        protected Property getCardinalityPredicate() {
            return this.getCardinalityPredicate(this.isQualified());
        }

        private Property getCardinalityPredicate(boolean q) {
            return this.cardinalityType.getPredicate(q);
        }

        @Override
        public boolean isQualified() {
            return CardinalityRestrictionCEImpl.isQualified(this.getValue()) && this.hasProperty(this.cardinalityType.getPredicate(true));
        }
    }

    protected static abstract class ComponentRestrictionCEImpl<O extends RDFNode, P extends OntRealProperty, R extends ComponentRestrictionCEImpl<?, ?, ?>>
    extends OnPropertyRestrictionCEImpl<P, R>
    implements OntClass.ComponentRestrictionCE<O, P> {
        protected final Property predicate;
        protected final Class<O> objectView;

        protected ComponentRestrictionCEImpl(Node n, EnhGraph m, Property predicate, Class<O> objectView, Class<P> propertyView) {
            super(n, m, propertyView);
            this.predicate = OntJenaException.notNull(predicate, "Null predicate.");
            this.objectView = OntJenaException.notNull(objectView, "Null object view.");
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return this.listSpec(true);
        }

        protected ExtendedIterator<OntStatement> listSpec(boolean requireObject) {
            return requireObject ? Iter.concat(super.listSpec(), this.listRequired(this.predicate)) : super.listSpec();
        }

        @Override
        public O getValue() {
            return this.getModel().getNodeAs(this.getRequiredProperty(this.predicate).getObject().asNode(), this.objectView);
        }

        public R setValue(O c) {
            Objects.requireNonNull(c, "Null filler");
            this.removeAll(this.predicate).addProperty(this.predicate, c);
            return (R)this;
        }
    }

    protected static abstract class OnPropertyRestrictionCEImpl<P extends OntRealProperty, R extends OntCEImpl>
    extends OntCEImpl
    implements OntClass.UnaryRestrictionCE<P> {
        protected final Class<P> propertyView;

        protected OnPropertyRestrictionCEImpl(Node n, EnhGraph m, Class<P> propertyType) {
            super(n, m);
            this.propertyView = propertyType;
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return OnPropertyRestrictionCEImpl.getRequiredRootStatement(this, OWL.Restriction);
        }

        @Override
        public P getProperty() {
            return (P)((OntRealProperty)this.getRequiredObject(OWL.onProperty, this.propertyView));
        }

        public R setProperty(P property) {
            Objects.requireNonNull(property, "Null " + OnPropertyRestrictionCEImpl.viewAsString(this.propertyView));
            this.removeAll(OWL.onProperty).addProperty(OWL.onProperty, property);
            return (R)this;
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iter.concat(super.listSpec(), this.listRequired(OWL.onProperty));
        }
    }

    protected static abstract class ComponentsCEImpl<O extends OntObject>
    extends OntCEImpl
    implements OntClass.ComponentsCE<O> {
        protected final Property predicate;
        protected final Class<O> type;

        protected ComponentsCEImpl(Node n, EnhGraph m, Property predicate, Class<O> type) {
            super(n, m);
            this.predicate = OntJenaException.notNull(predicate, "Null predicate.");
            this.type = OntJenaException.notNull(type, "Null view.");
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iter.concat(super.listSpec(), ((OntListImpl)this.getList()).listContent());
        }

        @Override
        public OntListImpl<O> getList() {
            return this.getModel().asOntList(this.getRequiredObject(this.predicate, RDFList.class), this, this.predicate, true, null, this.type);
        }
    }

    public static class NaryDataSomeValuesFromImpl
    extends NaryRestrictionCEImpl<OntDataRange, OntDataProperty, NaryDataSomeValuesFromImpl>
    implements OntClass.NaryDataSomeValuesFrom {
        public NaryDataSomeValuesFromImpl(Node n, EnhGraph m) {
            super(n, m, OWL.someValuesFrom, OntDataRange.class, OntDataProperty.class);
        }

        @Override
        public Class<? extends OntClass> getActualClass() {
            return OntClass.NaryDataSomeValuesFrom.class;
        }
    }

    public static class NaryDataAllValuesFromImpl
    extends NaryRestrictionCEImpl<OntDataRange, OntDataProperty, NaryDataAllValuesFromImpl>
    implements OntClass.NaryDataAllValuesFrom {
        public NaryDataAllValuesFromImpl(Node n, EnhGraph m) {
            super(n, m, OWL.allValuesFrom, OntDataRange.class, OntDataProperty.class);
        }

        @Override
        public Class<? extends OntClass> getActualClass() {
            return OntClass.NaryDataAllValuesFrom.class;
        }
    }

    public static class ComplementOfImpl
    extends OntCEImpl
    implements OntClass.ComplementOf {
        public ComplementOfImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iter.concat(super.listSpec(), this.listRequired(OWL.complementOf));
        }

        public Class<OntClass.ComplementOf> getActualClass() {
            return OntClass.ComplementOf.class;
        }

        @Override
        public OntClass getValue() {
            return this.getRequiredObject(OWL.complementOf, OntClass.class);
        }

        @Override
        public ComplementOfImpl setValue(OntClass c) {
            Objects.requireNonNull(c, "Null component");
            this.clear();
            this.addProperty(OWL.complementOf, (RDFNode)c);
            return this;
        }

        void clear() {
            this.removeAll(OWL.complementOf);
        }
    }

    public static class HasSelfImpl
    extends OnPropertyRestrictionCEImpl<OntObjectProperty, HasSelfImpl>
    implements OntClass.HasSelf {
        public HasSelfImpl(Node n, EnhGraph m) {
            super(n, m, OntObjectProperty.class);
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iter.concat(super.listSpec(), this.listRequired(OWL.hasSelf));
        }

        public Class<OntClass.HasSelf> getActualClass() {
            return OntClass.HasSelf.class;
        }
    }

    public static class ObjectCardinalityImpl
    extends CardinalityRestrictionCEImpl<OntClass, OntObjectProperty, ObjectCardinalityImpl>
    implements OntClass.ObjectCardinality {
        public ObjectCardinalityImpl(Node n, EnhGraph m) {
            super(n, m, OWL.onClass, OntClass.class, OntObjectProperty.class, CardinalityType.EXACTLY);
        }

        public Class<OntClass.ObjectCardinality> getActualClass() {
            return OntClass.ObjectCardinality.class;
        }
    }

    public static class DataCardinalityImpl
    extends CardinalityRestrictionCEImpl<OntDataRange, OntDataProperty, DataCardinalityImpl>
    implements OntClass.DataCardinality {
        public DataCardinalityImpl(Node n, EnhGraph m) {
            super(n, m, OWL.onDataRange, OntDataRange.class, OntDataProperty.class, CardinalityType.EXACTLY);
        }

        public Class<OntClass.DataCardinality> getActualClass() {
            return OntClass.DataCardinality.class;
        }
    }

    public static class ObjectMaxCardinalityImpl
    extends CardinalityRestrictionCEImpl<OntClass, OntObjectProperty, ObjectMaxCardinalityImpl>
    implements OntClass.ObjectMaxCardinality {
        public ObjectMaxCardinalityImpl(Node n, EnhGraph m) {
            super(n, m, OWL.onClass, OntClass.class, OntObjectProperty.class, CardinalityType.MAX);
        }

        public Class<OntClass.ObjectMaxCardinality> getActualClass() {
            return OntClass.ObjectMaxCardinality.class;
        }
    }

    public static class DataMaxCardinalityImpl
    extends CardinalityRestrictionCEImpl<OntDataRange, OntDataProperty, DataMaxCardinalityImpl>
    implements OntClass.DataMaxCardinality {
        public DataMaxCardinalityImpl(Node n, EnhGraph m) {
            super(n, m, OWL.onDataRange, OntDataRange.class, OntDataProperty.class, CardinalityType.MAX);
        }

        public Class<OntClass.DataMaxCardinality> getActualClass() {
            return OntClass.DataMaxCardinality.class;
        }
    }

    public static class ObjectMinCardinalityImpl
    extends CardinalityRestrictionCEImpl<OntClass, OntObjectProperty, ObjectMinCardinalityImpl>
    implements OntClass.ObjectMinCardinality {
        public ObjectMinCardinalityImpl(Node n, EnhGraph m) {
            super(n, m, OWL.onClass, OntClass.class, OntObjectProperty.class, CardinalityType.MIN);
        }

        public Class<OntClass.ObjectMinCardinality> getActualClass() {
            return OntClass.ObjectMinCardinality.class;
        }
    }

    public static class DataMinCardinalityImpl
    extends CardinalityRestrictionCEImpl<OntDataRange, OntDataProperty, DataMinCardinalityImpl>
    implements OntClass.DataMinCardinality {
        public DataMinCardinalityImpl(Node n, EnhGraph m) {
            super(n, m, OWL.onDataRange, OntDataRange.class, OntDataProperty.class, CardinalityType.MIN);
        }

        public Class<OntClass.DataMinCardinality> getActualClass() {
            return OntClass.DataMinCardinality.class;
        }
    }

    public static class OneOfImpl
    extends ComponentsCEImpl<OntIndividual>
    implements OntClass.OneOf {
        public OneOfImpl(Node n, EnhGraph m) {
            super(n, m, OWL.oneOf, OntIndividual.class);
        }

        public Class<OntClass.OneOf> getActualClass() {
            return OntClass.OneOf.class;
        }
    }

    public static class IntersectionOfImpl
    extends ComponentsCEImpl<OntClass>
    implements OntClass.IntersectionOf {
        public IntersectionOfImpl(Node n, EnhGraph m) {
            super(n, m, OWL.intersectionOf, OntClass.class);
        }

        public Class<OntClass.IntersectionOf> getActualClass() {
            return OntClass.IntersectionOf.class;
        }
    }

    public static class UnionOfImpl
    extends ComponentsCEImpl<OntClass>
    implements OntClass.UnionOf {
        public UnionOfImpl(Node n, EnhGraph m) {
            super(n, m, OWL.unionOf, OntClass.class);
        }

        public Class<OntClass.UnionOf> getActualClass() {
            return OntClass.UnionOf.class;
        }
    }

    public static class DataHasValueImpl
    extends ComponentRestrictionCEImpl<Literal, OntDataProperty, DataHasValueImpl>
    implements OntClass.DataHasValue {
        public DataHasValueImpl(Node n, EnhGraph m) {
            super(n, m, OWL.hasValue, Literal.class, OntDataProperty.class);
        }

        public Class<OntClass.DataHasValue> getActualClass() {
            return OntClass.DataHasValue.class;
        }
    }

    public static class ObjectHasValueImpl
    extends ComponentRestrictionCEImpl<OntIndividual, OntObjectProperty, ObjectHasValueImpl>
    implements OntClass.ObjectHasValue {
        public ObjectHasValueImpl(Node n, EnhGraph m) {
            super(n, m, OWL.hasValue, OntIndividual.class, OntObjectProperty.class);
        }

        public Class<OntClass.ObjectHasValue> getActualClass() {
            return OntClass.ObjectHasValue.class;
        }
    }

    public static class DataAllValuesFromImpl
    extends ComponentRestrictionCEImpl<OntDataRange, OntDataProperty, DataAllValuesFromImpl>
    implements OntClass.DataAllValuesFrom {
        public DataAllValuesFromImpl(Node n, EnhGraph m) {
            super(n, m, OWL.allValuesFrom, OntDataRange.class, OntDataProperty.class);
        }

        public Class<OntClass.DataAllValuesFrom> getActualClass() {
            return OntClass.DataAllValuesFrom.class;
        }
    }

    public static class ObjectAllValuesFromImpl
    extends ComponentRestrictionCEImpl<OntClass, OntObjectProperty, ObjectAllValuesFromImpl>
    implements OntClass.ObjectAllValuesFrom {
        public ObjectAllValuesFromImpl(Node n, EnhGraph m) {
            super(n, m, OWL.allValuesFrom, OntClass.class, OntObjectProperty.class);
        }

        public Class<OntClass.ObjectAllValuesFrom> getActualClass() {
            return OntClass.ObjectAllValuesFrom.class;
        }
    }

    public static class DataSomeValuesFromImpl
    extends ComponentRestrictionCEImpl<OntDataRange, OntDataProperty, DataSomeValuesFromImpl>
    implements OntClass.DataSomeValuesFrom {
        public DataSomeValuesFromImpl(Node n, EnhGraph m) {
            super(n, m, OWL.someValuesFrom, OntDataRange.class, OntDataProperty.class);
        }

        public Class<OntClass.DataSomeValuesFrom> getActualClass() {
            return OntClass.DataSomeValuesFrom.class;
        }
    }

    public static class ObjectSomeValuesFromImpl
    extends ComponentRestrictionCEImpl<OntClass, OntObjectProperty, ObjectSomeValuesFromImpl>
    implements OntClass.ObjectSomeValuesFrom {
        public ObjectSomeValuesFromImpl(Node n, EnhGraph m) {
            super(n, m, OWL.someValuesFrom, OntClass.class, OntObjectProperty.class);
        }

        public Class<OntClass.ObjectSomeValuesFrom> getActualClass() {
            return OntClass.ObjectSomeValuesFrom.class;
        }
    }

    private static interface PredicateFilterProvider {
        public Class<? extends RDFNode> view();

        default public OntFilter getFilter(Property predicate) {
            return (node, graph) -> this.testObjects(predicate, node, graph);
        }

        default public boolean testObjects(Property predicate, Node node, EnhGraph graph) {
            return Iter.anyMatch(graph.asGraph().find(node, predicate.asNode(), Node.ANY), t -> this.testObject(t.getObject(), graph));
        }

        default public boolean testObject(Node node, EnhGraph graph) {
            return PersonalityModel.canAs(this.view(), node, graph);
        }
    }

    protected static enum CardinalityType {
        EXACTLY(OWL.qualifiedCardinality, OWL.cardinality),
        MAX(OWL.maxQualifiedCardinality, OWL.maxCardinality),
        MIN(OWL.minQualifiedCardinality, OWL.minCardinality);

        static final RDFDatatype NON_NEGATIVE_INTEGER;
        protected final Property qualifiedPredicate;
        protected final Property predicate;
        protected static final Node CLASS_REFERENCE;
        protected static final Node RANGE_REFERENCE;

        private CardinalityType(Property qualifiedPredicate, Property predicate) {
            this.qualifiedPredicate = qualifiedPredicate;
            this.predicate = predicate;
        }

        public OntFilter getFilter(Class<? extends RDFNode> objectType) {
            return (n, g) -> this.isNonQualified(n, g) || this.isQualified(n, g, objectType);
        }

        public Property getPredicate(boolean isQualified) {
            return isQualified ? this.qualifiedPredicate : this.predicate;
        }

        private boolean isQualified(Node s, EnhGraph g, Class<? extends RDFNode> objectType) {
            Node p;
            if (!this.hasCardinality(s, this.qualifiedPredicate, g)) {
                return false;
            }
            if (objectType == OntClass.class) {
                p = CLASS_REFERENCE;
            } else if (objectType == OntDataRange.class) {
                p = RANGE_REFERENCE;
            } else {
                return false;
            }
            return Iter.findFirst(g.asGraph().find(s, p, Node.ANY).filterKeep(t -> CardinalityType.isObjectOfType(g, t.getObject(), objectType))).isPresent();
        }

        private boolean isNonQualified(Node s, EnhGraph g) {
            return this.hasCardinality(s, this.predicate, g);
        }

        private boolean hasCardinality(Node s, Property p, EnhGraph g) {
            return Iter.findFirst(g.asGraph().find(s, p.asNode(), Node.ANY).filterKeep(t -> CardinalityType.isNonNegativeInteger(t.getObject()))).isPresent();
        }

        private static boolean isObjectOfType(EnhGraph g, Node n, Class<? extends RDFNode> type) {
            return PersonalityModel.canAs(type, n, g);
        }

        public static boolean isNonNegativeInteger(Node n) {
            return n.isLiteral() && NON_NEGATIVE_INTEGER.equals(n.getLiteralDatatype());
        }

        static {
            NON_NEGATIVE_INTEGER = XSDDatatype.XSDnonNegativeInteger;
            CLASS_REFERENCE = OWL.onClass.asNode();
            RANGE_REFERENCE = OWL.onDataRange.asNode();
        }
    }

    protected static enum RestrictionType implements PredicateFilterProvider
    {
        DATA(OntDataProperty.class),
        OBJECT(OntObjectProperty.class);

        private final Class<? extends OntProperty> type;
        private final ObjectFactory propertyFactory;

        private RestrictionType(Class<? extends OntProperty> type) {
            this.type = type;
            this.propertyFactory = WrappedFactoryImpl.of(type);
        }

        public Class<? extends OntProperty> view() {
            return this.type;
        }

        public OntFilter getFilter() {
            return this.getFilter(OWL.onProperty);
        }

        @Override
        public boolean testObject(Node node, EnhGraph graph) {
            return this.propertyFactory.canWrap(node, graph);
        }
    }

    protected static enum ObjectRestrictionType implements PredicateFilterProvider
    {
        CLASS{

            public Class<OntClass> view() {
                return OntClass.class;
            }
        }
        ,
        DATA_RANGE{

            public Class<OntDataRange> view() {
                return OntDataRange.class;
            }
        }
        ,
        INDIVIDUAL{

            public Class<OntIndividual> view() {
                return OntIndividual.class;
            }
        }
        ,
        LITERAL{

            public Class<Literal> view() {
                return Literal.class;
            }

            @Override
            public boolean testObject(Node node, EnhGraph graph) {
                return node.isLiteral();
            }
        };

    }
}

