/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.Factories;
import com.github.owlcs.ontapi.jena.impl.OntGraphModelImpl;
import com.github.owlcs.ontapi.jena.impl.OntListImpl;
import com.github.owlcs.ontapi.jena.impl.OntObjectImpl;
import com.github.owlcs.ontapi.jena.impl.WrappedFactoryImpl;
import com.github.owlcs.ontapi.jena.impl.conf.BaseFactoryImpl;
import com.github.owlcs.ontapi.jena.impl.conf.ObjectFactory;
import com.github.owlcs.ontapi.jena.impl.conf.OntFilter;
import com.github.owlcs.ontapi.jena.impl.conf.OntFinder;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntFacetRestriction;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class OntDRImpl
extends OntObjectImpl
implements OntDataRange {
    private static final OntFinder DR_FINDER = new OntFinder.ByType(RDFS.Datatype);
    private static final OntFilter DR_FILTER = OntFilter.BLANK.and(new OntFilter.HasType(RDFS.Datatype));
    public static ObjectFactory oneOfDRFactory = Factories.createCommon(OneOfImpl.class, DR_FINDER, DR_FILTER.and(new OntFilter.HasPredicate(OWL.oneOf)), new OntFilter[0]);
    public static ObjectFactory restrictionDRFactory = Factories.createCommon(RestrictionImpl.class, DR_FINDER, DR_FILTER.and(new OntFilter.HasPredicate(OWL.onDatatype)).and(new OntFilter.HasPredicate(OWL.withRestrictions)), new OntFilter[0]);
    public static ObjectFactory complementOfDRFactory = Factories.createCommon(ComplementOfImpl.class, DR_FINDER, DR_FILTER.and(new OntFilter.HasPredicate(OWL.datatypeComplementOf)), new OntFilter[0]);
    public static ObjectFactory unionOfDRFactory = Factories.createCommon(UnionOfImpl.class, DR_FINDER, DR_FILTER.and(new OntFilter.HasPredicate(OWL.unionOf)), new OntFilter[0]);
    public static ObjectFactory intersectionOfDRFactory = Factories.createCommon(IntersectionOfImpl.class, DR_FINDER, DR_FILTER.and(new OntFilter.HasPredicate(OWL.intersectionOf)), new OntFilter[0]);
    public static ObjectFactory abstractComponentsDRFactory = Factories.createFrom(DR_FINDER, OntDataRange.OneOf.class, OntDataRange.Restriction.class, OntDataRange.UnionOf.class, OntDataRange.IntersectionOf.class);
    public static ObjectFactory abstractDRFactory = DataRangeFactory.createFactory();

    public OntDRImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    private static Resource create(OntGraphModelImpl model) {
        return model.createResource().addProperty(RDF.type, (RDFNode)RDFS.Datatype);
    }

    public static OntDataRange.OneOf createOneOf(OntGraphModelImpl model, Stream<Literal> values) {
        OntJenaException.notNull(values, "Null values stream.");
        Resource res = OntDRImpl.create(model).addProperty(OWL.oneOf, (RDFNode)model.createList(values.peek(f -> OntJenaException.notNull(f, "OntDR: null literal.")).iterator()));
        return model.getNodeAs(res.asNode(), OntDataRange.OneOf.class);
    }

    public static OntDataRange.Restriction createRestriction(OntGraphModelImpl model, OntDataRange.Named dataType, Stream<OntFacetRestriction> values) {
        OntJenaException.notNull(dataType, "Null data-type.");
        OntJenaException.notNull(values, "Null values stream.");
        Resource res = OntDRImpl.create(model).addProperty(OWL.onDatatype, (RDFNode)dataType).addProperty(OWL.withRestrictions, (RDFNode)model.createList(values.peek(f -> OntJenaException.notNull(f, "OntDR: null faced restriction.")).iterator()));
        return model.getNodeAs(res.asNode(), OntDataRange.Restriction.class);
    }

    public static OntDataRange.ComplementOf createComplementOf(OntGraphModelImpl model, OntDataRange other) {
        OntJenaException.notNull(other, "Null data range.");
        Resource res = OntDRImpl.create(model).addProperty(OWL.datatypeComplementOf, (RDFNode)other);
        return model.getNodeAs(res.asNode(), OntDataRange.ComplementOf.class);
    }

    public static OntDataRange.UnionOf createUnionOf(OntGraphModelImpl model, Stream<OntDataRange> values) {
        OntJenaException.notNull(values, "Null values stream.");
        Resource res = OntDRImpl.create(model).addProperty(OWL.unionOf, (RDFNode)model.createList(values.peek(f -> OntJenaException.notNull(f, "OntDR: null data range.")).iterator()));
        return model.getNodeAs(res.asNode(), OntDataRange.UnionOf.class);
    }

    public static OntDataRange.IntersectionOf createIntersectionOf(OntGraphModelImpl model, Stream<OntDataRange> values) {
        OntJenaException.notNull(values, "Null values stream.");
        Resource res = OntDRImpl.create(model).addProperty(OWL.intersectionOf, (RDFNode)model.createList(values.peek(f -> OntJenaException.notNull(f, "OntDR: null data range.")).iterator()));
        return model.getNodeAs(res.asNode(), OntDataRange.IntersectionOf.class);
    }

    @Override
    public Optional<OntStatement> findRootStatement() {
        return OntDRImpl.getRequiredRootStatement(this, RDFS.Datatype);
    }

    public static class DataRangeFactory
    extends BaseFactoryImpl {
        private static final Node TYPE = RDF.Nodes.type;
        private static final Node ANY = Node.ANY;
        private static final Node DATATYPE = RDFS.Datatype.asNode();
        private final ObjectFactory named = WrappedFactoryImpl.of(OntDataRange.Named.class);
        private final ObjectFactory oneOf = WrappedFactoryImpl.of(OntDataRange.OneOf.class);
        private final ObjectFactory complementOf = WrappedFactoryImpl.of(OntDataRange.ComplementOf.class);
        private final ObjectFactory unionOf = WrappedFactoryImpl.of(OntDataRange.UnionOf.class);
        private final ObjectFactory intersectionOf = WrappedFactoryImpl.of(OntDataRange.IntersectionOf.class);
        private final ObjectFactory restriction = WrappedFactoryImpl.of(OntDataRange.Restriction.class);
        private final List<ObjectFactory> anonymous = Stream.of(this.complementOf, this.restriction, this.oneOf, this.unionOf, this.intersectionOf).collect(Collectors.toList());

        public static ObjectFactory createFactory() {
            return new DataRangeFactory();
        }

        @Override
        public ExtendedIterator<EnhNode> iterator(EnhGraph eg) {
            return eg.asGraph().find(ANY, TYPE, DATATYPE).mapWith(t -> t.getSubject().isURI() ? DataRangeFactory.safeWrap(t.getSubject(), eg, this.named) : DataRangeFactory.safeWrap(t.getSubject(), eg, this.anonymous)).filterDrop(Objects::isNull);
        }

        @Override
        public EnhNode createInstance(Node node, EnhGraph eg) {
            if (node.isURI()) {
                return DataRangeFactory.safeWrap(node, eg, this.named);
            }
            if (!node.isBlank()) {
                return null;
            }
            if (!eg.asGraph().contains(node, TYPE, DATATYPE)) {
                return null;
            }
            return DataRangeFactory.safeWrap(node, eg, this.anonymous);
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            if (node.isURI()) {
                return this.named.canWrap(node, eg);
            }
            if (!node.isBlank()) {
                return false;
            }
            if (!eg.asGraph().contains(node, TYPE, DATATYPE)) {
                return false;
            }
            return DataRangeFactory.canWrap(node, eg, this.anonymous);
        }

        @Override
        public EnhNode wrap(Node node, EnhGraph eg) {
            if (node.isURI()) {
                return this.named.wrap(node, eg);
            }
            OntJenaException.Conversion ex = new OntJenaException.Conversion("Can't convert node " + node + " to Data Range Expression.");
            if (!node.isBlank()) {
                throw ex;
            }
            if (!eg.asGraph().contains(node, TYPE, DATATYPE)) {
                throw ex;
            }
            return DataRangeFactory.wrap(node, eg, ex, this.anonymous);
        }
    }

    protected static abstract class ComponentsDRImpl<N extends RDFNode>
    extends OntDRImpl
    implements OntDataRange.ComponentsDR<N> {
        protected final Property predicate;
        protected final Class<N> type;

        protected ComponentsDRImpl(Node n, EnhGraph m, Property predicate, Class<N> type) {
            super(n, m);
            this.predicate = OntJenaException.notNull(predicate, "Null predicate.");
            this.type = OntJenaException.notNull(type, "Null view.");
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iter.concat(this.listDeclaration(), ((OntListImpl)this.getList()).listContent());
        }

        public ExtendedIterator<OntStatement> listDeclaration() {
            return super.listSpec();
        }

        @Override
        public OntListImpl<N> getList() {
            return this.getModel().asOntList(this.getRequiredObject(this.predicate, RDFList.class), this, this.predicate, true, null, this.type);
        }
    }

    public static class IntersectionOfImpl
    extends ComponentsDRImpl<OntDataRange>
    implements OntDataRange.IntersectionOf {
        public IntersectionOfImpl(Node n, EnhGraph m) {
            super(n, m, OWL.intersectionOf, OntDataRange.class);
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntDataRange.IntersectionOf.class;
        }
    }

    public static class UnionOfImpl
    extends ComponentsDRImpl<OntDataRange>
    implements OntDataRange.UnionOf {
        public UnionOfImpl(Node n, EnhGraph m) {
            super(n, m, OWL.unionOf, OntDataRange.class);
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntDataRange.UnionOf.class;
        }
    }

    public static class RestrictionImpl
    extends ComponentsDRImpl<OntFacetRestriction>
    implements OntDataRange.Restriction {
        public RestrictionImpl(Node n, EnhGraph m) {
            super(n, m, OWL.withRestrictions, OntFacetRestriction.class);
        }

        public Class<OntDataRange.Restriction> getActualClass() {
            return OntDataRange.Restriction.class;
        }

        @Override
        public OntDataRange.Named getValue() {
            return this.getRequiredObject(OWL.onDatatype, OntDataRange.Named.class);
        }

        @Override
        public RestrictionImpl setValue(OntDataRange.Named value) {
            Objects.requireNonNull(value);
            this.removeAll(OWL.onDatatype).addProperty(OWL.onDatatype, (RDFNode)value);
            return this;
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iter.concat(this.listDeclaration(), this.listRequired(OWL.onDatatype), this.withRestrictionsSpec());
        }

        public ExtendedIterator<OntStatement> withRestrictionsSpec() {
            return Iter.flatMap(this.getList().listContent(), s -> {
                if (!s.getObject().canAs(OntFacetRestriction.class)) {
                    return Iter.of(s);
                }
                return Iter.of(new OntStatement[]{s, ((OntFacetRestriction)s.getObject().as(OntFacetRestriction.class)).getMainStatement()});
            });
        }
    }

    public static class OneOfImpl
    extends ComponentsDRImpl<Literal>
    implements OntDataRange.OneOf {
        public OneOfImpl(Node n, EnhGraph m) {
            super(n, m, OWL.oneOf, Literal.class);
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntDataRange.OneOf.class;
        }
    }

    public static class ComplementOfImpl
    extends OntDRImpl
    implements OntDataRange.ComplementOf {
        public ComplementOfImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public OntDataRange getValue() {
            return this.getRequiredObject(OWL.datatypeComplementOf, OntDataRange.class);
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iter.concat(super.listSpec(), this.listRequired(OWL.datatypeComplementOf));
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntDataRange.ComplementOf.class;
        }

        @Override
        public OntDataRange.ComplementOf setValue(OntDataRange value) {
            Objects.requireNonNull(value);
            this.removeAll(OWL.datatypeComplementOf).addProperty(OWL.datatypeComplementOf, (RDFNode)value);
            return this;
        }
    }
}

