/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.Factories;
import com.github.owlcs.ontapi.jena.impl.OntGraphModelImpl;
import com.github.owlcs.ontapi.jena.impl.OntObjectImpl;
import com.github.owlcs.ontapi.jena.impl.PersonalityModel;
import com.github.owlcs.ontapi.jena.impl.conf.ObjectFactory;
import com.github.owlcs.ontapi.jena.impl.conf.OntFilter;
import com.github.owlcs.ontapi.jena.impl.conf.OntFinder;
import com.github.owlcs.ontapi.jena.impl.conf.OntPersonality;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntNegativeAssertion;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import com.github.owlcs.ontapi.jena.vocabulary.SWRL;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public abstract class OntIndividualImpl
extends OntObjectImpl
implements OntIndividual {
    private static final String FORBIDDEN_SUBJECTS = OntIndividual.Anonymous.class.getName() + ".InSubject";
    private static final String FORBIDDEN_OBJECTS = OntIndividual.Anonymous.class.getName() + ".InObject";
    private static final Set<Node> FOR_SUBJECT = Stream.of(OWL.sameAs, OWL.differentFrom).map(FrontsNode::asNode).collect(Iter.toUnmodifiableSet());
    private static final Set<Node> FOR_OBJECT = Stream.of(OWL.sameAs, OWL.differentFrom, OWL.sourceIndividual, OWL.targetIndividual, OWL.hasValue, OWL.annotatedSource, OWL.annotatedTarget, RDF.first, SWRL.argument1, SWRL.argument2).map(FrontsNode::asNode).collect(Iter.toUnmodifiableSet());
    public static OntFinder FINDER = OntFinder.ANY_SUBJECT_AND_OBJECT;
    public static ObjectFactory anonymousIndividualFactory = Factories.createCommon(AnonymousImpl.class, FINDER, OntIndividualImpl::testAnonymousIndividual, new OntFilter[0]);
    public static ObjectFactory abstractIndividualFactory = Factories.createFrom(FINDER, OntIndividual.Named.class, OntIndividual.Anonymous.class);

    public OntIndividualImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    @Override
    public Stream<OntClass> classes() {
        return Iter.asStream(this.listClasses(), this.getCharacteristics());
    }

    @Override
    public Stream<OntClass> classes(boolean direct) {
        return Iter.fromSet(() -> this.getClasses(direct));
    }

    public ExtendedIterator<OntClass> listClasses() {
        return this.listObjects(RDF.type, OntClass.class);
    }

    public ExtendedIterator<OntClass> listClasses(boolean direct) {
        return Iter.create(() -> this.getClasses(direct).iterator());
    }

    public Set<OntClass> getClasses(boolean direct) {
        if (direct) {
            return this.listClasses().toSet();
        }
        HashSet<OntClass> res = new HashSet<OntClass>();
        Function<OntClass, ExtendedIterator> listSuperClasses = x -> ((OntObjectImpl)((Object)x)).listObjects(RDFS.subClassOf, OntClass.class);
        this.listObjects(RDF.type, OntClass.class).forEachRemaining(c -> OntIndividualImpl.collectIndirect(c, listSuperClasses, res));
        return res;
    }

    @Override
    public boolean isLocal() {
        Optional<OntStatement> root = this.findRootStatement();
        return root.isPresent() && root.get().isLocal() || this.hasLocalClassAssertions();
    }

    protected boolean hasLocalClassAssertions() {
        return Iter.findFirst(this.listClassAssertions().filterKeep(OntStatement::isLocal)).isPresent();
    }

    public ExtendedIterator<OntStatement> listClassAssertions() {
        return this.listStatements(RDF.type).filterKeep(s -> s.getObject().canAs(OntClass.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testAnonymousIndividual(Node node, EnhGraph eg) {
        if (!node.isBlank()) {
            return false;
        }
        boolean hasType = false;
        try (ExtendedIterator types = eg.asGraph().find(node, RDF.Nodes.type, Node.ANY).mapWith(Triple::getObject);){
            while (types.hasNext()) {
                if (PersonalityModel.canAs(OntClass.class, (Node)types.next(), eg)) {
                    boolean bl = true;
                    return bl;
                }
                hasType = true;
            }
        }
        if (hasType) {
            return false;
        }
        OntPersonality personality = PersonalityModel.asPersonalityModel(eg).getOntPersonality();
        OntPersonality.Builtins builtins = personality.getBuiltins();
        OntPersonality.Reserved reserved = personality.getReserved();
        Set<Node> forbiddenSubjects = reserved.get(FORBIDDEN_SUBJECTS, () -> {
            Set<Node> bSet = builtins.getProperties();
            return reserved.getProperties().stream().filter(n -> !bSet.contains(n)).filter(n -> !FOR_SUBJECT.contains(n)).collect(Iter.toUnmodifiableSet());
        });
        try (ExtendedIterator bySubject = eg.asGraph().find(node, Node.ANY, Node.ANY).mapWith(Triple::getPredicate);){
            while (bySubject.hasNext()) {
                if (!forbiddenSubjects.contains(bySubject.next())) continue;
                boolean bl = false;
                return bl;
            }
        }
        Set<Node> forbiddenObjects = reserved.get(FORBIDDEN_OBJECTS, () -> {
            Set<Node> bSet = builtins.getProperties();
            return reserved.getProperties().stream().filter(n -> !bSet.contains(n)).filter(n -> !FOR_OBJECT.contains(n)).collect(Iter.toUnmodifiableSet());
        });
        try (ExtendedIterator byObject = eg.asGraph().find(Node.ANY, Node.ANY, node).mapWith(Triple::getPredicate);){
            while (byObject.hasNext()) {
                if (!forbiddenObjects.contains(byObject.next())) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public static OntIndividual.Anonymous createAnonymousIndividual(RDFNode node) {
        if (OntJenaException.notNull(node, "Null node.").canAs(OntIndividual.Anonymous.class)) {
            return (OntIndividual.Anonymous)node.as(OntIndividual.Anonymous.class);
        }
        if (node.isAnon()) {
            return new AnonymousImpl(node.asNode(), (EnhGraph)node.getModel());
        }
        throw new OntJenaException.Conversion(node + " could not be " + OntIndividual.Anonymous.class);
    }

    @Override
    public Stream<OntNegativeAssertion> negativeAssertions() {
        return Iter.asStream(this.listNegativeAssertions(), this.getCharacteristics());
    }

    public ExtendedIterator<OntNegativeAssertion> listNegativeAssertions() {
        return this.listSubjects(OWL.sourceIndividual, OntNegativeAssertion.class);
    }

    @Override
    protected Set<OntStatement> getContent() {
        Set<OntStatement> res = super.getContent();
        this.listNegativeAssertions().forEachRemaining(x -> res.addAll(((OntObjectImpl)((Object)x)).getContent()));
        return res;
    }

    public static class AnonymousImpl
    extends OntIndividualImpl
    implements OntIndividual.Anonymous {
        public AnonymousImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public boolean isLocal() {
            return this.hasLocalClassAssertions();
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return Optional.empty();
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntIndividual.Anonymous.class;
        }

        @Override
        public AnonymousImpl detachClass(Resource clazz) {
            Set classes = this.classes().collect(Collectors.toSet());
            if (clazz == null && !classes.isEmpty()) {
                throw new OntJenaException.IllegalState("Detaching classes is prohibited: the anonymous individual (" + this + ") should contain at least one class assertion, otherwise it can be lost");
            }
            if (classes.size() == 1 && ((OntClass)classes.iterator().next()).equals(clazz)) {
                throw new OntJenaException.IllegalState("Detaching class (" + clazz + ") is prohibited: it is a single class assertion for the individual " + this + ".");
            }
            this.remove(RDF.type, (RDFNode)clazz);
            return this;
        }
    }

    public static class NamedImpl
    extends OntIndividualImpl
    implements OntIndividual.Named {
        public NamedImpl(Node n, EnhGraph m) {
            super(OntObjectImpl.checkNamed(n), m);
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return Optional.of(this.getModel().createStatement(this, RDF.type, (RDFNode)OWL.NamedIndividual).asRootStatement()).filter(r -> this.getModel().contains((Statement)r));
        }

        @Override
        public boolean isBuiltIn() {
            return false;
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntIndividual.Named.class;
        }

        @Override
        public NamedImpl detachClass(Resource clazz) {
            OntGraphModelImpl m = this.getModel();
            m.listOntStatements(this, RDF.type, (RDFNode)clazz).filterDrop(s -> OWL.NamedIndividual.equals((Object)s.getObject())).toList().forEach(s -> m.remove(s.clearAnnotations()));
            return this;
        }
    }
}

