/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl;

import com.github.owlcs.ontapi.jena.impl.Factories;
import com.github.owlcs.ontapi.jena.impl.OntGraphModelImpl;
import com.github.owlcs.ontapi.jena.impl.OntObjectImpl;
import com.github.owlcs.ontapi.jena.impl.conf.ObjectFactory;
import com.github.owlcs.ontapi.jena.impl.conf.OntFilter;
import com.github.owlcs.ontapi.jena.impl.conf.OntFinder;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntNegativeAssertion;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntRealProperty;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.util.Optional;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;

public abstract class OntNPAImpl<P extends OntRealProperty, T extends RDFNode>
extends OntObjectImpl
implements OntNegativeAssertion<P, T> {
    private static final OntFinder NPA_FINDER = new OntFinder.ByType(OWL.NegativePropertyAssertion);
    private static final OntFilter NPA_FILTER = OntFilter.BLANK.and(new OntFilter.HasPredicate(OWL.sourceIndividual)).and(new OntFilter.HasPredicate(OWL.assertionProperty));
    public static ObjectFactory objectNPAFactory = Factories.createCommon(ObjectAssertionImpl.class, NPA_FINDER, NPA_FILTER, new OntFilter.HasPredicate(OWL.targetIndividual));
    public static ObjectFactory dataNPAFactory = Factories.createCommon(DataAssertionImpl.class, NPA_FINDER, NPA_FILTER, new OntFilter.HasPredicate(OWL.targetValue));
    public static ObjectFactory abstractNPAFactory = Factories.createFrom(NPA_FINDER, OntNegativeAssertion.WithObjectProperty.class, OntNegativeAssertion.WithDataProperty.class);

    public OntNPAImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    public static OntNegativeAssertion.WithDataProperty create(OntGraphModelImpl model, OntIndividual source, OntDataProperty property, Literal target) {
        Resource res = OntNPAImpl.create(model, source).addProperty(OWL.assertionProperty, (RDFNode)property).addProperty(OWL.targetValue, (RDFNode)target);
        return model.getNodeAs(res.asNode(), OntNegativeAssertion.WithDataProperty.class);
    }

    public static OntNegativeAssertion.WithObjectProperty create(OntGraphModelImpl model, OntIndividual source, OntObjectProperty property, OntIndividual target) {
        Resource res = OntNPAImpl.create(model, source).addProperty(OWL.assertionProperty, (RDFNode)property).addProperty(OWL.targetIndividual, (RDFNode)target);
        return model.getNodeAs(res.asNode(), OntNegativeAssertion.WithObjectProperty.class);
    }

    @Override
    public Optional<OntStatement> findRootStatement() {
        return OntNPAImpl.getRequiredRootStatement(this, OWL.NegativePropertyAssertion);
    }

    @Override
    public ExtendedIterator<OntStatement> listSpec() {
        return Iter.concat(super.listSpec(), this.listRequired(OWL.sourceIndividual, OWL.assertionProperty, this.targetPredicate()));
    }

    abstract Class<P> propertyClass();

    abstract Property targetPredicate();

    @Override
    public OntIndividual getSource() {
        return this.getRequiredObject(OWL.sourceIndividual, OntIndividual.class);
    }

    @Override
    public P getProperty() {
        return (P)((OntRealProperty)this.getRequiredObject(OWL.assertionProperty, this.propertyClass()));
    }

    private static Resource create(OntModel model, OntIndividual source) {
        Resource res = model.createResource();
        res.addProperty(RDF.type, (RDFNode)OWL.NegativePropertyAssertion);
        res.addProperty(OWL.sourceIndividual, (RDFNode)source);
        return res;
    }

    public static class DataAssertionImpl
    extends OntNPAImpl<OntDataProperty, Literal>
    implements OntNegativeAssertion.WithDataProperty {
        public DataAssertionImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        Class<OntDataProperty> propertyClass() {
            return OntDataProperty.class;
        }

        @Override
        Property targetPredicate() {
            return OWL.targetValue;
        }

        public Class<OntNegativeAssertion.WithDataProperty> getActualClass() {
            return OntNegativeAssertion.WithDataProperty.class;
        }

        @Override
        public Literal getTarget() {
            return this.getRequiredObject(this.targetPredicate(), Literal.class);
        }
    }

    public static class ObjectAssertionImpl
    extends OntNPAImpl<OntObjectProperty, OntIndividual>
    implements OntNegativeAssertion.WithObjectProperty {
        public ObjectAssertionImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        Class<OntObjectProperty> propertyClass() {
            return OntObjectProperty.class;
        }

        @Override
        Property targetPredicate() {
            return OWL.targetIndividual;
        }

        public Class<OntNegativeAssertion.WithObjectProperty> getActualClass() {
            return OntNegativeAssertion.WithObjectProperty.class;
        }

        @Override
        public OntIndividual getTarget() {
            return this.getRequiredObject(this.targetPredicate(), OntIndividual.class);
        }
    }
}

