/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.OntGraphModelImpl;
import com.github.owlcs.ontapi.jena.impl.OntListImpl;
import com.github.owlcs.ontapi.jena.impl.OntNPAImpl;
import com.github.owlcs.ontapi.jena.impl.OntPEImpl;
import com.github.owlcs.ontapi.jena.impl.OntStatementImpl;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntList;
import com.github.owlcs.ontapi.jena.model.OntNegativeAssertion;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDFS;

public abstract class OntOPEImpl
extends OntPEImpl
implements OntObjectProperty {
    public OntOPEImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    @Override
    public Stream<OntObjectProperty> superProperties(boolean direct) {
        return OntOPEImpl.hierarchy(this, OntObjectProperty.class, RDFS.subPropertyOf, false, direct);
    }

    @Override
    public Stream<OntObjectProperty> subProperties(boolean direct) {
        return OntOPEImpl.hierarchy(this, OntObjectProperty.class, RDFS.subPropertyOf, true, direct);
    }

    @Override
    public OntNegativeAssertion.WithObjectProperty addNegativeAssertion(OntIndividual source, OntIndividual target) {
        return OntNPAImpl.create(this.getModel(), source, this, target);
    }

    @Override
    public OntList<OntObjectProperty> createPropertyChain(Collection<OntObjectProperty> properties) {
        return this.getModel().createOntList(this, OWL.propertyChainAxiom, OntObjectProperty.class, properties.iterator());
    }

    @Override
    public Stream<OntList<OntObjectProperty>> propertyChains() {
        return OntListImpl.stream(this.getModel(), this, OWL.propertyChainAxiom, OntObjectProperty.class);
    }

    @Override
    public OntOPEImpl removePropertyChain(Resource rdfList) throws OntJenaException.IllegalArgument {
        this.getModel().deleteOntList(this, OWL.propertyChainAxiom, this.findPropertyChain((RDFNode)rdfList).orElse(null));
        return this;
    }

    @Override
    protected OntOPEImpl changeRDFType(Resource type, boolean add) {
        super.changeRDFType(type, add);
        return this;
    }

    @Override
    public OntOPEImpl setFunctional(boolean functional) {
        return this.changeRDFType(OWL.FunctionalProperty, functional);
    }

    @Override
    public OntOPEImpl setInverseFunctional(boolean inverseFunctional) {
        return this.changeRDFType(OWL.InverseFunctionalProperty, inverseFunctional);
    }

    @Override
    public OntOPEImpl setSymmetric(boolean symmetric) {
        return this.changeRDFType(OWL.SymmetricProperty, symmetric);
    }

    @Override
    public OntOPEImpl setAsymmetric(boolean asymmetric) {
        return this.changeRDFType(OWL.AsymmetricProperty, asymmetric);
    }

    @Override
    public OntOPEImpl setTransitive(boolean transitive) {
        return this.changeRDFType(OWL.TransitiveProperty, transitive);
    }

    @Override
    public OntOPEImpl setReflexive(boolean reflexive) {
        return this.changeRDFType(OWL.ReflexiveProperty, reflexive);
    }

    @Override
    public OntOPEImpl setIrreflexive(boolean irreflexive) {
        return this.changeRDFType(OWL.IrreflexiveProperty, irreflexive);
    }

    public static class InversePropertyImpl
    extends OntOPEImpl
    implements OntObjectProperty.Inverse {
        public InversePropertyImpl(Node n, EnhGraph g) {
            super(n, g);
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return Optional.of(this.getModel().createStatement(this, OWL.inverseOf, (RDFNode)this.getDirect()).asRootStatement());
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntObjectProperty.Inverse.class;
        }

        @Override
        public OntObjectProperty.Named getDirect() {
            OntGraphModelImpl m = this.getModel();
            List res = Iter.distinct(this.listObjects(OWL.inverseOf, Resource.class).filterKeep(RDFNode::isURIResource)).toList();
            if (res.size() != 1) {
                throw new OntJenaException.IllegalState("Expected one and only one owl:inverseOf statement, but found: [" + this + " owl:inverseOf " + res + "]");
            }
            return m.getNodeAs(((Resource)res.get(0)).asNode(), OntObjectProperty.Named.class);
        }

        @Override
        public Property asProperty() {
            return this.getDirect().asProperty();
        }
    }

    public static class NamedPropertyImpl
    extends OntOPEImpl
    implements OntObjectProperty.Named {
        public NamedPropertyImpl(Node n, EnhGraph g) {
            super(n, g);
        }

        @Override
        public OntObjectProperty.Inverse createInverse() {
            OntGraphModelImpl m = this.getModel();
            List nodes = m.localStatements(null, OWL.inverseOf, (RDFNode)this).map(OntStatement::getSubject).filter(RDFNode::isAnon).map(FrontsNode::asNode).distinct().collect(Collectors.toList());
            if (nodes.size() > 1) {
                throw new OntJenaException.IllegalState("More than one inverse-of object properties found: [" + nodes + " owl:inverseOf " + this + "]");
            }
            Node n = nodes.isEmpty() ? m.createResource().addProperty(OWL.inverseOf, (RDFNode)this).asNode() : (Node)nodes.get(0);
            return m.getNodeAs(n, OntObjectProperty.Inverse.class);
        }

        @Override
        public boolean isBuiltIn() {
            return this.getModel().isBuiltIn(this);
        }

        public Class<OntObjectProperty.Named> getActualClass() {
            return OntObjectProperty.Named.class;
        }

        public Property inModel(Model m) {
            return this.getModel() == m ? this : m.createProperty(this.getURI());
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return NamedPropertyImpl.getOptionalRootStatement(this, OWL.ObjectProperty);
        }

        public int getOrdinal() {
            return OntStatementImpl.createProperty(this.node, this.enhGraph).getOrdinal();
        }
    }
}

