/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.Factories;
import com.github.owlcs.ontapi.jena.impl.OntAnnotationImpl;
import com.github.owlcs.ontapi.jena.impl.OntGraphModelImpl;
import com.github.owlcs.ontapi.jena.impl.OntStatementImpl;
import com.github.owlcs.ontapi.jena.impl.conf.ObjectFactory;
import com.github.owlcs.ontapi.jena.impl.conf.OntFilter;
import com.github.owlcs.ontapi.jena.impl.conf.OntFinder;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PropertyNotFoundException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;

public class OntObjectImpl
extends ResourceImpl
implements OntObject {
    public static ObjectFactory objectFactory = Factories.createCommon(OntObjectImpl.class, OntFinder.ANY_SUBJECT, OntFilter.URI.or(OntFilter.BLANK), new OntFilter[0]);

    public OntObjectImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    protected static Optional<OntStatement> getRequiredRootStatement(OntObjectImpl subject, Resource type) throws OntJenaException.IllegalState {
        Optional<OntStatement> res = OntObjectImpl.getOptionalRootStatement(subject, type);
        if (!res.isPresent()) {
            throw new OntJenaException.IllegalState("Can't find " + subject.getModel().shortForm(type.getURI()) + " declaration for " + subject);
        }
        return res;
    }

    protected static Optional<OntStatement> getOptionalRootStatement(OntObjectImpl subject, Resource type) {
        if (!subject.hasProperty(RDF.type, (RDFNode)OntObjectImpl.checkNamed(type))) {
            return Optional.empty();
        }
        return Optional.of(subject.getModel().createStatement(subject, RDF.type, (RDFNode)type).asRootStatement());
    }

    public static String viewAsString(Class<? extends RDFNode> type) {
        return type.getName().replace(OntObject.class.getPackage().getName() + ".", "");
    }

    public static Node checkNamed(Node res) {
        if (OntJenaException.notNull(res, "Null node").isURI()) {
            return res;
        }
        throw new OntJenaException.IllegalArgument("Not uri node " + res);
    }

    public static Resource checkNamed(Resource res) {
        if (OntJenaException.notNull(res, "Null resource").isURIResource()) {
            return res;
        }
        throw new OntJenaException.IllegalArgument("Not uri resource " + res);
    }

    public static <X extends OntObject> Stream<X> hierarchy(X object, Class<X> type, Property predicate, boolean inverse, boolean direct) {
        return Iter.fromSet(() -> OntObjectImpl.getHierarchy(object, OntObjectImpl.getListDirect(type, predicate, inverse), direct));
    }

    public static <X extends OntObject> ExtendedIterator<X> listHierarchy(X object, Class<X> type, Property predicate, boolean inverse, boolean direct) {
        return Iter.create(() -> OntObjectImpl.getHierarchy(object, OntObjectImpl.getListDirect(type, predicate, inverse), direct).iterator());
    }

    private static <X extends OntObject> Function<X, ExtendedIterator<X>> getListDirect(Class<X> type, Property predicate, boolean inverse) {
        return inverse ? x -> ((OntObjectImpl)x).listSubjects(predicate, type) : x -> ((OntObjectImpl)x).listObjects(predicate, type);
    }

    public static <X extends Resource> Set<X> getHierarchy(X object, Function<X, ExtendedIterator<X>> listDirect, boolean direct) {
        HashSet res;
        if (direct) {
            res = listDirect.apply(object).toSet();
        } else {
            res = new HashSet();
            OntObjectImpl.collectIndirect(object, listDirect, res);
        }
        res.remove(object);
        return res;
    }

    static <X extends Resource> void collectIndirect(X object, Function<X, ? extends Iterator<X>> listDirect, Set<X> res) {
        if (!res.add(object)) {
            return;
        }
        listDirect.apply(object).forEachRemaining(c -> OntObjectImpl.collectIndirect(c, listDirect, res));
    }

    public static Class<? extends OntObject> findActualClass(OntObject o) {
        return Arrays.stream(o.getClass().getInterfaces()).filter(OntObject.class::isAssignableFrom).map(c -> c).findFirst().orElse(null);
    }

    public static <X extends RDFNode> X getNodeAs(RDFNode node, Class<X> view) {
        try {
            return (X)node.as(view);
        }
        catch (JenaException ignore) {
            return null;
        }
    }

    public static OntObject wrapAsOntObject(Node node, EnhGraph model) {
        return new OntObjectImpl(node, model);
    }

    protected int getCharacteristics() {
        return OntGraphModelImpl.getSpliteratorCharacteristics((Graph)this.getModel().getGraph());
    }

    @Override
    public boolean isLocal() {
        return this.findRootStatement().map(OntStatement::isLocal).orElse(false);
    }

    @Override
    public final OntStatement getMainStatement() {
        return this.findRootStatement().orElse(null);
    }

    @Override
    public Stream<OntStatement> spec() {
        return Iter.asStream(this.listSpec(), this.getCharacteristics());
    }

    @Override
    public <X extends RDFNode> X getAs(Class<X> type) {
        return OntObjectImpl.getNodeAs((RDFNode)this, type);
    }

    public ExtendedIterator<OntStatement> listSpec() {
        return this.findRootStatement().map(Iter::of).orElseGet(NullIterator::instance);
    }

    @Override
    public Stream<OntStatement> content() {
        return Iter.fromSet(this::getContent);
    }

    public ExtendedIterator<OntStatement> listContent() {
        return Iter.create(() -> this.getContent().iterator());
    }

    protected Set<OntStatement> getContent() {
        Set res = this.listSpec().toSet();
        this.listStatements().filterDrop(OntStatement::isAnnotationAssertion).forEachRemaining(res::add);
        return res;
    }

    public Optional<OntStatement> findRootStatement() {
        return Iter.findFirst(this.listObjects(RDF.type)).map(o -> this.getModel().createStatement(this, RDF.type, (RDFNode)o).asRootStatement());
    }

    protected OntObjectImpl changeRDFType(Resource type, boolean add) {
        if (add) {
            this.addStatement(RDF.type, (RDFNode)type);
        } else {
            this.remove(RDF.type, (RDFNode)type);
        }
        return this;
    }

    @Override
    public Optional<OntStatement> statement(Property property) {
        return Iter.findFirst(this.listStatements(property));
    }

    @Override
    public Optional<OntStatement> statement(Property property, RDFNode value) {
        return Iter.findFirst(this.getModel().listOntStatements(this, property, value));
    }

    @Override
    public OntStatement getRequiredProperty(Property property) throws PropertyNotFoundException {
        return this.statement(property).orElseThrow(() -> new PropertyNotFoundException(property));
    }

    protected ExtendedIterator<OntStatement> listRequired(Property ... properties) {
        return Iter.of(properties).mapWith(this::getRequiredProperty);
    }

    @Override
    public OntStatement addStatement(Property property, RDFNode value) {
        OntStatementImpl res = this.getModel().createStatement(this, OntJenaException.notNull(property, "Null property."), OntJenaException.notNull(value, "Null value."));
        this.getModel().add(res);
        return res;
    }

    @Override
    public OntObjectImpl remove(Property property, RDFNode value) {
        OntGraphModelImpl m = this.getModel();
        m.listOntStatements(this, OntJenaException.notNull(property, "Null property."), value).toList().forEach(s -> m.remove(s.clearAnnotations()));
        return this;
    }

    @Override
    public Stream<OntStatement> statements(Property property) {
        return Iter.asStream(this.listStatements(property), this.getCharacteristics());
    }

    @Override
    public Stream<OntStatement> statements() {
        return Iter.asStream(this.listStatements(), this.getCharacteristics());
    }

    public StmtIterator listProperties() {
        return this.listProperties(null);
    }

    public ExtendedIterator<OntStatement> listStatements() {
        return this.listStatements(null);
    }

    public StmtIterator listProperties(Property p) {
        return Iter.createStmtIterator((ExtendedIterator<Triple>)this.getModel().getGraph().find(this.asNode(), OntGraphModelImpl.asNode((RDFNode)p), Node.ANY), t -> this.createOntStatement(p, (Triple)t));
    }

    public ExtendedIterator<OntStatement> listStatements(Property p) {
        return Iter.create(this.getModel().getGraph().find(this.asNode(), OntGraphModelImpl.asNode((RDFNode)p), Node.ANY).mapWith(t -> this.createOntStatement(p, (Triple)t)));
    }

    protected OntStatementImpl createOntStatement(Property p, Triple t) {
        OntGraphModelImpl m = this.getModel();
        Property property = p == null ? m.getNodeAs(t.getPredicate(), Property.class) : p;
        RDFNode object = m.getNodeAs(t.getObject(), RDFNode.class);
        return m.createStatement(this, property, object);
    }

    @Override
    public Stream<OntStatement> annotations() {
        return Iter.asStream(this.listAnnotations(), this.getCharacteristics());
    }

    public ExtendedIterator<OntStatement> listAnnotations() {
        ExtendedIterator<OntStatement> res = this.listAssertions();
        Optional<OntStatement> main = this.findRootStatement();
        if (!main.isPresent()) {
            return res;
        }
        OntStatementImpl s = (OntStatementImpl)main.get();
        return res.andThen(Iter.flatMap(s.listAnnotationResources(), a -> ((OntAnnotationImpl)a).listAssertions()));
    }

    public Stream<OntStatement> assertions() {
        return Iter.asStream(this.listAssertions(), this.getCharacteristics());
    }

    public ExtendedIterator<OntStatement> listAssertions() {
        return this.listStatements().filterKeep(OntStatement::isAnnotationAssertion);
    }

    public ExtendedIterator<Literal> listAnnotationLiterals(OntAnnotationProperty predicate) {
        return this.listAnnotations().filterKeep(s -> Objects.equals(predicate, s.getPredicate())).mapWith(Statement::getObject).filterKeep(RDFNode::isLiteral).mapWith(RDFNode::asLiteral);
    }

    @Override
    public Stream<String> annotationValues(OntAnnotationProperty p, String lang) {
        if (lang == null) {
            return Iter.asStream(this.listAnnotationLiterals(p).mapWith(Literal::getString));
        }
        return Iter.asStream(this.listAnnotationLiterals(p)).sorted(Comparator.comparing(Literal::getLanguage)).filter(l -> {
            String target = l.getLanguage();
            if (lang.isEmpty()) {
                return target.isEmpty();
            }
            String x = target.length() > lang.length() ? target.substring(0, lang.length()) : target;
            return lang.equalsIgnoreCase(x);
        }).map(Literal::getString);
    }

    @Override
    public OntStatement addAnnotation(OntAnnotationProperty property, RDFNode value) {
        return this.findRootStatement().map(r -> r.addAnnotation(property, value)).orElseGet(() -> this.getModel().createStatement(this.addProperty(property, value), property, value));
    }

    @Override
    public OntObjectImpl clearAnnotations() {
        Iter.peek(this.listAssertions(), OntStatement::clearAnnotations).toSet().forEach(a -> this.getModel().remove((Statement)a));
        this.findRootStatement().ifPresent(OntStatement::clearAnnotations);
        return this;
    }

    public void clearAll(Property predicate) {
        this.listProperties(predicate).mapWith(Statement::getObject).filterKeep(n -> n.canAs(RDFList.class)).mapWith(n -> (RDFList)n.as(RDFList.class)).forEachRemaining(RDFList::removeList);
        this.removeAll(predicate);
    }

    public <T extends RDFNode> T getRequiredObject(Property predicate, Class<T> view) {
        return (T)((RDFNode)this.object(predicate, view).orElseThrow(() -> new OntJenaException(String.format("Can't find required object [%s @%s %s]", this, predicate, OntObjectImpl.viewAsString(view)))));
    }

    public <T extends RDFNode> Optional<T> object(Property predicate, Class<T> type) {
        return Iter.findFirst(this.listObjects(predicate, type));
    }

    @Override
    public <O extends RDFNode> Stream<O> objects(Property predicate, Class<O> type) {
        return Iter.asStream(this.listObjects(predicate, type), predicate != null ? this.getCharacteristics() : 256);
    }

    public <O extends RDFNode> ExtendedIterator<O> listObjects(Property predicate, Class<O> type) {
        OntGraphModelImpl m = this.getModel();
        return this.listProperties(predicate).mapWith(s -> m.findNodeAs(s.getObject().asNode(), type)).filterDrop(Objects::isNull);
    }

    public <S extends RDFNode> ExtendedIterator<S> listSubjects(Property predicate, Class<S> type) {
        OntGraphModelImpl m = this.getModel();
        return m.listStatements(null, predicate, (RDFNode)this).mapWith(s -> m.findNodeAs(s.getSubject().asNode(), type)).filterDrop(Objects::isNull);
    }

    @Override
    public Stream<RDFNode> objects(Property predicate) {
        return Iter.asStream(this.listObjects(predicate), predicate != null ? this.getCharacteristics() : 256);
    }

    public ExtendedIterator<RDFNode> listObjects(Property predicate) {
        return this.listProperties(predicate).mapWith(Statement::getObject);
    }

    @Override
    public OntGraphModelImpl getModel() {
        return (OntGraphModelImpl)this.enhGraph;
    }

    public Class<? extends OntObject> getActualClass() {
        return OntObjectImpl.findActualClass(this);
    }

    public String toString() {
        Class<? extends OntObject> view = this.getActualClass();
        return view == null ? super.toString() : String.format("[%s]%s", OntObjectImpl.viewAsString(view), this.asNode());
    }
}

