/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.conf.OntPersonality;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import java.util.Set;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;

public interface PersonalityModel {
    public OntPersonality getOntPersonality();

    public <N extends RDFNode> N getNodeAs(Node var1, Class<N> var2);

    public <N extends RDFNode> N findNodeAs(Node var1, Class<N> var2);

    public <N extends RDFNode> N fetchNodeAs(Node var1, Class<N> var2);

    public Set<Node> getSystemResources(Class<? extends OntObject> var1);

    public static PersonalityModel asPersonalityModel(EnhGraph graph) throws OntJenaException {
        if (graph instanceof PersonalityModel) {
            return (PersonalityModel)graph;
        }
        throw new OntJenaException.IllegalArgument("The given EnhGraph is not a PersonalityModel: " + graph);
    }

    public static PersonalityModel asPersonalityModel(OntModel graph) throws OntJenaException {
        if (graph instanceof PersonalityModel) {
            return (PersonalityModel)((Object)graph);
        }
        throw new OntJenaException.IllegalArgument("The given OntGraphModel is not a PersonalityModel: " + graph);
    }

    public static boolean canAs(Class<? extends RDFNode> view, Node node, EnhGraph graph) {
        return PersonalityModel.asPersonalityModel(graph).fetchNodeAs(node, view) != null;
    }
}

