/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.UnionGraph;
import com.github.owlcs.ontapi.jena.impl.OntObjectImpl;
import com.github.owlcs.ontapi.jena.utils.Graphs;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.enhanced.Personality;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.shared.JenaException;

public class UnionModel
extends ModelCom {
    private final ThreadLocal<Set<Node>> visited = ThreadLocal.withInitial(HashSet::new);

    public UnionModel(Graph base, Personality<RDFNode> personality) {
        super((Graph)UnionModel.asUnionGraph(base), personality);
    }

    public static UnionGraph asUnionGraph(Graph graph) {
        return graph instanceof UnionGraph ? (UnionGraph)graph : new UnionGraph(graph);
    }

    public UnionGraph getGraph() {
        return (UnionGraph)super.getGraph();
    }

    public Graph getBaseGraph() {
        return this.getGraph().getBaseGraph();
    }

    public Model getBaseModel() {
        return new ModelCom(this.getBaseGraph());
    }

    public UnionModel write(Writer writer) {
        this.getBaseModel().write(writer);
        return this;
    }

    public UnionModel write(Writer writer, String lang) {
        this.getBaseModel().write(writer, lang);
        return this;
    }

    public UnionModel write(Writer writer, String lang, String base) {
        this.getBaseModel().write(writer, lang, base);
        return this;
    }

    public UnionModel write(OutputStream out) {
        this.getBaseModel().write(out);
        return this;
    }

    public UnionModel write(OutputStream out, String lang) {
        this.getBaseModel().write(out, lang);
        return this;
    }

    public UnionModel write(OutputStream out, String lang, String base) {
        this.getBaseModel().write(out, lang, base);
        return this;
    }

    protected Cache<Node, RDFNode> getNodeCache() {
        return this.enhNodes;
    }

    public boolean isLocal(Statement s) {
        return this.isLocal(OntJenaException.notNull(s, "Null statement.").getSubject(), s.getPredicate(), s.getObject());
    }

    public boolean isLocal(Resource s, Property p, RDFNode o) {
        return this.getBaseGraph().contains(s.asNode(), p.asNode(), o.asNode());
    }

    public <N extends RDFNode> N findNodeAs(Node node, Class<N> type) {
        try {
            return this.getNodeAs(node, type);
        }
        catch (OntJenaException.Conversion ignore) {
            return null;
        }
    }

    public <N extends RDFNode> N getNodeAs(Node node, Class<N> type) {
        try {
            return this.getNodeAsInternal(node, type);
        }
        catch (OntJenaException e) {
            throw e;
        }
        catch (JenaException e) {
            throw new OntJenaException.Conversion(String.format("Failed to convert node <%s> to <%s>", node, OntObjectImpl.viewAsString(type)), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <N extends RDFNode> N fetchNodeAs(Node node, Class<N> type) {
        Set<Node> nodes = this.visited.get();
        try {
            if (nodes.add(node)) {
                N n = this.getNodeAsInternal(node, type);
                return n;
            }
            try {
                throw new OntJenaException.Recursion("Can't cast to " + OntObjectImpl.viewAsString(type) + ": graph contains a recursion for node <" + node + ">");
            }
            catch (OntJenaException.Recursion r) {
                throw r;
            }
            catch (JenaException e) {
                N n = null;
                return n;
            }
        }
        finally {
            nodes.remove(node);
        }
    }

    protected <N extends RDFNode> N getNodeAsInternal(Node node, Class<N> type) {
        return (N)super.getNodeAs(Objects.requireNonNull(node, "Null node"), Objects.requireNonNull(type, "Null class view."));
    }

    public String toString() {
        return String.format("UnionModel{%s}", Graphs.getName(this.getBaseGraph()));
    }
}

