/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.OntObjectImpl;
import com.github.owlcs.ontapi.jena.impl.PersonalityModel;
import com.github.owlcs.ontapi.jena.impl.conf.BaseFactoryImpl;
import com.github.owlcs.ontapi.jena.impl.conf.ObjectFactory;
import com.github.owlcs.ontapi.jena.model.OntObject;
import java.util.Objects;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.graph.Node;
import org.apache.jena.util.iterator.ExtendedIterator;

public class WrappedFactoryImpl
extends BaseFactoryImpl {
    private final Class<? extends OntObject> type;

    public WrappedFactoryImpl(Class<? extends OntObject> type) {
        this.type = Objects.requireNonNull(type);
    }

    static WrappedFactoryImpl of(Class<? extends OntObject> type) {
        return new WrappedFactoryImpl(type);
    }

    public ObjectFactory getDelegate(EnhGraph g) throws OntJenaException {
        return this.getFactory(g);
    }

    protected ObjectFactory getFactory(EnhGraph g) throws OntJenaException {
        ObjectFactory res = PersonalityModel.asPersonalityModel(g).getOntPersonality().getObjectFactory(this.type);
        if (res == null) {
            throw new OntJenaException.IllegalState("Unable to find factory for " + this.type);
        }
        return res;
    }

    @Override
    public ExtendedIterator<EnhNode> iterator(EnhGraph eg) {
        return this.getDelegate(eg).iterator(eg);
    }

    @Override
    public boolean canWrap(Node node, EnhGraph eg) {
        return this.getDelegate(eg).canWrap(node, eg);
    }

    @Override
    public EnhNode createInstance(Node node, EnhGraph eg) {
        return this.getDelegate(eg).createInstance(node, eg);
    }

    @Override
    public EnhNode wrap(Node node, EnhGraph eg) {
        return this.getDelegate(eg).wrap(node, eg);
    }

    public String toString() {
        return String.format("Factory[%s]", OntObjectImpl.viewAsString(this.type));
    }
}

