/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl.conf;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.conf.ObjectFactory;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;

public abstract class BaseFactoryImpl
extends Implementation
implements ObjectFactory {
    protected static EnhNode safeWrap(Node n, EnhGraph g, Iterable<ObjectFactory> factories) {
        for (ObjectFactory f : factories) {
            EnhNode r = BaseFactoryImpl.safeWrap(n, g, f);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    protected static EnhNode safeWrap(Node n, EnhGraph g, ObjectFactory f) {
        try {
            return f.wrap(n, g);
        }
        catch (OntJenaException.Conversion c) {
            return null;
        }
    }

    protected static boolean canWrap(Node node, EnhGraph eg, ObjectFactory ... factories) {
        for (ObjectFactory f : factories) {
            if (!f.canWrap(node, eg)) continue;
            return true;
        }
        return false;
    }

    protected static boolean canWrap(Node node, EnhGraph eg, Iterable<ObjectFactory> factories) {
        for (ObjectFactory f : factories) {
            if (!f.canWrap(node, eg)) continue;
            return true;
        }
        return false;
    }

    protected static EnhNode wrap(Node node, EnhGraph eg, OntJenaException.Conversion ex, ObjectFactory ... factories) {
        for (ObjectFactory f : factories) {
            try {
                return f.wrap(node, eg);
            }
            catch (OntJenaException.Conversion c) {
                ex.addSuppressed((Throwable)((Object)c));
            }
        }
        throw ex;
    }

    protected static EnhNode wrap(Node node, EnhGraph eg, OntJenaException.Conversion ex, Iterable<ObjectFactory> factories) {
        for (ObjectFactory f : factories) {
            try {
                return f.wrap(node, eg);
            }
            catch (OntJenaException.Conversion c) {
                ex.addSuppressed((Throwable)((Object)c));
            }
        }
        throw ex;
    }

    @Override
    public EnhNode wrap(Node node, EnhGraph eg) {
        if (!this.canWrap(node, eg)) {
            throw new OntJenaException.Conversion("Can't wrap node " + node + ". Use direct factory.");
        }
        return this.createInstance(node, eg);
    }
}

