/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl.conf;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.utils.Iter;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.util.iterator.ExtendedIterator;

public interface ObjectFactory {
    public ExtendedIterator<EnhNode> iterator(EnhGraph var1);

    public boolean canWrap(Node var1, EnhGraph var2);

    public EnhNode createInstance(Node var1, EnhGraph var2);

    default public EnhNode wrap(Node node, EnhGraph eg) {
        if (!this.canWrap(node, eg)) {
            throw new OntJenaException.Conversion("Can't wrap node " + node + ". Use direct factory.");
        }
        return this.createInstance(node, eg);
    }

    default public EnhNode createInGraph(Node node, EnhGraph eg) {
        throw new OntJenaException.Unsupported("Creation is not allowed: " + node);
    }

    default public boolean canCreateInGraph(Node node, EnhGraph eg) {
        return false;
    }

    default public Stream<EnhNode> find(EnhGraph eg) {
        return Iter.asStream(this.iterator(eg));
    }

    public static Implementation asJenaImplementation(ObjectFactory f) throws OntJenaException {
        if (f instanceof Implementation) {
            return (Implementation)f;
        }
        throw new OntJenaException.IllegalArgument("The given OntObjectFactory is not an instance of Jena Implementation.");
    }
}

