/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl.conf;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.OntObjectImpl;
import com.github.owlcs.ontapi.jena.impl.conf.OntFilter;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.lang.reflect.InvocationTargetException;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.JenaException;

public interface OntMaker {
    public EnhNode instance(Node var1, EnhGraph var2);

    default public void make(Node node, EnhGraph eg) {
        throw new OntJenaException.Unsupported();
    }

    default public OntFilter getTester() {
        return OntFilter.FALSE;
    }

    public Class<? extends EnhNode> getImpl();

    default public OntMaker restrict(final OntFilter filter) {
        OntJenaException.notNull(filter, "Null restriction filter.");
        return new OntMaker(){

            @Override
            public void make(Node node, EnhGraph eg) {
                OntMaker.this.make(node, eg);
            }

            @Override
            public OntFilter getTester() {
                return OntMaker.this.getTester().and(filter);
            }

            @Override
            public EnhNode instance(Node node, EnhGraph eg) {
                return OntMaker.this.instance(node, eg);
            }

            @Override
            public Class<? extends EnhNode> getImpl() {
                return OntMaker.this.getImpl();
            }
        };
    }

    public static class WithType
    extends Default {
        protected final Node type;

        public WithType(Class<? extends OntObjectImpl> impl, Resource type) {
            super(impl);
            this.type = OntJenaException.notNull(type, "Null type.").asNode();
        }

        @Override
        public void make(Node node, EnhGraph eg) {
            eg.asGraph().add(Triple.create((Node)node, (Node)RDF.type.asNode(), (Node)this.type));
        }

        @Override
        public OntFilter getTester() {
            return OntFilter.TRUE;
        }
    }

    public static class Default
    implements OntMaker {
        protected final Class<? extends OntObjectImpl> impl;

        public Default(Class<? extends OntObjectImpl> impl) {
            this.impl = OntJenaException.notNull(impl, "Null implementation class.");
        }

        @Override
        public void make(Node node, EnhGraph eg) {
            throw new OntJenaException.Unsupported("Creation is not allowed for node " + node + " and class " + this.impl.getSimpleName());
        }

        @Override
        public EnhNode instance(Node node, EnhGraph eg) {
            try {
                return (EnhNode)this.impl.getDeclaredConstructor(Node.class, EnhGraph.class).newInstance(node, eg);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                throw new OntJenaException("Can't create instance of " + this.impl, e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof JenaException) {
                    throw (JenaException)e.getCause();
                }
                throw new OntJenaException("Can't init " + this.impl, e);
            }
        }

        public Class<? extends OntObjectImpl> getImpl() {
            return this.impl;
        }
    }
}

