/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.model;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.model.AsNamed;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntList;
import com.github.owlcs.ontapi.jena.model.OntNamedProperty;
import com.github.owlcs.ontapi.jena.model.OntNegativeAssertion;
import com.github.owlcs.ontapi.jena.model.OntRealProperty;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.model.RDFNodeList;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDFS;

public interface OntObjectProperty
extends OntRealProperty,
AsNamed<Named> {
    public Stream<OntObjectProperty> superProperties(boolean var1);

    public Stream<OntObjectProperty> subProperties(boolean var1);

    public Stream<OntList<OntObjectProperty>> propertyChains();

    public OntNegativeAssertion.WithObjectProperty addNegativeAssertion(OntIndividual var1, OntIndividual var2);

    public OntList<OntObjectProperty> createPropertyChain(Collection<OntObjectProperty> var1);

    public OntObjectProperty removePropertyChain(Resource var1) throws OntJenaException;

    @Override
    default public Named asNamed() {
        return (Named)this.as(Named.class);
    }

    default public Stream<OntClass> ranges() {
        return this.objects(RDFS.range, OntClass.class);
    }

    default public Stream<OntObjectProperty> superProperties() {
        return this.objects(RDFS.subPropertyOf, OntObjectProperty.class);
    }

    default public Stream<OntObjectProperty> disjointProperties() {
        return this.objects(OWL.propertyDisjointWith, OntObjectProperty.class);
    }

    default public Stream<OntObjectProperty> equivalentProperties() {
        return this.objects(OWL.equivalentProperty, OntObjectProperty.class);
    }

    default public Stream<OntObjectProperty> inverseProperties() {
        return this.objects(OWL.inverseOf, OntObjectProperty.class);
    }

    default public Stream<OntNegativeAssertion.WithObjectProperty> negativeAssertions() {
        return this.getModel().ontObjects(OntNegativeAssertion.WithObjectProperty.class).filter(a -> this.equals(a.getProperty()));
    }

    default public Stream<OntNegativeAssertion.WithObjectProperty> negativeAssertions(OntIndividual source) {
        return this.negativeAssertions().filter(a -> a.getSource().equals(source));
    }

    default public Optional<OntList<OntObjectProperty>> findPropertyChain(RDFNode list) {
        try (Stream<OntList> res = this.propertyChains().filter(r -> Objects.equals(r, list));){
            Optional<OntList<OntObjectProperty>> optional = res.findFirst();
            return optional;
        }
    }

    default public OntObjectProperty clearPropertyChains() {
        this.propertyChains().collect(Collectors.toList()).forEach(this::removePropertyChain);
        return this;
    }

    default public Stream<OntObjectProperty> fromPropertyChain() {
        return this.propertyChains().flatMap(RDFNodeList::members).distinct();
    }

    default public OntStatement addPropertyChainAxiomStatement(OntObjectProperty ... properties) {
        return this.addPropertyChainAxiomStatement(Arrays.asList(properties));
    }

    default public OntStatement addPropertyChainAxiomStatement(Collection<OntObjectProperty> properties) {
        return this.createPropertyChain(properties).getMainStatement();
    }

    default public OntStatement addInverseFunctionalDeclaration() {
        return this.addStatement(RDF.type, (RDFNode)OWL.InverseFunctionalProperty);
    }

    default public OntStatement addTransitiveDeclaration() {
        return this.addStatement(RDF.type, (RDFNode)OWL.TransitiveProperty);
    }

    default public OntStatement addSymmetricDeclaration() {
        return this.addStatement(RDF.type, (RDFNode)OWL.SymmetricProperty);
    }

    default public OntStatement addAsymmetricDeclaration() {
        return this.addStatement(RDF.type, (RDFNode)OWL.AsymmetricProperty);
    }

    default public OntStatement addReflexiveDeclaration() {
        return this.addStatement(RDF.type, (RDFNode)OWL.ReflexiveProperty);
    }

    default public OntStatement addIrreflexiveDeclaration() {
        return this.addStatement(RDF.type, (RDFNode)OWL.IrreflexiveProperty);
    }

    default public OntStatement addRangeStatement(OntClass range) {
        return this.addStatement(RDFS.range, (RDFNode)range);
    }

    default public OntStatement addSubPropertyOfStatement(OntObjectProperty property) {
        return this.addStatement(RDFS.subPropertyOf, (RDFNode)property);
    }

    default public OntStatement addInverseOfStatement(OntObjectProperty other) {
        return this.addStatement(OWL.inverseOf, (RDFNode)other);
    }

    default public OntStatement addEquivalentPropertyStatement(OntObjectProperty other) {
        return this.addStatement(OWL.equivalentProperty, (RDFNode)other);
    }

    default public OntStatement addPropertyDisjointWithStatement(OntObjectProperty other) {
        return this.addStatement(OWL.propertyDisjointWith, (RDFNode)other);
    }

    default public OntObjectProperty addSuperProperty(OntObjectProperty property) {
        this.addSubPropertyOfStatement(property);
        return this;
    }

    default public OntObjectProperty addRange(OntClass range) {
        this.addRangeStatement(range);
        return this;
    }

    @Override
    default public OntObjectProperty addDomain(OntClass ce) {
        this.addDomainStatement(ce);
        return this;
    }

    default public OntObjectProperty addEquivalentProperty(OntObjectProperty other) {
        this.addEquivalentPropertyStatement(other);
        return this;
    }

    default public OntObjectProperty addDisjointProperty(OntObjectProperty other) {
        this.addPropertyDisjointWithStatement(other);
        return this;
    }

    default public OntObjectProperty addInverseProperty(OntObjectProperty other) {
        this.addInverseOfStatement(other);
        return this;
    }

    default public OntObjectProperty addPropertyChain(OntObjectProperty ... properties) {
        return this.addPropertyChain(Arrays.asList(properties));
    }

    default public OntObjectProperty addPropertyChain(Collection<OntObjectProperty> properties) {
        this.createPropertyChain(properties);
        return this;
    }

    @Override
    default public OntObjectProperty removeSuperProperty(Resource property) {
        this.remove(RDFS.subPropertyOf, (RDFNode)property);
        return this;
    }

    @Override
    default public OntObjectProperty removeEquivalentProperty(Resource property) {
        this.remove(OWL.equivalentProperty, (RDFNode)property);
        return this;
    }

    @Override
    default public OntObjectProperty removeDisjointProperty(Resource property) {
        this.remove(OWL.propertyDisjointWith, (RDFNode)property);
        return this;
    }

    @Override
    default public OntObjectProperty removeDomain(Resource domain) {
        this.remove(RDFS.domain, (RDFNode)domain);
        return this;
    }

    @Override
    default public OntObjectProperty removeRange(Resource range) {
        this.remove(RDFS.range, (RDFNode)range);
        return this;
    }

    default public OntObjectProperty removeInverseProperty(Resource other) {
        this.remove(OWL.inverseOf, (RDFNode)other);
        return this;
    }

    @Override
    default public OntObjectProperty setFunctional(boolean functional) {
        if (functional) {
            this.addFunctionalDeclaration();
        } else {
            this.remove(RDF.type, (RDFNode)OWL.FunctionalProperty);
        }
        return this;
    }

    default public OntObjectProperty setInverseFunctional(boolean inverseFunctional) {
        if (inverseFunctional) {
            this.addInverseFunctionalDeclaration();
        } else {
            this.remove(RDF.type, (RDFNode)OWL.InverseFunctionalProperty);
        }
        return this;
    }

    default public OntObjectProperty setTransitive(boolean transitive) {
        if (transitive) {
            this.addTransitiveDeclaration();
        } else {
            this.remove(RDF.type, (RDFNode)OWL.TransitiveProperty);
        }
        return this;
    }

    default public OntObjectProperty setSymmetric(boolean symmetric) {
        if (symmetric) {
            this.addSymmetricDeclaration();
        } else {
            this.remove(RDF.type, (RDFNode)OWL.SymmetricProperty);
        }
        return this;
    }

    default public OntObjectProperty setAsymmetric(boolean asymmetric) {
        if (asymmetric) {
            this.addAsymmetricDeclaration();
        } else {
            this.remove(RDF.type, (RDFNode)OWL.AsymmetricProperty);
        }
        return this;
    }

    default public OntObjectProperty setReflexive(boolean reflexive) {
        if (reflexive) {
            this.addReflexiveDeclaration();
        } else {
            this.remove(RDF.type, (RDFNode)OWL.ReflexiveProperty);
        }
        return this;
    }

    default public OntObjectProperty setIrreflexive(boolean irreflexive) {
        if (irreflexive) {
            this.addIrreflexiveDeclaration();
        } else {
            this.remove(RDF.type, (RDFNode)OWL.IrreflexiveProperty);
        }
        return this;
    }

    default public Optional<OntObjectProperty> findInverseProperty() {
        try (Stream<OntObjectProperty> res = this.inverseProperties();){
            Optional<OntObjectProperty> optional = res.findFirst();
            return optional;
        }
    }

    default public boolean isInverseFunctional() {
        return this.hasType(OWL.InverseFunctionalProperty);
    }

    default public boolean isTransitive() {
        return this.hasType(OWL.TransitiveProperty);
    }

    default public boolean isSymmetric() {
        return this.hasType(OWL.SymmetricProperty);
    }

    default public boolean isAsymmetric() {
        return this.hasType(OWL.AsymmetricProperty);
    }

    default public boolean isReflexive() {
        return this.hasType(OWL.ReflexiveProperty);
    }

    default public boolean isIrreflexive() {
        return this.hasType(OWL.IrreflexiveProperty);
    }

    public static interface Named
    extends OntObjectProperty,
    OntNamedProperty<Named> {
        public Inverse createInverse();

        @Override
        default public Named asNamed() {
            return this;
        }
    }

    public static interface Inverse
    extends OntObjectProperty {
        public Named getDirect();
    }
}

