/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.model;

import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntList;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import java.util.stream.Stream;

public interface OntSWRL
extends OntObject {

    public static interface Atom<P extends OntObject>
    extends OntSWRL {
        public P getPredicate();

        public Stream<? extends Arg> arguments();

        public static interface Unary<P extends OntObject, A extends Arg>
        extends Atom<P> {
            public A getArg();

            @Override
            default public Stream<A> arguments() {
                return Stream.of(this.getArg());
            }
        }

        public static interface Binary<P extends OntObject, F extends Arg, S extends Arg>
        extends Atom<P> {
            public F getFirstArg();

            public S getSecondArg();

            @Override
            default public Stream<Arg> arguments() {
                return Stream.of(this.getFirstArg(), this.getSecondArg());
            }
        }

        public static interface WithSameIndividuals
        extends Binary<OntObjectProperty.Named, IArg, IArg> {
        }

        public static interface WithDifferentIndividuals
        extends Binary<OntObjectProperty.Named, IArg, IArg> {
        }

        public static interface WithObjectProperty
        extends Binary<OntObjectProperty, IArg, IArg> {
        }

        public static interface WithDataProperty
        extends Binary<OntDataProperty, IArg, DArg> {
        }

        public static interface WithDataRange
        extends Unary<OntDataRange, DArg> {
        }

        public static interface WithClass
        extends Unary<OntClass, IArg> {
        }

        public static interface WithBuiltin
        extends Atom<Builtin> {
            public OntList<DArg> getArgList();

            @Override
            default public Stream<DArg> arguments() {
                return this.getArgList().members();
            }
        }
    }

    public static interface IArg
    extends Arg {
    }

    public static interface DArg
    extends Arg {
    }

    public static interface Arg
    extends OntObject {
    }

    public static interface Variable
    extends OntSWRL,
    DArg,
    IArg {
    }

    public static interface Builtin
    extends OntSWRL {
    }

    public static interface Imp
    extends OntSWRL {
        public OntList<Atom> getHeadList();

        public OntList<Atom> getBodyList();

        default public Stream<Atom> head() {
            return this.getHeadList().members().distinct();
        }

        default public Stream<Atom> body() {
            return this.getBodyList().members().distinct();
        }
    }
}

