/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.utils;

import com.github.owlcs.ontapi.jena.OntJenaException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.jena.atlas.iterator.FilterUnique;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.StmtIteratorImpl;
import org.apache.jena.util.iterator.ClosableIterator;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.apache.jena.util.iterator.SingletonIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class Iter {
    public static <X> Stream<X> asStream(ExtendedIterator<? extends X> iterator) {
        if (iterator instanceof NullIterator) {
            return Stream.empty();
        }
        if (iterator instanceof SingletonIterator) {
            return Stream.of(iterator.next());
        }
        return Iter.asStream(iterator);
    }

    public static <X> Stream<X> asStream(Iterator<? extends X> iterator) {
        return Iter.asStream(iterator, 256);
    }

    public static <X> Stream<X> asStream(Iterator<? extends X> iterator, int characteristics) {
        return Iter.asStream(iterator, -1L, characteristics);
    }

    public static <X> Stream<X> asStream(Iterator<? extends X> iterator, long size, int characteristics) {
        Stream res = StreamSupport.stream(Iter.asSpliterator(iterator, size, characteristics), false);
        return iterator instanceof ClosableIterator ? (Stream)res.onClose(() -> ((ClosableIterator)((ClosableIterator)iterator)).close()) : res;
    }

    public static <X> Spliterator<X> asSpliterator(Iterator<? extends X> iterator, long size, int characteristics) {
        if (size < 0L) {
            return Spliterators.spliteratorUnknownSize(iterator, characteristics);
        }
        return Spliterators.spliterator(iterator, size, characteristics);
    }

    public static <X> Stream<X> fromSet(Supplier<Set<X>> getAsSet) {
        int chs = 1281;
        return Iter.asStream(Iter.create(() -> ((Set)getAsSet.get()).iterator()), chs);
    }

    public static StmtIterator createStmtIterator(ExtendedIterator<Triple> triples, Function<Triple, Statement> map) {
        return new StmtIteratorImpl((Iterator)triples.mapWith(map));
    }

    public static Set<Node> asUnmodifiableNodeSet(Collection<? extends RDFNode> nodes) {
        return nodes.stream().map(FrontsNode::asNode).collect(Iter.toUnmodifiableSet());
    }

    public static <X> Collector<X, ?, Set<X>> toUnmodifiableSet() {
        return Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet);
    }

    public static <X> Collector<X, ?, List<X>> toUnmodifiableList() {
        return Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList);
    }

    public static <T, F> ExtendedIterator<T> flatMap(ExtendedIterator<F> base, Function<? super F, ? extends Iterator<? extends T>> mapper) {
        return WrappedIterator.createIteratorIterator((Iterator)base.mapWith(mapper));
    }

    public static <X> ExtendedIterator<X> concat(ExtendedIterator<? extends X> a, ExtendedIterator<? extends X> b) {
        return a.andThen(b);
    }

    @SafeVarargs
    public static <X> ExtendedIterator<X> concat(ExtendedIterator<? extends X> ... iterators) {
        NullIterator res = NullIterator.instance();
        for (ExtendedIterator<? extends X> i : iterators) {
            res = res.andThen(i);
        }
        return res;
    }

    public static <X> ExtendedIterator<X> filter(ExtendedIterator<X> iterator, Predicate<? super X> predicate) {
        return iterator.filterKeep(predicate);
    }

    public static <X> ExtendedIterator<X> peek(ExtendedIterator<X> base, Consumer<? super X> action) {
        return base.mapWith(x -> {
            action.accept((Object)x);
            return x;
        });
    }

    public static <X> ExtendedIterator<X> distinct(ExtendedIterator<X> base) {
        return base.filterKeep((Predicate)new FilterUnique());
    }

    public static <X> boolean anyMatch(Iterator<X> iterator, Predicate<? super X> predicate) {
        if (iterator instanceof NullIterator) {
            return false;
        }
        try {
            while (iterator.hasNext()) {
                if (!predicate.test(iterator.next())) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            Iter.close(iterator);
        }
        return false;
    }

    public static <X> boolean allMatch(Iterator<X> iterator, Predicate<? super X> predicate) {
        if (iterator instanceof NullIterator) {
            return true;
        }
        try {
            while (iterator.hasNext()) {
                if (predicate.test(iterator.next())) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            Iter.close(iterator);
        }
        return true;
    }

    public static <X> boolean noneMatch(Iterator<X> iterator, Predicate<? super X> predicate) {
        return Iter.allMatch(iterator, predicate.negate());
    }

    public static <X> Optional<X> findFirst(Iterator<X> iterator) {
        if (iterator instanceof NullIterator) {
            return Optional.empty();
        }
        try {
            Optional optional = iterator.hasNext() ? Optional.of(iterator.next()) : Optional.empty();
            return optional;
        }
        finally {
            Iter.close(iterator);
        }
    }

    public static long count(Iterator<?> iterator) {
        long res = 0L;
        while (iterator.hasNext()) {
            iterator.next();
            ++res;
        }
        return res;
    }

    public static <X, C extends Collection<X>> C addAll(Iterator<? extends X> iterator, C collection) {
        iterator.forEachRemaining(collection::add);
        return collection;
    }

    public static <X, K, V, M extends Map<K, V>> M toMap(Iterator<X> iterator, Function<? super X, ? extends K> keyMapper, Function<? super X, ? extends V> valueMapper, BinaryOperator<V> mergeFunction, Supplier<M> mapSupplier) {
        Map res = (Map)mapSupplier.get();
        while (iterator.hasNext()) {
            X x = iterator.next();
            K k = keyMapper.apply(x);
            V v = valueMapper.apply(x);
            res.merge(k, v, mergeFunction);
        }
        return (M)res;
    }

    public static void close(Iterator<?> iterator) {
        if (iterator instanceof ClosableIterator) {
            ((ClosableIterator)iterator).close();
        }
    }

    @SafeVarargs
    public static <X> ExtendedIterator<X> of(X ... members) {
        return Iter.create(Arrays.asList(members));
    }

    public static <X> ExtendedIterator<X> of() {
        return NullIterator.instance();
    }

    public static <X> ExtendedIterator<X> of(X item) {
        return new SingletonIterator(item);
    }

    public static <X> ExtendedIterator<X> create(Collection<? extends X> members) {
        return members.isEmpty() ? NullIterator.instance() : Iter.create(members.iterator());
    }

    public static <X> ExtendedIterator<X> create(Iterator<? extends X> iterator) {
        return WrappedIterator.create(iterator);
    }

    public static <X> ExtendedIterator<X> create(final Supplier<Iterator<? extends X>> provider) {
        Objects.requireNonNull(provider);
        return new NiceIterator<X>(){
            private Iterator<? extends X> base;

            Iterator<? extends X> base() {
                return this.base == null ? (this.base = (Iterator)OntJenaException.notNull(provider.get())) : this.base;
            }

            public boolean hasNext() {
                return this.base().hasNext();
            }

            public X next() {
                return this.base().next();
            }

            public void remove() {
                this.base().remove();
            }

            public void close() {
                if (this.base != null) {
                    1.close(this.base);
                }
            }
        };
    }
}

