/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.utils;

import com.github.owlcs.ontapi.jena.impl.OntListImpl;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.RDFListImpl;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.util.NodeUtils;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;

public class Models {
    public static final Comparator<RDFNode> RDF_NODE_COMPARATOR = (r1, r2) -> NodeUtils.compareRDFTerms((Node)r1.asNode(), (Node)r2.asNode());
    public static final Comparator<Statement> STATEMENT_COMPARATOR = Comparator.comparing(Statement::getSubject, RDF_NODE_COMPARATOR).thenComparing(Statement::getPredicate, RDF_NODE_COMPARATOR).thenComparing(Statement::getObject, RDF_NODE_COMPARATOR);
    public static final RDFNode BLANK = new ResourceImpl();
    public static final Comparator<Statement> STATEMENT_COMPARATOR_IGNORE_BLANK = Comparator.comparing(s -> s.getSubject().isAnon() ? BLANK : s.getSubject(), RDF_NODE_COMPARATOR).thenComparing(s -> s.getPredicate().isAnon() ? BLANK : s.getPredicate(), RDF_NODE_COMPARATOR).thenComparing(s -> s.getObject().isAnon() ? BLANK : s.getObject(), RDF_NODE_COMPARATOR);
    public static final Literal TRUE = ResourceFactory.createTypedLiteral((Object)Boolean.TRUE);
    public static final Literal FALSE = ResourceFactory.createTypedLiteral((Object)Boolean.FALSE);

    public static RDFList createTypedList(Model model, Resource type, Collection<? extends RDFNode> members) {
        return Models.createTypedList(model, type, members.iterator());
    }

    public static RDFList createTypedList(Model model, Resource type, Iterator<? extends RDFNode> members) {
        return OntListImpl.createTypedList((EnhGraph)model, type, members);
    }

    public static boolean isInList(Model model, Resource candidate) {
        return model.contains(null, RDF.first, (RDFNode)candidate);
    }

    public static boolean isInList(Statement s) {
        return RDF.first.equals(s.getPredicate()) || RDF.rest.equals(s.getPredicate()) || RDF.nil.equals((Object)s.getObject());
    }

    public static Set<Statement> getListStatements(RDFList list) {
        return ((RDFListImpl)list).collectStatements();
    }

    public static Map<String, String> setNsPrefixes(PrefixMapping mapping, Map<String, String> prefixes) {
        Map init = mapping.getNsPrefixMap();
        init.keySet().forEach(arg_0 -> ((PrefixMapping)mapping).removeNsPrefix(arg_0));
        prefixes.forEach((p, u) -> mapping.setNsPrefix(p.replaceAll(":$", ""), u));
        return init;
    }

    public static Stream<String> langValues(Resource subject, Property predicate, String lang) {
        return Iter.asStream(subject.listProperties(predicate).mapWith(s -> {
            if (!s.getObject().isLiteral()) {
                return null;
            }
            if (!Models.filterByLangTag(s.getLiteral(), lang)) {
                return null;
            }
            return s.getString();
        }).filterDrop(Objects::isNull));
    }

    public static boolean filterByLangTag(Literal literal, String tag) {
        String other = literal.getLanguage();
        if (StringUtils.isEmpty((CharSequence)tag)) {
            return StringUtils.isEmpty((CharSequence)other);
        }
        return tag.trim().equalsIgnoreCase(other);
    }

    public static void deleteAll(Resource inModel) {
        Models.deleteAll(inModel, new HashSet<Node>());
    }

    private static void deleteAll(Resource r, Set<Node> viewed) {
        if (!viewed.add(r.asNode())) {
            return;
        }
        r.listProperties().toSet().forEach(s -> {
            RDFNode o = s.getObject();
            if (o.isAnon()) {
                Models.deleteAll(o.asResource(), viewed);
            }
            r.getModel().remove(s);
        });
    }

    public static Set<Statement> getAssociatedStatements(Resource inModel) {
        HashSet<Statement> res = new HashSet<Statement>();
        Models.calcAssociatedStatements(inModel, res);
        return res;
    }

    private static void calcAssociatedStatements(Resource root, Set<Statement> res) {
        if (root.canAs(RDFList.class)) {
            RDFList list = (RDFList)root.as(RDFList.class);
            if (list.isEmpty()) {
                return;
            }
            Models.getListStatements(list).forEach(statement -> {
                res.add((Statement)statement);
                if (!RDF.first.equals(statement.getPredicate())) {
                    return;
                }
                RDFNode obj = statement.getObject();
                if (obj.isAnon()) {
                    Models.calcAssociatedStatements(obj.asResource(), res);
                }
            });
            return;
        }
        root.listProperties().forEachRemaining(statement -> {
            try {
                if (!statement.getObject().isAnon() || res.stream().anyMatch(s -> statement.getObject().equals(s.getSubject()))) {
                    return;
                }
                Models.calcAssociatedStatements(statement.getObject().asResource(), res);
            }
            finally {
                res.add((Statement)statement);
            }
        });
    }

    public static ExtendedIterator<Statement> listAscendingStatements(RDFNode object) {
        return Iter.flatMap(object.getModel().listStatements(null, null, object), s -> s.getSubject().isAnon() ? Iter.concat(Iter.of(s), Models.listAscendingStatements((RDFNode)s.getSubject())) : Iter.of(s));
    }

    public static ExtendedIterator<Statement> listDescendingStatements(RDFNode subject) {
        if (!subject.isResource()) {
            return NullIterator.instance();
        }
        return Iter.flatMap(subject.asResource().listProperties(), s -> s.getObject().isAnon() ? Iter.concat(Iter.of(s), Models.listDescendingStatements((RDFNode)s.getResource())) : Iter.of(s));
    }

    public static Stream<Resource> subjects(RDFNode object) {
        Model m = Objects.requireNonNull(object.getModel(), "No model for a resource " + object);
        return Iter.fromSet(() -> m.getGraph().find(Node.ANY, Node.ANY, object.asNode()).mapWith(t -> m.wrapAsResource(t.getSubject())).toSet());
    }

    public static String toString(Statement st, PrefixMapping pm) {
        return String.format("[%s, %s, %s]", st.getSubject().asNode().toString(pm, false), st.getPredicate().asNode().toString(pm, false), st.getObject().asNode().toString(pm, true));
    }

    public static String toString(Statement inModel) {
        return Models.toString(inModel, (PrefixMapping)inModel.getModel());
    }

    public static boolean containsURI(RDFNode node, String uri) {
        if (node.isURIResource()) {
            return uri.equals(node.asResource().getURI());
        }
        return node.isLiteral() && uri.equals(node.asLiteral().getDatatypeURI());
    }

    public static boolean containsURI(Statement statement, String uri) {
        if (uri.equals(statement.getSubject().getURI())) {
            return true;
        }
        if (uri.equals(statement.getPredicate().getURI())) {
            return true;
        }
        return Models.containsURI(statement.getObject(), uri);
    }
}

