/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.utils;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.UnionGraph;
import com.github.owlcs.ontapi.jena.impl.OntGraphModelImpl;
import com.github.owlcs.ontapi.jena.impl.OntIndividualImpl;
import com.github.owlcs.ontapi.jena.impl.OntListImpl;
import com.github.owlcs.ontapi.jena.impl.OntObjectImpl;
import com.github.owlcs.ontapi.jena.impl.OntStatementImpl;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntEntity;
import com.github.owlcs.ontapi.jena.model.OntID;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.model.RDFNodeList;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.util.iterator.ExtendedIterator;

public class OntModels {
    public static <O extends OntObject> Class<O> getOntType(O object) {
        Class<? extends OntObject> res = object instanceof OntObjectImpl ? ((OntObjectImpl)object).getActualClass() : OntObjectImpl.findActualClass(object);
        return OntJenaException.notNull(res, "Can't determine the type of object " + object);
    }

    public static OntIndividual.Anonymous asAnonymousIndividual(RDFNode inModel) {
        return OntIndividualImpl.createAnonymousIndividual(inModel);
    }

    public static void insert(Supplier<Stream<OntModel>> manager, OntModel ont, boolean replace) {
        String uri = Objects.requireNonNull(ont.getID().getImportsIRI(), "Must be named ontology");
        manager.get().filter(m -> {
            try (Stream<String> uris = m.getID().imports();){
                boolean bl = uris.anyMatch(uri::equals);
                return bl;
            }
        }).peek(m -> {
            if (!replace) {
                return;
            }
            m.imports().filter(i -> uri.equals(i.getID().getImportsIRI())).findFirst().ifPresent(i -> ((UnionGraph)m.getGraph()).removeGraph(i.getGraph()));
        }).filter(m -> m.imports().map(OntModel::getID).map(OntID::getImportsIRI).noneMatch(uri::equals)).forEach(m -> m.addImport(ont));
    }

    public static void syncImports(OntModel m) {
        OntID id = m.getID();
        id.removeAll(OWL.imports);
        m.imports().peek(OntModels::syncImports).map(OntModel::getID).filter(RDFNode::isURIResource).map(OntID::getImportsIRI).forEach(id::addImport);
    }

    public static Stream<OntModel> importsClosure(OntModel m) {
        return Stream.concat(Stream.of(m), m.imports().flatMap(OntModels::importsClosure));
    }

    public static ExtendedIterator<OntModel> listImports(OntModel model) {
        if (model instanceof OntGraphModelImpl) {
            OntGraphModelImpl m = (OntGraphModelImpl)model;
            ExtendedIterator<OntGraphModelImpl> res = m.listImportModels(m.getOntPersonality());
            return res;
        }
        return Iter.create(model.imports().iterator());
    }

    public static <O extends OntObject> ExtendedIterator<O> listLocalObjects(OntModel model, Class<? extends O> type) {
        if (model instanceof OntGraphModelImpl) {
            return ((OntGraphModelImpl)model).listLocalOntObjects(type);
        }
        Stream<O> res = model.ontObjects(type);
        return Iter.create(res.iterator()).filterKeep(rec$ -> ((OntObject)rec$).isLocal());
    }

    public static ExtendedIterator<OntEntity> listLocalEntities(OntModel model) {
        if (model instanceof OntGraphModelImpl) {
            return ((OntGraphModelImpl)model).listLocalOntEntities();
        }
        return Iter.create(model.ontEntities().iterator()).filterKeep(rec$ -> ((OntObject)rec$).isLocal());
    }

    public static <R extends RDFNode> ExtendedIterator<R> listMembers(RDFNodeList<R> list) {
        if (list instanceof OntListImpl) {
            return ((OntListImpl)list).listMembers();
        }
        return Iter.create(list.members().iterator());
    }

    public static ExtendedIterator<OntClass> listClasses(OntIndividual i) {
        return i instanceof OntIndividualImpl ? ((OntIndividualImpl)i).listClasses() : Iter.create(i.classes().iterator());
    }

    public static ExtendedIterator<OntStatement> listLocalStatements(OntModel model, Resource s, Property p, RDFNode o) {
        if (model instanceof OntGraphModelImpl) {
            return ((OntGraphModelImpl)model).listLocalStatements(s, p, o);
        }
        return model.getBaseGraph().find(ModelCom.asNode((RDFNode)s), ModelCom.asNode((RDFNode)p), ModelCom.asNode((RDFNode)p)).mapWith(model::asStatement);
    }

    public static ExtendedIterator<OntStatement> listAnnotations(OntStatement s) {
        if (s instanceof OntStatementImpl) {
            return ((OntStatementImpl)s).listAnnotations();
        }
        return Iter.create(s.annotations().iterator());
    }

    public static ExtendedIterator<OntStatement> listAnnotations(OntObject o) {
        if (o instanceof OntObjectImpl) {
            return ((OntObjectImpl)o).listAnnotations();
        }
        return Iter.create(o.annotations().iterator());
    }

    public static ExtendedIterator<OntStatement> listSplitStatements(OntStatement statement) {
        return ((OntStatementImpl)statement).listSplitStatements();
    }

    public static Stream<OntStatement> annotations(OntStatement statement) {
        if (statement instanceof OntStatementImpl) {
            return Iter.asStream(OntModels.listAllAnnotations(statement));
        }
        return statement.annotations().flatMap(s -> Stream.concat(Stream.of(s), OntModels.annotations(s)));
    }

    public static ExtendedIterator<OntStatement> listAllAnnotations(OntStatement statement) {
        return Iter.flatMap(OntModels.listAnnotations(statement), s -> Iter.concat(Iter.of(s), OntModels.listAllAnnotations(s)));
    }
}

