/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.owlapi.objects;

import com.github.owlcs.ontapi.AsNode;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import com.github.owlcs.ontapi.jena.vocabulary.XSD;
import com.github.owlcs.ontapi.owlapi.InternalizedEntities;
import com.github.owlcs.ontapi.owlapi.OWLObjectImpl;
import com.github.owlcs.ontapi.owlapi.objects.entity.OWLBuiltinDatatypeImpl;
import com.github.owlcs.ontapi.owlapi.objects.entity.OWLDatatypeImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.jena.datatypes.BaseDatatype;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.impl.RDFLangString;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.graph.impl.LiteralLabelFactory;
import org.apache.jena.rdf.model.Resource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public class OWLLiteralImpl
extends OWLObjectImpl
implements OWLLiteral,
AsNode {
    private static final Set<String> NUMBER_DATATYPES = Stream.of(XSD.integer, XSD.xfloat, XSD.xdouble).map(Resource::getURI).collect(Iter.toUnmodifiableSet());
    protected static TypeMapper typeMapper = TypeMapper.getInstance();
    protected final transient LiteralLabel label;

    protected OWLLiteralImpl(LiteralLabel label) {
        this.label = Objects.requireNonNull(label);
    }

    public static OWLLiteralImpl createLiteral(String s) {
        return OWLLiteralImpl.newLiteral(LiteralLabelFactory.createTypedLiteral((Object)s));
    }

    public static OWLLiteralImpl createLiteral(String val, String lang) {
        return OWLLiteralImpl.newLiteral(LiteralLabelFactory.create((String)val, (String)OWLLiteralImpl.normalizeLanguageTag(lang)));
    }

    public static OWLLiteralImpl createLiteral(int i) {
        return OWLLiteralImpl.newLiteral(i, null, (RDFDatatype)XSDDatatype.XSDinteger);
    }

    public static OWLLiteralImpl createLiteral(boolean b) {
        return OWLLiteralImpl.newLiteral(LiteralLabelFactory.createTypedLiteral((Object)b));
    }

    public static OWLLiteralImpl createLiteral(double d) {
        return OWLLiteralImpl.newLiteral(LiteralLabelFactory.createTypedLiteral((Object)d));
    }

    public static OWLLiteralImpl createLiteral(float f) {
        return OWLLiteralImpl.newLiteral(LiteralLabelFactory.createTypedLiteral((Object)Float.valueOf(f)));
    }

    public static OWLLiteralImpl createLiteral(String txt, OWLDatatype owl) {
        if (owl.isRDFPlainLiteral() || InternalizedEntities.RDF_LANG_STRING.equals(owl)) {
            XSDDatatype dt;
            String lang;
            String lex;
            int sep = txt.lastIndexOf(64);
            if (sep != -1) {
                lex = txt.substring(0, sep);
                lang = OWLLiteralImpl.normalizeLanguageTag(txt.substring(sep + 1));
                dt = RDFLangString.rdfLangString;
            } else {
                lex = txt;
                lang = null;
                dt = XSDDatatype.XSDstring;
            }
            return OWLLiteralImpl.newLiteral((Object)lex, lang, (RDFDatatype)dt);
        }
        if (owl.isString()) {
            return OWLLiteralImpl.createLiteral(txt);
        }
        if (owl.isBoolean()) {
            return OWLLiteralImpl.parseBoolean(txt, owl);
        }
        if (owl.isFloat()) {
            return OWLLiteralImpl.parseFloat(txt, owl);
        }
        if (owl.isDouble()) {
            return OWLLiteralImpl.parseDouble(txt, owl);
        }
        if (owl.isInteger()) {
            return OWLLiteralImpl.parseInteger(txt, owl);
        }
        return OWLLiteralImpl.newLiteral(txt, null, owl);
    }

    public static String normalizeLanguageTag(String lang) {
        return lang == null ? "" : lang.trim().toLowerCase(Locale.ENGLISH);
    }

    public static OWLLiteralImpl parseBoolean(String txt, OWLDatatype dt) {
        return OWLLiteralImpl.createLiteral(OWLLiteralImpl.parseBoolean(txt.trim()));
    }

    public static boolean parseBoolean(String str) {
        return Boolean.parseBoolean(str) || "1".equals(str.trim());
    }

    public static OWLLiteralImpl parseDouble(String txt, OWLDatatype dt) {
        try {
            return OWLLiteralImpl.createLiteral(Double.parseDouble(txt));
        }
        catch (NumberFormatException e) {
            return OWLLiteralImpl.newLiteral(txt, null, dt);
        }
    }

    public static OWLLiteralImpl parseFloat(String txt, OWLDatatype dt) {
        if ("-0.0".equals(txt.trim())) {
            return OWLLiteralImpl.newLiteral(txt, null, dt);
        }
        try {
            return OWLLiteralImpl.createLiteral(Float.parseFloat(txt));
        }
        catch (NumberFormatException e) {
            return OWLLiteralImpl.newLiteral(txt, null, dt);
        }
    }

    public static OWLLiteralImpl parseInteger(String txt, OWLDatatype dt) {
        if ('0' == txt.trim().charAt(0)) {
            return OWLLiteralImpl.newLiteral(txt, null, dt);
        }
        try {
            return OWLLiteralImpl.createLiteral(Integer.parseInt(txt));
        }
        catch (NumberFormatException ex) {
            return OWLLiteralImpl.newLiteral(txt, null, dt);
        }
    }

    public static OWLLiteralImpl asONT(OWLLiteral literal) {
        if (literal instanceof OWLLiteralImpl) {
            return (OWLLiteralImpl)literal;
        }
        return OWLLiteralImpl.newLiteral(literal.getLiteral(), literal.getLang(), literal.getDatatype());
    }

    public static OWLLiteralImpl newLiteral(String txt, String lang, OWLDatatype owl) {
        return OWLLiteralImpl.newLiteral((Object)txt, lang, OWLLiteralImpl.getRDFDatatype(owl.getIRI().getIRIString()));
    }

    public static RDFDatatype getRDFDatatype(String uri) {
        RDFDatatype res = typeMapper.getTypeByName(uri);
        if (res == null) {
            res = new BaseDatatype(uri);
        }
        return res;
    }

    public static OWLLiteralImpl newLiteral(Object lex, String lang, RDFDatatype dt) {
        return OWLLiteralImpl.newLiteral(LiteralLabelFactory.createByValue((Object)lex, (String)lang, (RDFDatatype)dt));
    }

    public static OWLLiteralImpl newLiteral(LiteralLabel label) {
        return new OWLLiteralImpl(label);
    }

    protected static int calcLiteralLabelHashCode(LiteralLabel label) {
        if (label.isWellFormedRaw()) {
            Object value = label.getValue();
            String dtURI = label.getDatatypeURI();
            if (value instanceof Number && NUMBER_DATATYPES.contains(dtURI)) {
                return ((Number)value).intValue();
            }
            if (value instanceof Boolean && XSD.xboolean.getURI().equals(dtURI)) {
                return (Boolean)value != false ? 1 : 0;
            }
        }
        return label.getLexicalForm().hashCode();
    }

    protected static int calcHashCode(int index, LiteralLabel label, OWLDatatype datatype, String lang) {
        index = OWLObject.hashIteration((int)index, (int)datatype.hashCode());
        index = OWLObject.hashIteration((int)index, (int)(OWLLiteralImpl.calcLiteralLabelHashCode(label) * 65536));
        return OWLObject.hashIteration((int)index, (int)lang.hashCode());
    }

    public static boolean equals(LiteralLabel left, LiteralLabel right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (!Objects.equals(left.getLexicalForm(), right.getLexicalForm())) {
            return false;
        }
        if (!Objects.equals(left.language(), right.language())) {
            return false;
        }
        if (Objects.equals(left.getDatatype(), right.getDatatype())) {
            return true;
        }
        return Objects.equals(OWLLiteralImpl.getDatatypeURI(left), OWLLiteralImpl.getDatatypeURI(right));
    }

    public static String getDatatypeURI(LiteralLabel label) {
        String uri = label.getDatatypeURI();
        String lang = label.language();
        if (uri != null) {
            if (RDF.PlainLiteral.getURI().equals(uri) && lang.isEmpty()) {
                return XSD.xstring.getURI();
            }
            return uri;
        }
        return lang.isEmpty() ? XSD.xstring.getURI() : RDF.langString.getURI();
    }

    @Override
    public Node asNode() {
        return NodeFactory.createLiteral((LiteralLabel)this.label);
    }

    public LiteralLabel getLiteralLabel() {
        return this.label;
    }

    public String getLiteral() {
        return this.label.getLexicalForm();
    }

    public String getLang() {
        return this.label.language();
    }

    public String getDatatypeURI() {
        return OWLLiteralImpl.getDatatypeURI(this.label);
    }

    public OWLDatatype getDatatype() {
        String uri = this.getDatatypeURI();
        OWLDatatype res = OWLBuiltinDatatypeImpl.BUILTIN_OWL_DATATYPES.get(uri);
        return res != null ? res : new OWLDatatypeImpl(IRI.create((String)uri));
    }

    public boolean hasLang() {
        return !this.label.language().isEmpty();
    }

    public boolean hasLang(@Nullable String lang) {
        if (lang == null) {
            return !this.hasLang();
        }
        return this.getLang().equalsIgnoreCase(lang.trim());
    }

    public boolean isRDFPlainLiteral() {
        return this.getDatatype().isRDFPlainLiteral();
    }

    public boolean isInteger() {
        return this.getDatatype().isInteger();
    }

    public boolean isBoolean() {
        return this.getDatatype().isBoolean();
    }

    public boolean isDouble() {
        return this.getDatatype().isDouble();
    }

    public boolean isFloat() {
        return this.getDatatype().isFloat();
    }

    public int parseInteger() {
        return Integer.parseInt(this.getLiteral());
    }

    public boolean parseBoolean() {
        return OWLLiteralImpl.parseBoolean(this.getLiteral());
    }

    public double parseDouble() {
        return Double.parseDouble(this.getLiteral());
    }

    public float parseFloat() {
        String res = this.getLiteral();
        if ("inf".equalsIgnoreCase(res)) {
            return Float.POSITIVE_INFINITY;
        }
        if ("-inf".equalsIgnoreCase(res)) {
            return Float.NEGATIVE_INFINITY;
        }
        return Float.parseFloat(res);
    }

    @Override
    protected Set<OWLEntity> getSignatureSet() {
        return OWLLiteralImpl.createSet(this.getDatatype());
    }

    @Override
    protected Set<OWLDatatype> getDatatypeSet() {
        return OWLLiteralImpl.createSet(this.getDatatype());
    }

    @Override
    public boolean containsEntityInSignature(@Nullable OWLEntity entity) {
        if (entity == null || !entity.isOWLDatatype()) {
            return false;
        }
        return this.getDatatype().equals(entity);
    }

    @Override
    protected Set<OWLClass> getNamedClassSet() {
        return OWLLiteralImpl.createSet();
    }

    @Override
    protected Set<OWLNamedIndividual> getNamedIndividualSet() {
        return OWLLiteralImpl.createSet();
    }

    @Override
    protected Set<OWLDataProperty> getDataPropertySet() {
        return OWLLiteralImpl.createSet();
    }

    @Override
    protected Set<OWLObjectProperty> getObjectPropertySet() {
        return OWLLiteralImpl.createSet();
    }

    @Override
    protected Set<OWLAnnotationProperty> getAnnotationPropertySet() {
        return OWLLiteralImpl.createSet();
    }

    @Override
    protected Set<OWLClassExpression> getClassExpressionSet() {
        return OWLLiteralImpl.createSet();
    }

    @Override
    protected Set<OWLAnonymousIndividual> getAnonymousIndividualSet() {
        return OWLLiteralImpl.createSet();
    }

    public int initHashCode() {
        return OWLLiteralImpl.calcHashCode(this.hashIndex(), this.label, this.getDatatype(), this.getLang());
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OWLLiteral)) {
            return false;
        }
        if (obj instanceof OWLLiteralImpl) {
            OWLLiteralImpl other = (OWLLiteralImpl)obj;
            if (this.notSame(other)) {
                return false;
            }
            return OWLLiteralImpl.equals(this.label, other.getLiteralLabel());
        }
        if (obj instanceof AsNode) {
            return this.asNode().equals((Object)((AsNode)obj).asNode());
        }
        return super.equals(obj);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.label.getDatatypeURI());
        out.writeObject(this.label.language());
        out.writeObject(this.label.getLexicalForm());
    }

    private void readObject(ObjectInputStream in) throws Exception {
        in.defaultReadObject();
        String uri = (String)in.readObject();
        String lang = (String)in.readObject();
        String value = (String)in.readObject();
        LiteralLabel label = LiteralLabelFactory.createByValue((Object)value, (String)lang, (RDFDatatype)OWLLiteralImpl.getRDFDatatype(uri));
        Field field = this.getClass().getDeclaredField("label");
        field.setAccessible(true);
        field.set(this, label);
        field.setAccessible(false);
    }
}

