/*
 * Decompiled with CFR 0.152.
 */
package com.github.oxo42.stateless4j;

import com.github.oxo42.stateless4j.StateRepresentation;
import com.github.oxo42.stateless4j.delegates.Action;
import com.github.oxo42.stateless4j.delegates.Action1;
import com.github.oxo42.stateless4j.delegates.Action2;
import com.github.oxo42.stateless4j.delegates.Action3;
import com.github.oxo42.stateless4j.delegates.Action4;
import com.github.oxo42.stateless4j.delegates.Func;
import com.github.oxo42.stateless4j.delegates.Func2;
import com.github.oxo42.stateless4j.delegates.Func3;
import com.github.oxo42.stateless4j.delegates.Func4;
import com.github.oxo42.stateless4j.delegates.FuncBoolean;
import com.github.oxo42.stateless4j.transitions.Transition;
import com.github.oxo42.stateless4j.transitions.TransitioningTriggerBehaviour;
import com.github.oxo42.stateless4j.triggers.DynamicTriggerBehaviour;
import com.github.oxo42.stateless4j.triggers.IgnoredTriggerBehaviour;
import com.github.oxo42.stateless4j.triggers.TriggerWithParameters1;
import com.github.oxo42.stateless4j.triggers.TriggerWithParameters2;
import com.github.oxo42.stateless4j.triggers.TriggerWithParameters3;

public class StateConfiguration<S, T> {
    private static final FuncBoolean NO_GUARD = new FuncBoolean(){

        @Override
        public boolean call() {
            return true;
        }
    };
    private final StateRepresentation<S, T> representation;
    private final Func2<S, StateRepresentation<S, T>> lookup;

    public StateConfiguration(StateRepresentation<S, T> representation, Func2<S, StateRepresentation<S, T>> lookup) {
        assert (representation != null) : "representation is null";
        assert (lookup != null) : "lookup is null";
        this.representation = representation;
        this.lookup = lookup;
    }

    public StateConfiguration<S, T> permit(T trigger, S destinationState) {
        this.enforceNotIdentityTransition(destinationState);
        return this.publicPermit(trigger, destinationState);
    }

    public StateConfiguration<S, T> permitIf(T trigger, S destinationState, FuncBoolean guard) {
        this.enforceNotIdentityTransition(destinationState);
        return this.publicPermitIf(trigger, destinationState, guard);
    }

    public StateConfiguration<S, T> permitReentry(T trigger) {
        return this.publicPermit(trigger, this.representation.getUnderlyingState());
    }

    public StateConfiguration<S, T> permitReentryIf(T trigger, FuncBoolean guard) {
        return this.publicPermitIf(trigger, this.representation.getUnderlyingState(), guard);
    }

    public StateConfiguration<S, T> ignore(T trigger) {
        return this.ignoreIf(trigger, NO_GUARD);
    }

    public StateConfiguration<S, T> ignoreIf(T trigger, FuncBoolean guard) {
        assert (guard != null) : "guard is null";
        this.representation.addTriggerBehaviour(new IgnoredTriggerBehaviour(trigger, guard));
        return this;
    }

    public StateConfiguration<S, T> onEntry(final Action entryAction) {
        assert (entryAction != null) : "entryAction is null";
        return this.onEntry(new Action1<Transition<S, T>>(){

            @Override
            public void doIt(Transition<S, T> t) {
                entryAction.doIt();
            }
        });
    }

    public StateConfiguration<S, T> onEntry(final Action1<Transition<S, T>> entryAction) {
        assert (entryAction != null) : "entryAction is null";
        this.representation.addEntryAction(new Action2<Transition<S, T>, Object[]>(){

            @Override
            public void doIt(Transition<S, T> arg1, Object[] arg2) {
                entryAction.doIt(arg1);
            }
        });
        return this;
    }

    public StateConfiguration<S, T> onEntryFrom(T trigger, final Action entryAction) {
        assert (entryAction != null) : "entryAction is null";
        return this.onEntryFrom(trigger, new Action1<Transition<S, T>>(){

            @Override
            public void doIt(Transition<S, T> arg1) {
                entryAction.doIt();
            }
        });
    }

    public StateConfiguration<S, T> onEntryFrom(T trigger, final Action1<Transition<S, T>> entryAction) {
        assert (entryAction != null) : "entryAction is null";
        this.representation.addEntryAction(trigger, new Action2<Transition<S, T>, Object[]>(){

            @Override
            public void doIt(Transition<S, T> arg1, Object[] arg2) {
                entryAction.doIt(arg1);
            }
        });
        return this;
    }

    public <TArg0> StateConfiguration<S, T> onEntryFrom(TriggerWithParameters1<TArg0, S, T> trigger, final Action1<TArg0> entryAction, Class<TArg0> classe0) {
        assert (entryAction != null) : "entryAction is null";
        return this.onEntryFrom(trigger, new Action2<TArg0, Transition<S, T>>(){

            @Override
            public void doIt(TArg0 arg1, Transition<S, T> arg2) {
                entryAction.doIt(arg1);
            }
        }, classe0);
    }

    public <TArg0> StateConfiguration<S, T> onEntryFrom(TriggerWithParameters1<TArg0, S, T> trigger, final Action2<TArg0, Transition<S, T>> entryAction, Class<TArg0> classe0) {
        assert (trigger != null) : "trigger is null";
        assert (entryAction != null) : "entryAction is null";
        this.representation.addEntryAction(trigger.getTrigger(), new Action2<Transition<S, T>, Object[]>(){

            @Override
            public void doIt(Transition<S, T> t, Object[] arg2) {
                entryAction.doIt(arg2[0], t);
            }
        });
        return this;
    }

    public <TArg0, TArg1> StateConfiguration<S, T> onEntryFrom(TriggerWithParameters2<TArg0, TArg1, S, T> trigger, final Action2<TArg0, TArg1> entryAction, Class<TArg0> classe0, Class<TArg1> classe1) {
        assert (entryAction != null) : "entryAction is null";
        return this.onEntryFrom(trigger, new Action3<TArg0, TArg1, Transition<S, T>>(){

            @Override
            public void doIt(TArg0 a0, TArg1 a1, Transition<S, T> t) {
                entryAction.doIt(a0, a1);
            }
        }, classe0, classe1);
    }

    public <TArg0, TArg1> StateConfiguration<S, T> onEntryFrom(TriggerWithParameters2<TArg0, TArg1, S, T> trigger, final Action3<TArg0, TArg1, Transition<S, T>> entryAction, Class<TArg0> classe0, Class<TArg1> classe1) {
        assert (trigger != null) : "trigger is null";
        assert (entryAction != null) : "entryAction is null";
        this.representation.addEntryAction(trigger.getTrigger(), new Action2<Transition<S, T>, Object[]>(){

            @Override
            public void doIt(Transition<S, T> t, Object[] args) {
                entryAction.doIt(args[0], args[1], t);
            }
        });
        return this;
    }

    public <TArg0, TArg1, TArg2> StateConfiguration<S, T> onEntryFrom(TriggerWithParameters3<TArg0, TArg1, TArg2, S, T> trigger, final Action3<TArg0, TArg1, TArg2> entryAction, Class<TArg0> classe0, Class<TArg1> classe1, Class<TArg2> classe2) {
        assert (entryAction != null) : "entryAction is null";
        return this.onEntryFrom(trigger, new Action4<TArg0, TArg1, TArg2, Transition<S, T>>(){

            @Override
            public void doIt(TArg0 a0, TArg1 a1, TArg2 a2, Transition<S, T> t) {
                entryAction.doIt(a0, a1, a2);
            }
        }, classe0, classe1, classe2);
    }

    public <TArg0, TArg1, TArg2> StateConfiguration<S, T> onEntryFrom(TriggerWithParameters3<TArg0, TArg1, TArg2, S, T> trigger, final Action4<TArg0, TArg1, TArg2, Transition<S, T>> entryAction, Class<TArg0> classe0, Class<TArg1> classe1, Class<TArg2> classe2) {
        assert (trigger != null) : "trigger is null";
        assert (entryAction != null) : "entryAction is null";
        this.representation.addEntryAction(trigger.getTrigger(), new Action2<Transition<S, T>, Object[]>(){

            @Override
            public void doIt(Transition<S, T> t, Object[] args) {
                entryAction.doIt(args[0], args[1], args[2], t);
            }
        });
        return this;
    }

    public StateConfiguration<S, T> onExit(final Action exitAction) {
        assert (exitAction != null) : "exitAction is null";
        return this.onExit(new Action1<Transition<S, T>>(){

            @Override
            public void doIt(Transition<S, T> arg1) {
                exitAction.doIt();
            }
        });
    }

    public StateConfiguration<S, T> onExit(Action1<Transition<S, T>> exitAction) {
        assert (exitAction != null) : "exitAction is null";
        this.representation.addExitAction(exitAction);
        return this;
    }

    public StateConfiguration<S, T> substateOf(S superstate) {
        StateRepresentation<S, T> superRepresentation = this.lookup.call(superstate);
        this.representation.setSuperstate(superRepresentation);
        superRepresentation.addSubstate(this.representation);
        return this;
    }

    public StateConfiguration<S, T> permitDynamic(T trigger, Func<S> destinationStateSelector) {
        return this.permitDynamicIf(trigger, destinationStateSelector, NO_GUARD);
    }

    public <TArg0> StateConfiguration<S, T> permitDynamic(TriggerWithParameters1<TArg0, S, T> trigger, Func2<TArg0, S> destinationStateSelector) {
        return this.permitDynamicIf(trigger, destinationStateSelector, NO_GUARD);
    }

    public <TArg0, TArg1> StateConfiguration<S, T> permitDynamic(TriggerWithParameters2<TArg0, TArg1, S, T> trigger, Func3<TArg0, TArg1, S> destinationStateSelector) {
        return this.permitDynamicIf(trigger, destinationStateSelector, NO_GUARD);
    }

    public <TArg0, TArg1, TArg2> StateConfiguration<S, T> permitDynamic(TriggerWithParameters3<TArg0, TArg1, TArg2, S, T> trigger, Func4<TArg0, TArg1, TArg2, S> destinationStateSelector) {
        return this.permitDynamicIf(trigger, destinationStateSelector, NO_GUARD);
    }

    public StateConfiguration<S, T> permitDynamicIf(T trigger, final Func<S> destinationStateSelector, FuncBoolean guard) {
        assert (destinationStateSelector != null) : "destinationStateSelector is null";
        return this.publicPermitDynamicIf(trigger, new Func2<Object[], S>(){

            @Override
            public S call(Object[] arg0) {
                return destinationStateSelector.call();
            }
        }, guard);
    }

    public <TArg0> StateConfiguration<S, T> permitDynamicIf(TriggerWithParameters1<TArg0, S, T> trigger, final Func2<TArg0, S> destinationStateSelector, FuncBoolean guard) {
        assert (trigger != null) : "trigger is null";
        assert (destinationStateSelector != null) : "destinationStateSelector is null";
        return this.publicPermitDynamicIf(trigger.getTrigger(), new Func2<Object[], S>(){

            @Override
            public S call(Object[] args) {
                return destinationStateSelector.call(args[0]);
            }
        }, guard);
    }

    public <TArg0, TArg1> StateConfiguration<S, T> permitDynamicIf(TriggerWithParameters2<TArg0, TArg1, S, T> trigger, final Func3<TArg0, TArg1, S> destinationStateSelector, FuncBoolean guard) {
        assert (trigger != null) : "trigger is null";
        assert (destinationStateSelector != null) : "destinationStateSelector is null";
        return this.publicPermitDynamicIf(trigger.getTrigger(), new Func2<Object[], S>(){

            @Override
            public S call(Object[] args) {
                return destinationStateSelector.call(args[0], args[1]);
            }
        }, guard);
    }

    public <TArg0, TArg1, TArg2> StateConfiguration<S, T> permitDynamicIf(TriggerWithParameters3<TArg0, TArg1, TArg2, S, T> trigger, final Func4<TArg0, TArg1, TArg2, S> destinationStateSelector, FuncBoolean guard) {
        assert (trigger != null) : "trigger is null";
        assert (destinationStateSelector != null) : "destinationStateSelector is null";
        return this.publicPermitDynamicIf(trigger.getTrigger(), new Func2<Object[], S>(){

            @Override
            public S call(Object[] args) {
                return destinationStateSelector.call(args[0], args[1], args[2]);
            }
        }, guard);
    }

    void enforceNotIdentityTransition(S destination) {
        if (destination.equals(this.representation.getUnderlyingState())) {
            throw new IllegalStateException("Permit() (and PermitIf()) require that the destination state is not equal to the source state. To accept a trigger without changing state, use either Ignore() or PermitReentry().");
        }
    }

    StateConfiguration<S, T> publicPermit(T trigger, S destinationState) {
        return this.publicPermitIf(trigger, destinationState, NO_GUARD);
    }

    StateConfiguration<S, T> publicPermitIf(T trigger, S destinationState, FuncBoolean guard) {
        assert (guard != null) : "guard is null";
        this.representation.addTriggerBehaviour(new TransitioningTriggerBehaviour<S, T>(trigger, destinationState, guard));
        return this;
    }

    StateConfiguration<S, T> publicPermitDynamic(T trigger, Func2<Object[], S> destinationStateSelector) {
        return this.publicPermitDynamicIf(trigger, destinationStateSelector, NO_GUARD);
    }

    StateConfiguration<S, T> publicPermitDynamicIf(T trigger, Func2<Object[], S> destinationStateSelector, FuncBoolean guard) {
        assert (destinationStateSelector != null) : "destinationStateSelector is null";
        assert (guard != null) : "guard is null";
        this.representation.addTriggerBehaviour(new DynamicTriggerBehaviour<S, T>(trigger, destinationStateSelector, guard));
        return this;
    }
}

