/*
 * Decompiled with CFR 0.152.
 */
package com.poiji.bind.mapping;

import com.poiji.annotation.ExcelCell;
import com.poiji.annotation.ExcelCellName;
import com.poiji.annotation.ExcelRow;
import com.poiji.bind.Unmarshaller;
import com.poiji.exception.IllegalCastException;
import com.poiji.exception.PoijiInstantiationException;
import com.poiji.option.PoijiOptions;
import com.poiji.util.Casting;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

abstract class HSSFUnmarshaller
implements Unmarshaller {
    private final DataFormatter dataFormatter;
    protected final PoijiOptions options;
    private final Casting casting;
    private Map<String, Integer> titles;

    HSSFUnmarshaller(PoijiOptions options) {
        this.options = options;
        this.dataFormatter = new DataFormatter();
        this.titles = new HashMap<String, Integer>();
        this.casting = Casting.getInstance();
    }

    @Override
    public <T> void unmarshal(Class<T> type, Consumer<? super T> consumer) {
        Workbook workbook = this.workbook();
        Sheet sheet = this.getSheetToProcess(workbook, this.options);
        int skip = this.options.skip();
        int maxPhysicalNumberOfRows = sheet.getPhysicalNumberOfRows() + 1 - skip;
        this.loadColumnTitles(sheet, maxPhysicalNumberOfRows);
        for (Row currentRow : sheet) {
            if (this.skip(currentRow, skip) || this.isRowEmpty(currentRow)) continue;
            T t = this.deserialize0(currentRow, type);
            consumer.accept(t);
        }
    }

    private Sheet getSheetToProcess(Workbook workbook, PoijiOptions options) {
        int requestedIndex = options.sheetIndex();
        if (options.ignoreHiddenSheets()) {
            int nonHiddenSheetIndex = 0;
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                if (workbook.isSheetHidden(i) || workbook.isSheetVeryHidden(i)) continue;
                if (nonHiddenSheetIndex == requestedIndex) {
                    return workbook.getSheetAt(i);
                }
                ++nonHiddenSheetIndex;
            }
        }
        return workbook.getSheetAt(requestedIndex);
    }

    private void loadColumnTitles(Sheet sheet, int maxPhysicalNumberOfRows) {
        if (maxPhysicalNumberOfRows > 0) {
            Row firstRow = sheet.getRow(0);
            for (Cell cell : firstRow) {
                this.titles.put(cell.getStringCellValue(), cell.getColumnIndex());
            }
        }
    }

    private <T> T deserialize0(Row currentRow, Class<T> type) {
        T instance;
        try {
            instance = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new PoijiInstantiationException("Cannot create a new instance of " + type.getName());
        }
        return this.setFieldValue(currentRow, type, instance);
    }

    private <T> T tailSetFieldValue(Row currentRow, Class<? super T> type, T instance) {
        for (Field field : type.getDeclaredFields()) {
            Integer titleColumn;
            ExcelCell index;
            ExcelRow excelRow = field.getAnnotation(ExcelRow.class);
            if (excelRow != null) {
                Object o = this.casting.castValue(field.getType(), String.valueOf(currentRow.getRowNum()), this.options);
                this.setFieldData(instance, field, o);
            }
            if ((index = field.getAnnotation(ExcelCell.class)) != null) {
                this.constructTypeValue(currentRow, instance, field, index.value());
                continue;
            }
            ExcelCellName excelCellName = field.getAnnotation(ExcelCellName.class);
            if (excelCellName == null || (titleColumn = this.titles.get(excelCellName.value())) == null) continue;
            this.constructTypeValue(currentRow, instance, field, titleColumn);
        }
        return instance;
    }

    private <T> void constructTypeValue(Row currentRow, T instance, Field field, int column) {
        Class<?> fieldType = field.getType();
        Cell cell = currentRow.getCell(column);
        if (cell != null) {
            String value = this.dataFormatter.formatCellValue(cell);
            Object o = this.casting.castValue(fieldType, value, this.options);
            this.setFieldData(instance, field, o);
        }
    }

    private <T> void setFieldData(T instance, Field field, Object o) {
        try {
            field.setAccessible(true);
            field.set(instance, o);
        }
        catch (IllegalAccessException e) {
            throw new IllegalCastException("Unexpected cast type {" + o + "} of field" + field.getName());
        }
    }

    private <T> T setFieldValue(Row currentRow, Class<? super T> subclass, T instance) {
        return subclass == null ? instance : this.tailSetFieldValue(currentRow, subclass, this.setFieldValue(currentRow, subclass.getSuperclass(), instance));
    }

    private boolean skip(Row currentRow, int skip) {
        return currentRow.getRowNum() + 1 <= skip;
    }

    private boolean isRowEmpty(Row row) {
        for (int c = row.getFirstCellNum(); c < row.getLastCellNum(); ++c) {
            Cell cell = row.getCell(c, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            if (cell == null || cell.getCellTypeEnum() == CellType.BLANK) continue;
            return false;
        }
        return true;
    }

    protected abstract Workbook workbook();
}

