/*
 * Decompiled with CFR 0.152.
 */
package com.poiji.bind.mapping;

import com.poiji.annotation.ExcelCell;
import com.poiji.annotation.ExcelCellName;
import com.poiji.annotation.ExcelRow;
import com.poiji.exception.IllegalCastException;
import com.poiji.option.PoijiOptions;
import com.poiji.util.Casting;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.usermodel.XSSFComment;

final class PoijiHandler<T>
implements XSSFSheetXMLHandler.SheetContentsHandler {
    private T instance;
    private Consumer<? super T> consumer;
    private int internalCount;
    private Class<T> type;
    private PoijiOptions options;
    private final Casting casting;
    private Map<String, Integer> titles;

    PoijiHandler(Class<T> type, PoijiOptions options, Consumer<T> consumer) {
        this.type = type;
        this.options = options;
        this.consumer = consumer;
        this.casting = Casting.getInstance();
        this.titles = new HashMap<String, Integer>();
    }

    private <T> T newInstanceOf(Class<T> type) {
        T newInstance;
        try {
            newInstance = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalCastException("Cannot create a new instance of " + type.getName());
        }
        return newInstance;
    }

    private void setFieldValue(String content, Class<? super T> subclass, int column) {
        if (subclass != Object.class) {
            this.setValue(content, subclass, column);
            this.setFieldValue(content, subclass.getSuperclass(), column);
        }
    }

    private void setValue(String content, Class<? super T> type, int column) {
        for (Field field : type.getDeclaredFields()) {
            ExcelCell index;
            ExcelRow excelRow = field.getAnnotation(ExcelRow.class);
            if (excelRow != null) {
                Object o = this.casting.castValue(field.getType(), String.valueOf(this.internalCount), this.options);
                this.setFieldData(field, o);
            }
            if ((index = field.getAnnotation(ExcelCell.class)) != null) {
                Class<?> fieldType = field.getType();
                if (column != index.value()) continue;
                Object o = this.casting.castValue(fieldType, content, this.options);
                this.setFieldData(field, o);
                continue;
            }
            ExcelCellName excelCellName = field.getAnnotation(ExcelCellName.class);
            if (excelCellName == null) continue;
            Class<?> fieldType = field.getType();
            Integer titleColumn = this.titles.get(excelCellName.value());
            if (titleColumn == null || column != titleColumn) continue;
            Object o = this.casting.castValue(fieldType, content, this.options);
            this.setFieldData(field, o);
        }
    }

    private void setFieldData(Field field, Object o) {
        try {
            field.setAccessible(true);
            field.set(this.instance, o);
        }
        catch (IllegalAccessException e) {
            throw new IllegalCastException("Unexpected cast type {" + o + "} of field" + field.getName());
        }
    }

    public void startRow(int rowNum) {
        if (rowNum + 1 > this.options.skip()) {
            this.instance = this.newInstanceOf(this.type);
        }
    }

    public void endRow(int rowNum) {
        if (this.internalCount != rowNum) {
            return;
        }
        if (rowNum + 1 > this.options.skip()) {
            this.consumer.accept(this.instance);
        }
    }

    public void cell(String cellReference, String formattedValue, XSSFComment comment) {
        int row;
        CellAddress cellAddress = new CellAddress(cellReference);
        this.internalCount = row = cellAddress.getRow();
        int column = cellAddress.getColumn();
        if (row == 0) {
            this.titles.put(formattedValue, column);
        }
        if (row + 1 <= this.options.skip()) {
            return;
        }
        this.setFieldValue(formattedValue, this.type, column);
    }

    public void headerFooter(String text, boolean isHeader, String tagName) {
    }
}

