/*
 * Decompiled with CFR 0.152.
 */
package com.poiji.config;

import com.poiji.config.Casting;
import com.poiji.option.PoijiOptions;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public final class DefaultCasting
implements Casting {
    private int primitiveIntegerValue(String value) {
        try {
            return new Integer(value);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    private Integer integerValue(String value, PoijiOptions options) {
        try {
            return new Integer(value);
        }
        catch (NumberFormatException nfe) {
            if (Boolean.TRUE.equals(options.preferNullOverDefault())) {
                return null;
            }
            return 0;
        }
    }

    private long primitiveLongValue(String value) {
        try {
            return new Long(value);
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
    }

    private Long longValue(String value, PoijiOptions options) {
        try {
            return new Long(value);
        }
        catch (NumberFormatException nfe) {
            if (Boolean.TRUE.equals(options.preferNullOverDefault())) {
                return null;
            }
            return 0L;
        }
    }

    private double primitiveDoubleValue(String value) {
        try {
            return new Double(value);
        }
        catch (NumberFormatException nfe) {
            return 0.0;
        }
    }

    private Double doubleValue(String value, PoijiOptions options) {
        try {
            return new Double(value);
        }
        catch (NumberFormatException nfe) {
            if (Boolean.TRUE.equals(options.preferNullOverDefault())) {
                return null;
            }
            return 0.0;
        }
    }

    private float primitiveFloatValue(String value) {
        try {
            return new Float(value).floatValue();
        }
        catch (NumberFormatException nfe) {
            return 0.0f;
        }
    }

    private Float floatValue(String value, PoijiOptions options) {
        try {
            return new Float(value);
        }
        catch (NumberFormatException nfe) {
            if (Boolean.TRUE.equals(options.preferNullOverDefault())) {
                return null;
            }
            return Float.valueOf(0.0f);
        }
    }

    private Date defaultDate(PoijiOptions options) {
        if (Boolean.TRUE.equals(options.preferNullOverDefault())) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }

    private LocalDate defaultLocalDate(PoijiOptions options) {
        if (Boolean.TRUE.equals(options.preferNullOverDefault())) {
            return null;
        }
        return LocalDate.now();
    }

    private BigDecimal bigDecimalValue(String value, PoijiOptions options) {
        try {
            String clean = value != null ? value.replace(",", ".") : "";
            return new BigDecimal(clean);
        }
        catch (NumberFormatException nfe) {
            if (Boolean.TRUE.equals(options.preferNullOverDefault())) {
                return null;
            }
            return BigDecimal.ZERO;
        }
    }

    private Date dateValue(String value, PoijiOptions options) {
        if (options.getDateRegex() != null && !value.matches(options.getDateRegex())) {
            return this.defaultDate(options);
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(options.datePattern());
            sdf.setLenient(options.getDateLenient());
            return sdf.parse(value);
        }
        catch (ParseException e) {
            return this.defaultDate(options);
        }
    }

    private LocalDate localDateValue(String value, PoijiOptions options) {
        if (options.getDateRegex() != null && !value.matches(options.getDateRegex())) {
            return this.defaultLocalDate(options);
        }
        try {
            return LocalDate.parse(value, options.dateTimeFormatter());
        }
        catch (DateTimeParseException e) {
            return this.defaultLocalDate(options);
        }
    }

    private Object enumValue(String value, Class type) {
        return Arrays.stream(type.getEnumConstants()).filter(o -> ((Enum)o).name().equals(value)).findFirst().orElse(null);
    }

    @Override
    public Object castValue(Class<?> fieldType, String value, PoijiOptions options) {
        if (options.trimCellValue()) {
            value = value.trim();
        }
        Object o = value;
        o = fieldType.getName().equals("int") ? Integer.valueOf(this.primitiveIntegerValue(value)) : (fieldType.getName().equals("java.lang.Integer") ? this.integerValue(value, options) : (fieldType.getName().equals("java.math.BigDecimal") ? this.bigDecimalValue(value, options) : (fieldType.getName().equals("long") ? Long.valueOf(this.primitiveLongValue(value)) : (fieldType.getName().equals("java.lang.Long") ? this.longValue(value, options) : (fieldType.getName().equals("double") ? Double.valueOf(this.primitiveDoubleValue(value)) : (fieldType.getName().equals("java.lang.Double") ? this.doubleValue(value, options) : (fieldType.getName().equals("float") ? Float.valueOf(this.primitiveFloatValue(value)) : (fieldType.getName().equals("java.lang.Float") ? this.floatValue(value, options) : (fieldType.getName().equals("boolean") || fieldType.getName().equals("java.lang.Boolean") ? Boolean.valueOf(value) : (fieldType.getName().equals("java.util.Date") ? this.dateValue(value, options) : (fieldType.getName().equals("java.time.LocalDate") ? this.localDateValue(value, options) : (fieldType.isEnum() ? this.enumValue(value, fieldType) : (value.isEmpty() ? (Boolean.TRUE.equals(options.preferNullOverDefault()) ? null : value) : value)))))))))))));
        return o;
    }
}

