/*
 * Decompiled with CFR 0.152.
 */
package com.poiji.bind.mapping;

import com.poiji.annotation.ExcelCell;
import com.poiji.annotation.ExcelCellName;
import com.poiji.annotation.ExcelCellRange;
import com.poiji.annotation.ExcelRow;
import com.poiji.bind.Unmarshaller;
import com.poiji.bind.mapping.SheetNameExtractor;
import com.poiji.config.Casting;
import com.poiji.exception.IllegalCastException;
import com.poiji.option.PoijiOptions;
import com.poiji.util.ReflectUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

abstract class HSSFUnmarshaller
implements Unmarshaller {
    private final DataFormatter dataFormatter;
    protected final PoijiOptions options;
    private final Casting casting;
    private Map<String, Integer> titles;
    private int limit;
    private int internalCount;

    HSSFUnmarshaller(PoijiOptions options) {
        this.options = options;
        this.limit = options.getLimit();
        this.dataFormatter = new DataFormatter();
        this.titles = new HashMap<String, Integer>();
        this.casting = options.getCasting();
    }

    @Override
    public <T> void unmarshal(Class<T> type, Consumer<? super T> consumer) {
        Workbook workbook = this.workbook();
        Optional<String> maybeSheetName = SheetNameExtractor.getSheetName(type, this.options);
        Sheet sheet = this.getSheetToProcess(workbook, this.options, maybeSheetName.orElse(null));
        int skip = this.options.skip();
        int maxPhysicalNumberOfRows = sheet.getPhysicalNumberOfRows() + 1 - skip;
        this.loadColumnTitles(sheet, maxPhysicalNumberOfRows);
        for (Row currentRow : sheet) {
            if (this.skip(currentRow, skip) || this.isRowEmpty(currentRow)) continue;
            ++this.internalCount;
            if (this.limit != 0 && this.internalCount > this.limit) {
                return;
            }
            T t = this.deserialize0(currentRow, type);
            consumer.accept(t);
        }
    }

    private Sheet getSheetToProcess(Workbook workbook, PoijiOptions options, String sheetName) {
        int nonHiddenSheetIndex = 0;
        int requestedIndex = options.sheetIndex();
        Sheet sheet = null;
        if (options.ignoreHiddenSheets()) {
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                if (workbook.isSheetHidden(i) || workbook.isSheetVeryHidden(i)) continue;
                if (sheetName == null ? nonHiddenSheetIndex == requestedIndex : workbook.getSheetName(i).equalsIgnoreCase(sheetName)) {
                    return workbook.getSheetAt(i);
                }
                ++nonHiddenSheetIndex;
            }
        } else {
            sheet = sheetName == null ? workbook.getSheetAt(requestedIndex) : workbook.getSheet(sheetName);
        }
        return sheet;
    }

    private void loadColumnTitles(Sheet sheet, int maxPhysicalNumberOfRows) {
        if (maxPhysicalNumberOfRows > 0) {
            int row = this.options.getHeaderStart();
            Row firstRow = sheet.getRow(row);
            for (Cell cell : firstRow) {
                this.titles.put(cell.getStringCellValue(), cell.getColumnIndex());
            }
        }
    }

    private <T> T deserialize0(Row currentRow, Class<T> type) {
        T instance = ReflectUtil.newInstanceOf(type);
        return this.setFieldValue(currentRow, type, instance);
    }

    private <T> T tailSetFieldValue(Row currentRow, Class<? super T> type, T instance) {
        for (Field field : type.getDeclaredFields()) {
            ExcelCellRange excelCellRange;
            ExcelRow excelRow = field.getAnnotation(ExcelRow.class);
            if (excelRow != null) {
                Object o = this.casting.castValue(field.getType(), String.valueOf(currentRow.getRowNum()), currentRow.getRowNum(), -1, this.options);
                this.setFieldData(instance, field, o);
            }
            if ((excelCellRange = field.getAnnotation(ExcelCellRange.class)) != null) {
                Class<?> o = field.getType();
                Object ins = ReflectUtil.newInstanceOf(o);
                for (Field f : o.getDeclaredFields()) {
                    this.tailSetFieldValue(currentRow, ins, f);
                }
                this.setFieldData(instance, field, ins);
                continue;
            }
            this.tailSetFieldValue(currentRow, instance, field);
        }
        return instance;
    }

    private <T> void tailSetFieldValue(Row currentRow, T instance, Field field) {
        ExcelCell index = field.getAnnotation(ExcelCell.class);
        if (index != null) {
            this.constructTypeValue(currentRow, instance, field, index.value());
        } else {
            Integer titleColumn;
            ExcelCellName excelCellName = field.getAnnotation(ExcelCellName.class);
            if (excelCellName != null && (titleColumn = this.titles.get(excelCellName.value())) != null) {
                this.constructTypeValue(currentRow, instance, field, titleColumn);
            }
        }
    }

    private <T> void constructTypeValue(Row currentRow, T instance, Field field, int column) {
        Class<?> fieldType = field.getType();
        Cell cell = currentRow.getCell(column);
        if (cell != null) {
            String value = this.dataFormatter.formatCellValue(cell);
            Object o = this.casting.castValue(fieldType, value, currentRow.getRowNum(), column, this.options);
            this.setFieldData(instance, field, o);
        }
    }

    private <T> void setFieldData(T instance, Field field, Object o) {
        try {
            field.setAccessible(true);
            field.set(instance, o);
        }
        catch (IllegalAccessException e) {
            throw new IllegalCastException("Unexpected cast type {" + o + "} of field" + field.getName());
        }
    }

    private <T> T setFieldValue(Row currentRow, Class<? super T> subclass, T instance) {
        return subclass == null ? instance : this.tailSetFieldValue(currentRow, subclass, this.setFieldValue(currentRow, subclass.getSuperclass(), instance));
    }

    private boolean skip(Row currentRow, int skip) {
        return currentRow.getRowNum() + 1 <= skip;
    }

    private boolean isRowEmpty(Row row) {
        for (int c = row.getFirstCellNum(); c < row.getLastCellNum(); ++c) {
            Cell cell = row.getCell(c, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            if (cell == null || cell.getCellType() == CellType.BLANK) continue;
            return false;
        }
        return true;
    }

    protected abstract Workbook workbook();
}

