/*
 * Decompiled with CFR 0.152.
 */
package com.poiji.bind.mapping;

import com.poiji.bind.mapping.PoijiLogCellFormat;
import com.poiji.option.PoijiOptions;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.Styles;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Attributes2Impl;

class XSSFSheetXMLPoijiHandler
extends XSSFSheetXMLHandler {
    private final Styles stylesTable;
    private final PoijiOptions poijiOptions;
    private final PoijiLogCellFormat cellFormat;

    XSSFSheetXMLPoijiHandler(Styles styles, Comments comments, SharedStrings strings, XSSFSheetXMLHandler.SheetContentsHandler sheetContentsHandler, DataFormatter dataFormatter, boolean formulasNotResults, PoijiOptions poijiOptions) {
        super(styles, comments, strings, sheetContentsHandler, dataFormatter, formulasNotResults);
        this.stylesTable = styles;
        this.poijiOptions = poijiOptions;
        this.cellFormat = this.poijiOptions.getPoijiCellFormat();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Attributes2Impl attributes2 = new Attributes2Impl(attributes);
        if (!("oddHeader".equals(localName) || "evenHeader".equals(localName) || "firstHeader".equals(localName) || "firstFooter".equals(localName) || "oddFooter".equals(localName) || "evenFooter".equals(localName) || !"c".equals(localName))) {
            String cellType = attributes.getValue("t");
            String cellStyleStr = attributes.getValue("s");
            if (!("b".equals(cellType) || "e".equals(cellType) || "inlineStr".equals(cellType) || "s".equals(cellType) || "str".equals(cellType) || cellStyleStr == null)) {
                int styleIndex = Integer.parseInt(cellStyleStr);
                if (this.poijiOptions.isDisableXLSXNumberCellFormat()) {
                    attributes2.removeAttribute(styleIndex);
                }
            }
        }
        super.startElement(uri, localName, qName, (Attributes)attributes2);
        if (this.cellFormat == null) {
            return;
        }
        if (uri != null && !uri.equals("http://schemas.openxmlformats.org/spreadsheetml/2006/main")) {
            return;
        }
        if ("c".equals(localName)) {
            String cellRef = attributes.getValue("r");
            String cellType = attributes.getValue("t");
            String cellStyleStr = attributes.getValue("s");
            CellAddress cellAddress = new CellAddress(cellRef);
            if ("b".equals(cellType) || "e".equals(cellType) || "inlineStr".equals(cellType)) {
                this.cellFormat.addFormat(cellAddress, (short)0, null, cellType, cellStyleStr);
                return;
            }
            if ("s".equals(cellType) || "str".equals(cellType)) {
                this.cellFormat.addFormat(cellAddress, (short)0, null, cellType, cellStyleStr);
                return;
            }
            XSSFCellStyle style = null;
            if (this.stylesTable != null) {
                if (cellStyleStr != null) {
                    int styleIndex = Integer.parseInt(cellStyleStr);
                    style = this.stylesTable.getStyleAt(styleIndex);
                } else if (this.stylesTable.getNumCellStyles() > 0) {
                    style = this.stylesTable.getStyleAt(0);
                }
            }
            if (style != null) {
                short formatIndex = style.getDataFormat();
                String formatString = style.getDataFormatString();
                if (formatString == null) {
                    formatString = BuiltinFormats.getBuiltinFormat((int)formatIndex);
                }
                this.cellFormat.addFormat(cellAddress, formatIndex, formatString, cellType, cellStyleStr);
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
    }
}

