/*
 * Decompiled with CFR 0.152.
 */
package com.poiji.option;

import com.poiji.bind.mapping.PoijiLogCellFormat;
import com.poiji.bind.mapping.PoijiNumberFormat;
import com.poiji.config.Casting;
import com.poiji.config.DefaultCasting;
import com.poiji.exception.PoijiException;
import com.poiji.util.PoijiConstants;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public final class PoijiOptions {
    private int skip;
    private int limit;
    private int sheetIndex;
    private String password;
    private String dateRegex;
    private String dateTimeRegex;
    private String datePattern;
    private boolean dateLenient;
    private boolean trimCellValue;
    private boolean ignoreHiddenSheets;
    private boolean preferNullOverDefault;
    private DateTimeFormatter dateFormatter;
    private DateTimeFormatter dateTimeFormatter;
    private Casting casting;
    private int headerStart;
    private String sheetName;
    private boolean caseInsensitive;
    private PoijiLogCellFormat poijiLogCellFormat;
    private PoijiNumberFormat numberFormat;
    private boolean namedHeaderMandatory;
    private boolean disableXLSXNumberCellFormat;

    public PoijiNumberFormat getPoijiNumberFormat() {
        return this.numberFormat;
    }

    private PoijiOptions setPoijiNumberFormat(PoijiNumberFormat numberFormat) {
        this.numberFormat = numberFormat;
        return this;
    }

    public PoijiLogCellFormat getPoijiCellFormat() {
        return this.poijiLogCellFormat;
    }

    private PoijiOptions setPoijiLogCellFormat(PoijiLogCellFormat poijiLogCellFormat) {
        this.poijiLogCellFormat = poijiLogCellFormat;
        return this;
    }

    private PoijiOptions() {
    }

    private PoijiOptions setSkip(int skip) {
        this.skip = skip;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public PoijiOptions setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    private PoijiOptions setDatePattern(String datePattern) {
        this.datePattern = datePattern;
        return this;
    }

    private PoijiOptions setDateFormatter(DateTimeFormatter dateFormatter) {
        this.dateFormatter = dateFormatter;
        return this;
    }

    private PoijiOptions setDateTimeFormatter(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
        return this;
    }

    private PoijiOptions setPreferNullOverDefault(boolean preferNullOverDefault) {
        this.preferNullOverDefault = preferNullOverDefault;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    private PoijiOptions setPassword(String password) {
        this.password = password;
        return this;
    }

    public String datePattern() {
        return this.datePattern;
    }

    public DateTimeFormatter dateFormatter() {
        return this.dateFormatter;
    }

    public DateTimeFormatter dateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    public boolean preferNullOverDefault() {
        return this.preferNullOverDefault;
    }

    public int skip() {
        return this.skip;
    }

    public boolean ignoreHiddenSheets() {
        return this.ignoreHiddenSheets;
    }

    private PoijiOptions setIgnoreHiddenSheets(boolean ignoreHiddenSheets) {
        this.ignoreHiddenSheets = ignoreHiddenSheets;
        return this;
    }

    public boolean trimCellValue() {
        return this.trimCellValue;
    }

    public PoijiOptions setTrimCellValue(boolean trimCellValue) {
        this.trimCellValue = trimCellValue;
        return this;
    }

    public Casting getCasting() {
        return this.casting;
    }

    public PoijiOptions setCasting(Casting casting) {
        this.casting = casting;
        return this;
    }

    private PoijiOptions setSheetIndex(int sheetIndex) {
        this.sheetIndex = sheetIndex;
        return this;
    }

    public int sheetIndex() {
        return this.sheetIndex;
    }

    public String getDateRegex() {
        return this.dateRegex;
    }

    private PoijiOptions setDateRegex(String dateRegex) {
        this.dateRegex = dateRegex;
        return this;
    }

    public String getDateTimeRegex() {
        return this.dateTimeRegex;
    }

    private PoijiOptions setDateTimeRegex(String dateTimeRegex) {
        this.dateTimeRegex = dateTimeRegex;
        return this;
    }

    public boolean getDateLenient() {
        return this.dateLenient;
    }

    private PoijiOptions setDateLenient(boolean dateLenient) {
        this.dateLenient = dateLenient;
        return this;
    }

    public int getHeaderStart() {
        return this.headerStart;
    }

    private PoijiOptions setHeaderStart(int headerStart) {
        this.headerStart = headerStart;
        return this;
    }

    private PoijiOptions setSheetName(String sheetName) {
        this.sheetName = sheetName;
        return this;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public boolean getCaseInsensitive() {
        return this.caseInsensitive;
    }

    private PoijiOptions setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
        return this;
    }

    public boolean getNamedHeaderMandatory() {
        return this.namedHeaderMandatory;
    }

    private PoijiOptions setNamedHeaderMandatory(boolean namedHeaderMandatory) {
        this.namedHeaderMandatory = namedHeaderMandatory;
        return this;
    }

    private PoijiOptions disableXLSXNumberCellFormat(boolean disableXLSXNumberCellFormat) {
        this.disableXLSXNumberCellFormat = disableXLSXNumberCellFormat;
        return this;
    }

    public boolean isDisableXLSXNumberCellFormat() {
        return this.disableXLSXNumberCellFormat;
    }

    public static class PoijiOptionsBuilder {
        private int sheetIndex;
        private String password;
        private String dateRegex;
        private String dateTimeRegex;
        private boolean dateLenient;
        private boolean trimCellValue;
        private boolean ignoreHiddenSheets;
        private boolean preferNullOverDefault;
        private String datePattern = "dd/M/yyyy";
        private DateTimeFormatter dateFormatter = PoijiConstants.DEFAULT_DATE_FORMATTER;
        private DateTimeFormatter dateTimeFormatter = PoijiConstants.DEFAULT_DATE_TIME_FORMATTER;
        private Casting casting = new DefaultCasting();
        private PoijiLogCellFormat cellFormat;
        private PoijiNumberFormat numberFormat;
        private int headerStart = 0;
        private int skip = 1;
        private int limit = 0;
        private String sheetName;
        private boolean caseInsensitive;
        private boolean namedHeaderMandatory;
        private boolean disabledXLSXNumberCellFormat;

        private PoijiOptionsBuilder() {
        }

        private PoijiOptionsBuilder(int skip) {
            this.skip = skip;
        }

        public static PoijiOptionsBuilder settings(int skip) {
            if (skip <= 0) {
                throw new PoijiException("Poiji already skips the header. Skip index must be greater than 1");
            }
            return new PoijiOptionsBuilder(skip + 1);
        }

        public static PoijiOptionsBuilder settings() {
            return new PoijiOptionsBuilder();
        }

        public PoijiOptionsBuilder dateFormatter(DateTimeFormatter dateFormatter) {
            this.dateFormatter = dateFormatter;
            return this;
        }

        public PoijiOptionsBuilder dateTimeFormatter(DateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = dateTimeFormatter;
            return this;
        }

        public PoijiOptionsBuilder datePattern(String datePattern) {
            this.datePattern = datePattern;
            return this;
        }

        public PoijiOptionsBuilder preferNullOverDefault(boolean preferNullOverDefault) {
            this.preferNullOverDefault = preferNullOverDefault;
            return this;
        }

        public PoijiOptions build() {
            return new PoijiOptions().setSkip(this.skip + this.headerStart).setPassword(this.password).setPreferNullOverDefault(this.preferNullOverDefault).setDatePattern(this.datePattern).setDateFormatter(this.dateFormatter).setDateTimeFormatter(this.dateTimeFormatter).setSheetIndex(this.sheetIndex).setSheetName(this.sheetName).setIgnoreHiddenSheets(this.ignoreHiddenSheets).setTrimCellValue(this.trimCellValue).setDateRegex(this.dateRegex).setDateTimeRegex(this.dateTimeRegex).setDateLenient(this.dateLenient).setHeaderStart(this.headerStart).setCasting(this.casting).setLimit(this.limit).setPoijiLogCellFormat(this.cellFormat).setPoijiNumberFormat(this.numberFormat).setCaseInsensitive(this.caseInsensitive).setNamedHeaderMandatory(this.namedHeaderMandatory).disableXLSXNumberCellFormat(this.disabledXLSXNumberCellFormat);
        }

        public PoijiOptionsBuilder sheetIndex(int sheetIndex) {
            if (sheetIndex < 0) {
                throw new PoijiException("Sheet index must be greater than or equal to 0");
            }
            this.sheetIndex = sheetIndex;
            return this;
        }

        public PoijiOptionsBuilder sheetName(String sheetName) {
            this.sheetName = sheetName;
            return this;
        }

        public PoijiOptionsBuilder skip(int skip) {
            if (skip <= 0) {
                throw new PoijiException("Poiji already skips the header. Skip index must be greater than 1");
            }
            this.skip = skip + 1;
            return this;
        }

        public PoijiOptionsBuilder limit(int limit) {
            if (limit < 1) {
                throw new PoijiException("limit must be greater than 0");
            }
            this.limit = limit;
            return this;
        }

        public PoijiOptionsBuilder password(String password) {
            this.password = password;
            return this;
        }

        public PoijiOptionsBuilder ignoreHiddenSheets(boolean ignoreHiddenSheets) {
            this.ignoreHiddenSheets = ignoreHiddenSheets;
            return this;
        }

        public PoijiOptionsBuilder trimCellValue(boolean trimCellValue) {
            this.trimCellValue = trimCellValue;
            return this;
        }

        public PoijiOptionsBuilder dateRegex(String dateRegex) {
            this.dateRegex = dateRegex;
            return this;
        }

        public PoijiOptionsBuilder dateTimeRegex(String dateTimeRegex) {
            this.dateTimeRegex = dateTimeRegex;
            return this;
        }

        public PoijiOptionsBuilder dateLenient(boolean dateLenient) {
            this.dateLenient = dateLenient;
            return this;
        }

        public PoijiOptionsBuilder withCasting(Casting casting) {
            Objects.requireNonNull(casting);
            this.casting = casting;
            return this;
        }

        public PoijiOptionsBuilder headerStart(int headerStart) {
            if (headerStart < -1) {
                throw new PoijiException("Header index must be greater than -1");
            }
            this.headerStart = headerStart;
            return this;
        }

        public PoijiOptionsBuilder caseInsensitive(boolean caseInsensitive) {
            this.caseInsensitive = caseInsensitive;
            return this;
        }

        public PoijiOptionsBuilder poijiLogCellFormat(PoijiLogCellFormat cellFormat) {
            this.cellFormat = cellFormat;
            return this;
        }

        public PoijiOptionsBuilder poijiNumberFormat(PoijiNumberFormat numberFormat) {
            this.numberFormat = numberFormat;
            return this;
        }

        public PoijiOptionsBuilder namedHeaderMandatory(boolean namedHeaderMandatory) {
            this.namedHeaderMandatory = namedHeaderMandatory;
            return this;
        }

        public PoijiOptionsBuilder disableXLSXNumberCellFormat() {
            this.disabledXLSXNumberCellFormat = true;
            return this;
        }
    }
}

