/*
 * Decompiled with CFR 0.152.
 */
package com.poiji.bind.mapping;

import com.poiji.annotation.DisableCellFormatXLS;
import com.poiji.annotation.ExcelCell;
import com.poiji.annotation.ExcelCellName;
import com.poiji.annotation.ExcelCellRange;
import com.poiji.annotation.ExcelRow;
import com.poiji.annotation.ExcelUnknownCells;
import com.poiji.bind.Unmarshaller;
import com.poiji.bind.mapping.PoijiWorkBook;
import com.poiji.config.Casting;
import com.poiji.config.Formatting;
import com.poiji.exception.IllegalCastException;
import com.poiji.exception.PoijiException;
import com.poiji.option.PoijiOptions;
import com.poiji.util.AnnotationUtil;
import com.poiji.util.ReflectUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.BaseFormulaEvaluator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

abstract class HSSFUnmarshaller
extends PoijiWorkBook
implements Unmarshaller {
    private final DataFormatter dataFormatter;
    protected final PoijiOptions options;
    private final Casting casting;
    private final Formatting formatting;
    private final Map<String, Integer> titleToIndex;
    private final Map<Integer, String> indexToTitle;
    private final int limit;
    private int internalCount;
    BaseFormulaEvaluator baseFormulaEvaluator;

    HSSFUnmarshaller(PoijiOptions options) {
        this.options = options;
        this.limit = options.getLimit();
        this.dataFormatter = new DataFormatter();
        this.titleToIndex = new HashMap<String, Integer>();
        this.indexToTitle = new HashMap<Integer, String>();
        this.casting = options.getCasting();
        this.formatting = options.getFormatting();
    }

    @Override
    public <T> void unmarshal(Class<T> type, Consumer<? super T> consumer) {
        HSSFWorkbook workbook = (HSSFWorkbook)this.workbook();
        if (workbook == null) {
            throw new PoijiException("The workbook is null.");
        }
        Optional<String> maybeSheetName = this.getSheetName(type, this.options);
        this.baseFormulaEvaluator = HSSFFormulaEvaluator.create((HSSFWorkbook)workbook, null, null);
        Sheet sheet = this.getSheetToProcess((Workbook)workbook, this.options, maybeSheetName.orElse(null));
        this.processRowsToObjects(sheet, type, consumer);
    }

    <T> void processRowsToObjects(Sheet sheet, Class<T> type, Consumer<? super T> consumer) {
        int skip = this.options.skip();
        int maxPhysicalNumberOfRows = sheet.getPhysicalNumberOfRows() + 1 - skip;
        this.loadColumnTitles(sheet, maxPhysicalNumberOfRows);
        AnnotationUtil.validateMandatoryNameColumns(this.options, this.formatting, type, this.titleToIndex.keySet());
        for (Row currentRow : sheet) {
            if (this.skip(currentRow, skip) || this.isRowEmpty(currentRow)) continue;
            ++this.internalCount;
            if (this.limit != 0 && this.internalCount > this.limit) {
                return;
            }
            T instance = this.deserializeRowToInstance(currentRow, type);
            consumer.accept(instance);
        }
    }

    private Sheet getSheetToProcess(Workbook workbook, PoijiOptions options, String sheetName) {
        int nonHiddenSheetIndex = 0;
        int requestedIndex = options.sheetIndex();
        Sheet sheet = null;
        if (options.ignoreHiddenSheets()) {
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                if (workbook.isSheetHidden(i) || workbook.isSheetVeryHidden(i)) continue;
                if (sheetName == null ? nonHiddenSheetIndex == requestedIndex : workbook.getSheetName(i).equalsIgnoreCase(sheetName)) {
                    return workbook.getSheetAt(i);
                }
                ++nonHiddenSheetIndex;
            }
        } else {
            sheet = sheetName == null ? workbook.getSheetAt(requestedIndex) : workbook.getSheet(sheetName);
        }
        return sheet;
    }

    private void loadColumnTitles(Sheet sheet, int maxPhysicalNumberOfRows) {
        if (maxPhysicalNumberOfRows > 0) {
            int row = this.options.getHeaderStart();
            int headerCount = this.options.getHeaderCount();
            if (headerCount == 0) {
                return;
            }
            for (int i = 0; i < headerCount; i = (int)((short)(i + 1))) {
                Row firstRow = sheet.getRow(row + i);
                for (Cell cell : firstRow) {
                    int columnIndex = cell.getColumnIndex();
                    String titleName = this.formatting.transform(this.options, cell.getStringCellValue());
                    this.indexToTitle.put(columnIndex, this.getTitleNameForMap(titleName, columnIndex));
                    this.titleToIndex.put(titleName, columnIndex);
                }
            }
        }
    }

    private String getTitleNameForMap(String cellContent, int columnIndex) {
        if (this.indexToTitle.containsValue(cellContent) || cellContent.isEmpty()) {
            return cellContent + "@" + columnIndex;
        }
        return cellContent;
    }

    <T> T deserializeRowToInstance(Row currentRow, Class<T> type) {
        T instance = ReflectUtil.newInstanceOf(type);
        return this.setFieldValuesFromRowIntoInstance(currentRow, type, instance);
    }

    private <T> T tailSetFieldValue(Row currentRow, Class<? super T> type, T instance) {
        ArrayList<Integer> mappedColumnIndices = new ArrayList<Integer>();
        ArrayList<Field> unknownCells = new ArrayList<Field>();
        for (Field field2 : type.getDeclaredFields()) {
            if (field2.getAnnotation(ExcelRow.class) != null) {
                int rowNum = currentRow.getRowNum();
                Object data = this.casting.castValue(field2, String.valueOf(rowNum), rowNum, -1, this.options);
                this.setFieldData(instance, field2, data);
                continue;
            }
            if (field2.getAnnotation(ExcelCellRange.class) != null) {
                Class<?> fieldType = field2.getType();
                Object fieldInstance = ReflectUtil.newInstanceOf(fieldType);
                for (Field fieldField : fieldType.getDeclaredFields()) {
                    mappedColumnIndices.add(this.tailSetFieldValue(currentRow, fieldInstance, fieldField));
                }
                this.setFieldData(instance, field2, fieldInstance);
                continue;
            }
            if (field2.getAnnotation(ExcelUnknownCells.class) != null) {
                unknownCells.add(field2);
                continue;
            }
            mappedColumnIndices.add(this.tailSetFieldValue(currentRow, instance, field2));
        }
        Map<String, String> excelUnknownCellsMap = StreamSupport.stream(Spliterators.spliteratorUnknownSize(currentRow.cellIterator(), 16), false).filter(cell -> this.indexToTitle.size() != 0).filter(cell -> !mappedColumnIndices.contains(cell.getColumnIndex())).filter(cell -> !cell.toString().isEmpty()).collect(Collectors.toMap(cell -> this.indexToTitle.get(cell.getColumnIndex()), Object::toString));
        unknownCells.forEach(field -> this.setFieldData(instance, (Field)field, excelUnknownCellsMap));
        return instance;
    }

    private <T> Integer tailSetFieldValue(Row currentRow, T instance, Field field) {
        FieldAnnotationDetail annotationDetail = this.getFieldColumn(field);
        if (annotationDetail.getColumn() != null) {
            this.constructTypeValue(currentRow, instance, field, annotationDetail);
        }
        return annotationDetail.getColumn();
    }

    private FieldAnnotationDetail getFieldColumn(Field field) {
        ExcelCell index = field.getAnnotation(ExcelCell.class);
        DisableCellFormatXLS disableCellFormat = field.getAnnotation(DisableCellFormatXLS.class);
        FieldAnnotationDetail annotationDetail = new FieldAnnotationDetail();
        if (disableCellFormat != null) {
            annotationDetail.setDisabledCellFormat(disableCellFormat.value());
        }
        if (index != null) {
            annotationDetail.setColumn(index.value());
        } else {
            ExcelCellName excelCellName = field.getAnnotation(ExcelCellName.class);
            if (excelCellName != null) {
                String titleName = this.formatting.transform(this.options, excelCellName.value());
                Integer column = this.titleToIndex.get(titleName);
                annotationDetail.setColumn(column);
            }
        }
        return annotationDetail;
    }

    private <T> void constructTypeValue(Row currentRow, T instance, Field field, FieldAnnotationDetail annotationDetail) {
        Cell cell = currentRow.getCell(annotationDetail.getColumn().intValue());
        if (cell != null) {
            if (annotationDetail.isDisabledCellFormat()) {
                cell.setCellStyle(null);
            }
            String value = this.dataFormatter.formatCellValue(cell, (FormulaEvaluator)this.baseFormulaEvaluator);
            Object data = this.casting.castValue(field, value, currentRow.getRowNum(), annotationDetail.getColumn(), this.options);
            this.setFieldData(instance, field, data);
        }
    }

    private <T> void setFieldData(T instance, Field field, Object data) {
        try {
            field.setAccessible(true);
            field.set(instance, data);
        }
        catch (IllegalAccessException e) {
            throw new IllegalCastException("Unexpected cast type {" + data + "} of field" + field.getName());
        }
    }

    private <T> T setFieldValuesFromRowIntoInstance(Row currentRow, Class<? super T> subclass, T instance) {
        return subclass == null ? instance : this.tailSetFieldValue(currentRow, subclass, this.setFieldValuesFromRowIntoInstance(currentRow, subclass.getSuperclass(), instance));
    }

    boolean skip(Row currentRow, int skip) {
        return currentRow.getRowNum() + 1 <= skip;
    }

    boolean isRowEmpty(Row row) {
        for (int c = row.getFirstCellNum(); c < row.getLastCellNum(); ++c) {
            Cell cell = row.getCell(c, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            if (cell == null || cell.getCellType() == CellType.BLANK) continue;
            return false;
        }
        return true;
    }

    private static class FieldAnnotationDetail {
        private Integer column;
        private boolean disabledCellFormat;

        private FieldAnnotationDetail() {
        }

        Integer getColumn() {
            return this.column;
        }

        boolean isDisabledCellFormat() {
            return this.disabledCellFormat;
        }

        void setColumn(Integer column) {
            this.column = column;
        }

        void setDisabledCellFormat(boolean disabledCellFormat) {
            this.disabledCellFormat = disabledCellFormat;
        }
    }
}

