/*
 * Decompiled with CFR 0.152.
 */
package com.poiji.util;

import com.poiji.annotation.ExcelCellRange;
import com.poiji.exception.IllegalCastException;
import com.poiji.exception.PoijiInstantiationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;

public final class ReflectUtil {
    private ReflectUtil() {
    }

    public static <T> T newInstanceOf(Class<T> type) {
        T obj;
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            obj = constructor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new PoijiInstantiationException("Cannot create a new instance of " + type.getName(), ex);
        }
        return obj;
    }

    static <T, A extends Annotation> Collection<A> findRecursivePoijiAnnotations(Class<T> typeToInspect, Class<A> annotationType) {
        ArrayList<A> annotations = new ArrayList<A>();
        for (Field field : typeToInspect.getDeclaredFields()) {
            ExcelCellRange excelCellRange = field.getAnnotation(ExcelCellRange.class);
            if (excelCellRange != null) {
                annotations.addAll(ReflectUtil.findRecursivePoijiAnnotations(field.getType(), annotationType));
                continue;
            }
            A fieldAnnotation = field.getAnnotation(annotationType);
            if (fieldAnnotation == null) continue;
            annotations.add(fieldAnnotation);
        }
        return annotations;
    }

    public static void setFieldData(Field field, Object o, Object instance) {
        try {
            field.setAccessible(true);
            field.set(instance, o);
        }
        catch (IllegalAccessException e) {
            throw new IllegalCastException("Unexpected cast type {" + o + "} of field" + field.getName());
        }
    }
}

