/*
 * Decompiled with CFR 0.152.
 */
package com.poiji.config;

import com.poiji.config.Casting;
import com.poiji.config.DefaultCastingError;
import com.poiji.exception.PoijiException;
import com.poiji.option.PoijiOptions;
import com.poiji.parser.BooleanParser;
import com.poiji.parser.Parsers;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultCasting
implements Casting {
    private final boolean errorLoggingEnabled;
    private final List<DefaultCastingError> errors = new ArrayList<DefaultCastingError>();

    public DefaultCasting() {
        this(false);
    }

    public DefaultCasting(boolean errorLoggingEnabled) {
        this.errorLoggingEnabled = errorLoggingEnabled;
    }

    protected <T> T onError(String value, String sheetName, int row, int col, Exception exception, T defaultValue) {
        this.logError(value, defaultValue, sheetName, row, col, exception);
        return defaultValue;
    }

    private void logError(String value, Object defaultValue, String sheetName, int row, int col, Exception exception) {
        if (this.errorLoggingEnabled) {
            this.errors.add(new DefaultCastingError(value, defaultValue, sheetName, row, col, exception));
        }
    }

    protected Boolean primitiveBooleanValue(String value, String sheetName, int row, int col) {
        try {
            return Parsers.booleans().parse(value);
        }
        catch (BooleanParser.BooleanParseException bpe) {
            return this.onError(value, sheetName, row, col, bpe, false);
        }
    }

    protected Boolean booleanValue(String value, String sheetName, int row, int col, PoijiOptions options) {
        try {
            return Parsers.booleans().parse(value);
        }
        catch (BooleanParser.BooleanParseException bpe) {
            return this.onError(value, sheetName, row, col, bpe, options.preferNullOverDefault() ? null : Boolean.valueOf(false));
        }
    }

    protected int primitiveIntegerValue(String value, String sheetName, int row, int col) {
        try {
            return Parsers.integers().parse(value).intValue();
        }
        catch (NumberFormatException nfe) {
            return this.onError(value, sheetName, row, col, nfe, 0);
        }
    }

    protected Integer integerValue(String value, String sheetName, int row, int col, PoijiOptions options) {
        try {
            return Parsers.integers().parse(value).intValue();
        }
        catch (NumberFormatException nfe) {
            return this.onError(value, sheetName, row, col, nfe, options.preferNullOverDefault() ? null : Integer.valueOf(0));
        }
    }

    protected long primitiveLongValue(String value, String sheetName, int row, int col) {
        try {
            return Parsers.longs().parse(value).longValue();
        }
        catch (NumberFormatException nfe) {
            return this.onError(value, sheetName, row, col, nfe, 0L);
        }
    }

    protected Long longValue(String value, String sheetName, int row, int col, PoijiOptions options) {
        try {
            return Parsers.longs().parse(value).longValue();
        }
        catch (NumberFormatException nfe) {
            return this.onError(value, sheetName, row, col, nfe, options.preferNullOverDefault() ? null : Long.valueOf(0L));
        }
    }

    protected double primitiveDoubleValue(String value, String sheetName, int row, int col, PoijiOptions options) {
        try {
            return Parsers.numbers(options.getLocale()).parse(value).doubleValue();
        }
        catch (NumberFormatException nfe) {
            return this.onError(value, sheetName, row, col, nfe, 0.0);
        }
    }

    protected Double doubleValue(String value, String sheetName, int row, int col, PoijiOptions options) {
        try {
            return Parsers.numbers(options.getLocale()).parse(value).doubleValue();
        }
        catch (NumberFormatException nfe) {
            return this.onError(value, sheetName, row, col, nfe, options.preferNullOverDefault() ? null : Double.valueOf(0.0));
        }
    }

    protected float primitiveFloatValue(String value, String sheetName, int row, int col, PoijiOptions options) {
        try {
            return Parsers.numbers(options.getLocale()).parse(value).floatValue();
        }
        catch (NumberFormatException nfe) {
            return this.onError(value, sheetName, row, col, nfe, Float.valueOf(0.0f)).floatValue();
        }
    }

    protected Float floatValue(String value, String sheetName, int row, int col, PoijiOptions options) {
        try {
            return Float.valueOf(Parsers.numbers(options.getLocale()).parse(value).floatValue());
        }
        catch (NumberFormatException nfe) {
            return this.onError(value, sheetName, row, col, nfe, options.preferNullOverDefault() ? null : Float.valueOf(0.0f));
        }
    }

    protected BigDecimal bigDecimalValue(String value, String sheetName, int row, int col, PoijiOptions options) {
        try {
            return Parsers.bigDecimals(options.getLocale()).parse(value);
        }
        catch (IllegalStateException | NumberFormatException e) {
            return this.onError(value, sheetName, row, col, e, options.preferNullOverDefault() ? null : BigDecimal.ZERO);
        }
    }

    protected Date dateValue(String value, String sheetName, int row, int col, PoijiOptions options) {
        if (options.getDateRegex() != null && !value.matches(options.getDateRegex())) {
            return options.preferNullOverDefault() ? null : Calendar.getInstance().getTime();
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(options.datePattern());
            sdf.setLenient(options.getDateLenient());
            return sdf.parse(value);
        }
        catch (ParseException e) {
            return this.onError(value, sheetName, row, col, e, options.preferNullOverDefault() ? null : Calendar.getInstance().getTime());
        }
    }

    protected LocalDate localDateValue(String value, String sheetName, int row, int col, PoijiOptions options) {
        if (options.getDateRegex() != null && !value.matches(options.getDateRegex())) {
            return options.preferNullOverDefault() ? null : LocalDate.now();
        }
        try {
            return LocalDate.parse(value, options.dateFormatter());
        }
        catch (DateTimeParseException e) {
            return this.onError(value, sheetName, row, col, e, options.preferNullOverDefault() ? null : LocalDate.now());
        }
    }

    protected LocalDateTime localDateTimeValue(String value, String sheetName, int row, int col, PoijiOptions options) {
        if (options.getDateTimeRegex() != null && !value.matches(options.getDateTimeRegex())) {
            return options.preferNullOverDefault() ? null : LocalDateTime.now();
        }
        try {
            return LocalDateTime.parse(value, options.dateTimeFormatter());
        }
        catch (DateTimeParseException e) {
            return this.onError(value, sheetName, row, col, e, options.preferNullOverDefault() ? null : LocalDateTime.now());
        }
    }

    protected LocalTime localTimeValue(String value, String sheetName, int row, int col, PoijiOptions options) {
        if (options.getTimeRegex() != null && !value.matches(options.getTimeRegex())) {
            return options.preferNullOverDefault() ? null : LocalTime.now();
        }
        try {
            return LocalTime.parse(value, options.timeFormatter());
        }
        catch (DateTimeParseException e) {
            return this.onError(value, sheetName, row, col, e, options.preferNullOverDefault() ? null : LocalTime.now());
        }
    }

    protected Object enumValue(String value, String sheetName, int row, int col, Class<?> type) {
        return Arrays.stream(type.getEnumConstants()).filter(o -> ((Enum)o).name().equals(value)).findFirst().orElseGet(() -> {
            IllegalArgumentException e = new IllegalArgumentException("No enumeration " + type.getSimpleName() + "." + value);
            return this.onError(value, sheetName, row, col, e, null);
        });
    }

    protected Object castListValue(String value, String sheetName, int row, int col, Field field, PoijiOptions options) {
        ParameterizedType genericType = (ParameterizedType)field.getGenericType();
        Type fieldType = genericType.getActualTypeArguments()[0];
        String[] valueList = value.split(options.getListDelimiter());
        Stream<String> valueStream = Stream.of(valueList).filter(Predicate.not(String::isEmpty));
        if (fieldType == Integer.class) {
            return valueStream.map(rv -> this.primitiveIntegerValue((String)rv, sheetName, row, col)).collect(Collectors.toList());
        }
        if (fieldType == BigDecimal.class) {
            return valueStream.map(rv -> this.bigDecimalValue((String)rv, sheetName, row, col, options)).collect(Collectors.toList());
        }
        if (fieldType == Long.class) {
            return valueStream.map(rv -> this.longValue((String)rv, sheetName, row, col, options)).collect(Collectors.toList());
        }
        if (fieldType == Double.class) {
            return valueStream.map(rv -> this.doubleValue((String)rv, sheetName, row, col, options)).collect(Collectors.toList());
        }
        if (fieldType == Boolean.class) {
            return valueStream.map(rv -> this.booleanValue((String)rv, sheetName, row, col, options)).collect(Collectors.toList());
        }
        if (fieldType == Float.class) {
            return valueStream.map(rv -> this.floatValue((String)rv, sheetName, row, col, options)).collect(Collectors.toList());
        }
        return valueStream.collect(Collectors.toList());
    }

    @Override
    public Object castValue(Field field, String rawValue, int row, int col, PoijiOptions options) {
        Class<?> fieldType = field.getType();
        return this.getValueObject(field, row, col, options, rawValue, fieldType);
    }

    protected Object getValueObject(Field field, int row, int col, PoijiOptions options, String rawValue, Class<?> fieldType) {
        String value;
        String sheetName = options.getSheetName();
        String string = value = options.trimCellValue() ? rawValue.trim() : rawValue;
        Object o = fieldType == Integer.TYPE ? Integer.valueOf(this.primitiveIntegerValue(value, sheetName, row, col)) : (fieldType == Integer.class ? this.integerValue(value, sheetName, row, col, options) : (fieldType == BigDecimal.class ? this.bigDecimalValue(value, sheetName, row, col, options) : (fieldType == Long.TYPE ? Long.valueOf(this.primitiveLongValue(value, sheetName, row, col)) : (fieldType == Long.class ? this.longValue(value, sheetName, row, col, options) : (fieldType == Double.TYPE ? Double.valueOf(this.primitiveDoubleValue(value, sheetName, row, col, options)) : (fieldType == Double.class ? this.doubleValue(value, sheetName, row, col, options) : (fieldType == Boolean.TYPE ? this.primitiveBooleanValue(value, sheetName, row, col) : (fieldType == Boolean.class ? this.booleanValue(value, sheetName, row, col, options) : (fieldType == Float.TYPE ? Float.valueOf(this.primitiveFloatValue(value, sheetName, row, col, options)) : (fieldType == Float.class ? this.floatValue(value, sheetName, row, col, options) : (fieldType == Date.class ? this.dateValue(value, sheetName, row, col, options) : (fieldType == LocalDate.class ? this.localDateValue(value, sheetName, row, col, options) : (fieldType == LocalDateTime.class ? this.localDateTimeValue(value, sheetName, row, col, options) : (fieldType == LocalTime.class ? this.localTimeValue(value, sheetName, row, col, options) : (fieldType.isEnum() ? this.enumValue(value, sheetName, row, col, fieldType) : (fieldType == List.class ? this.castListValue(value, sheetName, row, col, field, options) : (value.isEmpty() ? (options.preferNullOverDefault() ? null : value) : value)))))))))))))))));
        return o;
    }

    public boolean isErrorLoggingEnabled() {
        return this.errorLoggingEnabled;
    }

    public List<DefaultCastingError> getErrors() {
        if (this.errorLoggingEnabled) {
            return Collections.unmodifiableList(this.errors);
        }
        throw new PoijiException("logging not enabled");
    }
}

