/*
 * Decompiled with CFR 0.152.
 */
package com.poiji.util;

import com.poiji.annotation.ExcelCellRange;
import com.poiji.exception.IllegalCastException;
import com.poiji.exception.PoijiInstantiationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections4.MultiValuedMap;

public final class ReflectUtil {
    private ReflectUtil() {
    }

    public static <T> T newInstanceOf(Class<T> type) {
        T obj;
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
            if (!constructor.canAccess(null)) {
                constructor.setAccessible(true);
            }
            obj = constructor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new PoijiInstantiationException("Cannot create a new instance of " + type.getName(), ex);
        }
        return obj;
    }

    public static <T> T newRecordInstance(Class<T> type, Map<String, Object> recordValues) {
        if (!ReflectUtil.isRecord(type)) {
            throw new PoijiInstantiationException("Type " + type.getName() + " is not a record", new IllegalArgumentException("Expected a record type"));
        }
        try {
            Method getRecordComponentsMethod = Class.class.getMethod("getRecordComponents", new Class[0]);
            Object[] components = (Object[])getRecordComponentsMethod.invoke(type, new Object[0]);
            Class[] parameterTypes = new Class[components.length];
            Object[] args = new Object[components.length];
            Class<?> recordComponentClass = Class.forName("java.lang.reflect.RecordComponent");
            Method getNameMethod = recordComponentClass.getMethod("getName", new Class[0]);
            Method getTypeMethod = recordComponentClass.getMethod("getType", new Class[0]);
            for (int i = 0; i < components.length; ++i) {
                Class componentType;
                Object component = components[i];
                String componentName = (String)getNameMethod.invoke(component, new Object[0]);
                parameterTypes[i] = componentType = (Class)getTypeMethod.invoke(component, new Object[0]);
                Object value = recordValues.get(componentName);
                if (value == null) {
                    if (componentType.isPrimitive()) {
                        value = ReflectUtil.getDefaultValue(componentType);
                    } else if (componentType.getName().contains("MultiValuedMap")) {
                        value = Class.forName("org.apache.commons.collections4.multimap.ArrayListValuedHashMap").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                }
                args[i] = value;
            }
            Constructor<T> constructor = type.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor.newInstance(args);
        }
        catch (Exception ex) {
            throw new PoijiInstantiationException("Cannot create a new instance of record " + type.getName(), ex);
        }
    }

    private static Object getDefaultValue(Class<?> type) {
        if (type == Boolean.TYPE) {
            return false;
        }
        if (type == Byte.TYPE) {
            return (byte)0;
        }
        if (type == Short.TYPE) {
            return (short)0;
        }
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        if (type == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        return null;
    }

    public static boolean isRecord(Class<?> type) {
        try {
            Method isRecordMethod = Class.class.getMethod("isRecord", new Class[0]);
            return (Boolean)isRecordMethod.invoke(type, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return false;
        }
    }

    static <T, A extends Annotation> Collection<A> findRecursivePoijiAnnotations(Class<T> typeToInspect, Class<A> annotationType) {
        ArrayList<A> annotations = new ArrayList<A>();
        for (Field field : typeToInspect.getDeclaredFields()) {
            ExcelCellRange excelCellRange = field.getAnnotation(ExcelCellRange.class);
            if (excelCellRange != null) {
                annotations.addAll(ReflectUtil.findRecursivePoijiAnnotations(field.getType(), annotationType));
                continue;
            }
            A fieldAnnotation = field.getAnnotation(annotationType);
            if (fieldAnnotation == null) continue;
            annotations.add(fieldAnnotation);
        }
        return annotations;
    }

    public static void setFieldData(Field field, Object o, Object instance) {
        try {
            field.setAccessible(true);
            field.set(instance, o);
        }
        catch (IllegalAccessException e) {
            throw new IllegalCastException("Unexpected cast type {" + String.valueOf(o) + "} of field" + field.getName());
        }
    }

    public static void putFieldMultiValueMapData(Field field, String columnName, Object o, Object instance) {
        try {
            field.setAccessible(true);
            MultiValuedMap multiValuedMap = (MultiValuedMap)field.get(instance);
            multiValuedMap.put((Object)columnName, o);
        }
        catch (IllegalAccessError | IllegalAccessException e) {
            throw new IllegalCastException("Unexpected cast type {" + String.valueOf(o) + "} of field" + field.getName());
        }
    }
}

