/*
 * Decompiled with CFR 0.152.
 */
package com.github.ozsie;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001a\u0010\u0002\u001a\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"EXPORTED_FILE_LOCATION", "", "resolveConfig", "project", "Lorg/apache/maven/project/MavenProject;", "config", "getLocalFile", "getRemoteFile", "urlString", "resolveSingle", "detekt-maven-plugin"})
public final class ResolveConfigKt {
    @NotNull
    public static final String EXPORTED_FILE_LOCATION = "/remote-detekt-config.yml";

    @NotNull
    public static final String resolveConfig(@Nullable MavenProject project, @NotNull String config) {
        String string;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (project == null) {
            return config;
        }
        boolean bl = StringsKt.startsWith$default((String)config, (String)"http", (boolean)false, (int)2, null);
        if (bl) {
            string = ResolveConfigKt.getRemoteFile(project, config);
        } else if (!bl) {
            string = ResolveConfigKt.getLocalFile(project, config);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private static final String getLocalFile(MavenProject project, String config) {
        char[] cArray = new char[]{',', ';'};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)config, (char[])cArray, (boolean)false, (int)0, (int)6, null), (CharSequence)";", null, null, (int)0, null, arg_0 -> ResolveConfigKt.getLocalFile$lambda$0(project, arg_0), (int)30, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getRemoteFile(MavenProject project, String urlString) {
        URL url = new URL(urlString);
        String fileAbsolutePath = project.getBasedir().getAbsolutePath() + EXPORTED_FILE_LOCATION;
        Closeable closeable = url.openStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            long l = Files.copy(it, Paths.get(fileAbsolutePath, new String[0]), copyOptionArray);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return fileAbsolutePath;
    }

    private static final String resolveSingle(MavenProject project, String config) {
        String confLocation = null;
        File provided = new File(config).getAbsoluteFile();
        if (!provided.exists()) {
            String string;
            File projectLocal = new File(project.getBasedir(), config);
            if (projectLocal.exists()) {
                string = projectLocal.getAbsolutePath();
            } else {
                File parent = new File(project.getBasedir().getParentFile(), config);
                if (parent.exists()) {
                    string = parent.getAbsolutePath();
                } else {
                    throw new FileNotFoundException("Cannot find the config " + provided.getAbsolutePath() + " or " + parent.getAbsolutePath());
                }
            }
            confLocation = string;
        } else {
            confLocation = provided.getAbsolutePath();
        }
        return confLocation;
    }

    private static final CharSequence getLocalFile$lambda$0(MavenProject $project, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ResolveConfigKt.resolveSingle($project, it);
    }
}

