/*
 * Decompiled with CFR 0.152.
 */
package com.github.packageurl;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.util.TreeMap;

public final class PackageURLBuilder {
    private String type = null;
    private String namespace = null;
    private String name = null;
    private String version = null;
    private String subpath = null;
    private TreeMap<String, String> qualifiers = null;

    private PackageURLBuilder() {
    }

    public static PackageURLBuilder aPackageURL() {
        return new PackageURLBuilder();
    }

    public PackageURLBuilder withType(String type) {
        this.type = type;
        return this;
    }

    public PackageURLBuilder withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public PackageURLBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public PackageURLBuilder withVersion(String version) {
        this.version = version;
        return this;
    }

    public PackageURLBuilder withSubpath(String subpath) {
        this.subpath = subpath;
        return this;
    }

    public PackageURLBuilder withQualifier(String key, String value) {
        if (this.qualifiers == null) {
            this.qualifiers = new TreeMap();
        }
        this.qualifiers.put(key, value);
        return this;
    }

    public PackageURL build() throws MalformedPackageURLException {
        return new PackageURL(this.type, this.namespace, this.name, this.version, this.qualifiers, this.subpath);
    }
}

