/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.ObjectUtils;
import com.github.paganini2008.devtools.StringUtils;

public abstract class Assert {
    public static void hasNoLength(CharSequence text) {
        Assert.hasNoLength(text, "The string parameter must not be null or empty.", new Object[0]);
    }

    public static void hasNoLength(CharSequence text, String msg, Object ... args) {
        Assert.isTrue(StringUtils.isEmpty(text), msg, args);
    }

    public static void hasNoText(CharSequence text) {
        Assert.hasNoText(text, "The string parameter must not be null or no length.", new Object[0]);
    }

    public static void hasNoText(CharSequence text, String msg, Object ... args) {
        Assert.isTrue(StringUtils.isBlank(text), msg, args);
    }

    public static void isNull(Object arg) {
        Assert.isNull(arg, "The argument must not be null.", new Object[0]);
    }

    public static void isNull(Object arg, String msg, Object ... args) {
        Assert.isTrue(arg == null, msg, args);
    }

    public static void isNull(Object arg, RuntimeException e) {
        Assert.isTrue(arg == null, e);
    }

    public static void isNotArray(Object arg) {
        Assert.isNotArray(arg, arg != null ? "The argument type of '" + arg.getClass() + "' is not array." : "Null Object", new Object[0]);
    }

    public static void isNotArray(Object arg, String msg, Object ... args) {
        Assert.isTrue(ObjectUtils.isNotArray(arg), msg, args);
    }

    public static <T extends Comparable<T>> void lt(T a, T b, String msg, Object ... args) {
        Assert.isTrue(a != null && a.compareTo(b) < 0, msg, args);
    }

    public static <T extends Comparable<T>> void lte(T a, T b, String msg, Object ... args) {
        Assert.isTrue(a != null && a.compareTo(b) <= 0, msg, args);
    }

    public static <T extends Comparable<T>> void gt(T a, T b, String msg, Object ... args) {
        Assert.isTrue(a != null && a.compareTo(b) > 0, msg, args);
    }

    public static <T extends Comparable<T>> void gte(T a, T b, String msg, Object ... args) {
        Assert.isTrue(a != null && a.compareTo(b) >= 0, msg, args);
    }

    public static <T extends Comparable<T>> void ne(T a, T b, String msg, Object ... args) {
        Assert.isTrue(a != null && a.compareTo(b) != 0, msg, args);
    }

    public static <T extends Comparable<T>> void eq(T a, T b, String msg, Object ... args) {
        Assert.isTrue(a != null && a.compareTo(b) == 0, msg, args);
    }

    public static <T extends Comparable<T>> void range(T value, T minValue, T maxValue, String msg, Object ... args) {
        Assert.isTrue(value != null && value.compareTo(minValue) >= 0 && value.compareTo(maxValue) <= 0, msg, args);
    }

    public static <T extends Comparable<T>> void outOfRange(T value, T minValue, T maxValue, String msg, Object ... args) {
        Assert.isTrue(value != null && value.compareTo(minValue) < 0 && value.compareTo(maxValue) > 0, msg, args);
    }

    public static void isTrue(boolean result, String msg, Object ... args) {
        Assert.isTrue(result, new IllegalArgumentException(args != null && args.length > 0 ? String.format(msg, args) : msg));
    }

    public static void isFalse(boolean result, String msg, Object ... args) {
        Assert.isFalse(result, new IllegalArgumentException(args != null && args.length > 0 ? String.format(msg, args) : msg));
    }

    public static <T extends RuntimeException> void isTrue(boolean result, T e) {
        if (result) {
            throw e;
        }
    }

    public static <T extends RuntimeException> void isFalse(boolean result, T e) {
        if (!result) {
            throw e;
        }
    }

    public static <T extends Exception> void isTrue(boolean result, T e) throws T {
        if (result) {
            throw e;
        }
    }

    public static <T extends Exception> void isFalse(boolean result, T e) throws T {
        if (!result) {
            throw e;
        }
    }

    public static <T extends Error> void isTrue(boolean result, T e) throws T {
        if (result) {
            throw e;
        }
    }

    public static <T extends Error> void isFalse(boolean result, T e) throws T {
        if (!result) {
            throw e;
        }
    }
}

