/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.ArrayUtils;
import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.CaseFormat;
import com.github.paganini2008.devtools.StringUtils;
import java.util.function.Function;

public abstract class CaseFormats {
    public static final char UNDERSCORE_CHAR = '_';
    public static final char HYPHEN_CHAR = '-';
    public static final CaseFormat LOWER_HYPHEN = new LowerHyphenCase(ch -> Character.isUpperCase(ch.charValue()), '-');
    public static final CaseFormat UPPER_HYPHEN = new UpperHyphenCase(ch -> Character.isUpperCase(ch.charValue()), '-');
    public static final CaseFormat LOWER_UNDERSCORE = new LowerHyphenCase(ch -> Character.isUpperCase(ch.charValue()), '_');
    public static final CaseFormat UPPER_UNDERSCORE = new UpperHyphenCase(ch -> Character.isUpperCase(ch.charValue()), '_');
    public static final CaseFormat LOWER_CAMEL = new LowerCamelCase(ch -> ch.charValue() == '-' || ch.charValue() == '_');
    public static final CaseFormat UPPER_CAMEL = new UpperCamelCase(ch -> ch.charValue() == '-' || ch.charValue() == '_');

    public static boolean isWellFormatedStartWith(char firstChar) {
        return Character.isAlphabetic(firstChar) || firstChar == '-' || firstChar == '$';
    }

    public static boolean isWellFormatedNaming(CharSequence varName, String[] excludedKeywords) {
        if (StringUtils.isBlank(varName)) {
            return false;
        }
        if (!CaseFormats.isWellFormatedStartWith(varName.charAt(0))) {
            return false;
        }
        for (int i = 1; i < varName.length(); ++i) {
            char c = varName.charAt(i);
            if (Character.isAlphabetic(c) || Character.isDigit(c) || c == '_') continue;
            return false;
        }
        return !ArrayUtils.contains(excludedKeywords, varName.toString());
    }

    public static void main(String[] args) {
        System.out.println(CaseFormats.isWellFormatedNaming("COLUMN_NAME", null));
        System.out.println(UPPER_UNDERSCORE.toCase("columnName"));
    }

    public static class LowerCamelCase
    implements CaseFormat {
        private final Function<Character, Boolean> f;

        public LowerCamelCase(Function<Character, Boolean> f) {
            this.f = f;
        }

        @Override
        public String toCase(CharSequence str) {
            Assert.hasNoText(str);
            if (!CaseFormats.isWellFormatedNaming(str, null)) {
                throw new IllegalArgumentException("Bad Formated naming: " + str);
            }
            String copy = str.toString().toLowerCase();
            StringBuilder content = new StringBuilder();
            boolean upperCase = false;
            boolean changed = false;
            int l = copy.length();
            for (int i = 0; i < l; ++i) {
                char c = copy.charAt(i);
                if (this.f.apply(Character.valueOf(c)).booleanValue()) {
                    upperCase = true;
                    continue;
                }
                if (upperCase) {
                    c = Character.toUpperCase(c);
                    changed = true;
                    upperCase = false;
                }
                content.append(c);
            }
            if (!changed) {
                return str.toString();
            }
            char firstChar = content.charAt(0);
            if (!Character.isLowerCase(firstChar)) {
                content.setCharAt(0, Character.toLowerCase(firstChar));
            }
            return content.toString();
        }
    }

    public static class UpperCamelCase
    implements CaseFormat {
        private final Function<Character, Boolean> f;

        public UpperCamelCase(Function<Character, Boolean> f) {
            this.f = f;
        }

        @Override
        public String toCase(CharSequence str) {
            Assert.hasNoText(str);
            if (!CaseFormats.isWellFormatedNaming(str, null)) {
                throw new IllegalArgumentException("Bad Formated naming: " + str);
            }
            String copy = str.toString().toLowerCase();
            StringBuilder content = new StringBuilder();
            boolean upperCase = false;
            boolean changed = false;
            int l = copy.length();
            for (int i = 0; i < l; ++i) {
                char c = copy.charAt(i);
                if (this.f.apply(Character.valueOf(c)).booleanValue()) {
                    upperCase = true;
                    continue;
                }
                if (upperCase) {
                    c = Character.toUpperCase(c);
                    changed = true;
                    upperCase = false;
                }
                content.append(c);
            }
            if (!changed) {
                return str.toString();
            }
            char firstChar = content.charAt(0);
            if (!Character.isUpperCase(firstChar)) {
                content.setCharAt(0, Character.toUpperCase(firstChar));
            }
            return content.toString();
        }
    }

    public static class LowerHyphenCase
    implements CaseFormat {
        private final Function<Character, Boolean> f;
        private final char hyphen;

        public LowerHyphenCase(Function<Character, Boolean> f, char hyphen) {
            this.f = f;
            this.hyphen = hyphen;
        }

        @Override
        public String toCase(CharSequence str) {
            Assert.hasNoText(str);
            StringBuilder content = new StringBuilder();
            int l = str.length();
            for (int i = 0; i < l; ++i) {
                char c = str.charAt(i);
                if (this.f.apply(Character.valueOf(c)).booleanValue() && i != 0) {
                    content.append(this.hyphen);
                }
                content.append(Character.toLowerCase(c));
            }
            if (content.length() == 0) {
                content.append(str);
            }
            return content.toString();
        }
    }

    public static class UpperHyphenCase
    implements CaseFormat {
        private final Function<Character, Boolean> f;
        private final char hyphen;

        public UpperHyphenCase(Function<Character, Boolean> f, char hyphen) {
            this.f = f;
            this.hyphen = hyphen;
        }

        @Override
        public String toCase(CharSequence str) {
            Assert.hasNoText(str);
            StringBuilder content = new StringBuilder();
            int l = str.length();
            for (int i = 0; i < l; ++i) {
                char c = str.charAt(i);
                if (this.f.apply(Character.valueOf(c)).booleanValue() && i != 0) {
                    content.append(this.hyphen);
                }
                content.append(Character.toUpperCase(c));
            }
            if (content.length() == 0) {
                content.append(str);
            }
            return content.toString();
        }
    }
}

