/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.collection.LruMap;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public abstract class CharsetUtils {
    private static final LruMap<String, Charset> cache = new LruMap(16);
    public static final String ISO_8859_1_NAME = "ISO-8859-1";
    public static final Charset ISO_8859_1 = CharsetUtils.toCharset("ISO-8859-1");
    public static final String US_ASCII_NAME = "US-ASCII";
    public static final Charset US_ASCII = CharsetUtils.toCharset("US-ASCII");
    public static final String UTF_16_NAME = "UTF-16";
    public static final Charset UTF_16 = CharsetUtils.toCharset("UTF-16");
    public static final String UTF_16BE_NAME = "UTF-16BE";
    public static final Charset UTF_16BE = CharsetUtils.toCharset("UTF-16BE");
    public static final String UTF_16LE_NAME = "UTF-16LE";
    public static final Charset UTF_16LE = CharsetUtils.toCharset("UTF-16LE");
    public static final String UTF_8_NAME = "UTF-8";
    public static final Charset UTF_8 = CharsetUtils.toCharset("UTF-8");
    public static final String GBK_NAME = "GBK";
    public static final Charset GBK = CharsetUtils.toCharset("GBK");
    public static final String GB_2312_NAME = "GB2312";
    public static final Charset GB_2312 = CharsetUtils.toCharset("GB2312");
    public static final String BIG_5_NAME = "BIG_5";
    public static final Charset BIG_5 = CharsetUtils.toCharset("BIG_5");
    public static final Charset DEFAULT = Charset.defaultCharset();
    public static final byte[] BOM_UTF_8 = new byte[]{-17, -69, -65};
    public static final byte[] BOM_UTF_16LE = new byte[]{-1, -2};
    public static final byte[] BOM_UTF_16BE = new byte[]{-2, -1};

    public static Charset toCharset(Charset charset) {
        return CharsetUtils.toCharset(charset, DEFAULT);
    }

    public static Charset toCharset(Charset charset, Charset defaultCharset) {
        return charset == null ? defaultCharset : charset;
    }

    public static Charset toCharset(String charset) {
        return CharsetUtils.toCharset(charset, DEFAULT);
    }

    public static Charset toCharset(String charset, Charset defaultCharset) {
        if (StringUtils.isBlank(charset)) {
            return defaultCharset;
        }
        try {
            Charset instance = cache.get(charset);
            if (instance == null) {
                cache.put(charset, Charset.forName(charset));
                instance = cache.get(charset);
            }
            return instance;
        }
        catch (IllegalArgumentException e) {
            return defaultCharset;
        }
    }

    public static CharsetDecoder newDecoder(Charset charset) {
        CharsetDecoder decoder = charset.newDecoder();
        decoder.reset();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        return decoder;
    }

    public static CharsetEncoder newEncoder(Charset charset) {
        CharsetEncoder encoder = charset.newEncoder();
        encoder.reset();
        encoder.onMalformedInput(CodingErrorAction.REPLACE);
        encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        return encoder;
    }
}

