/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.JavaStringSource;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class CodeDebuger {
    private static final String classNamePrefix = "Temp_";
    private static final String classPath = CodeDebuger.class.getClassLoader().getResource("").getPath();
    private static final String executionWithReturn;
    private static final String executionWithVoid;

    private static Class<?> loadClass(String className, String pattern, String javaCode) throws IllegalStateException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);
        JavaStringSource file = new JavaStringSource(className, StringUtils.format(pattern, "$", className, javaCode));
        List<JavaFileObject> javaObjects = Arrays.asList(file);
        ArrayList<String> options = new ArrayList<String>();
        options.add("-d");
        options.add(classPath);
        options.add("-encoding");
        options.add("UTF-8");
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, null, options, null, javaObjects);
        boolean result = task.call();
        if (result) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new IllegalStateException("JavaCompiler error: \n" + diagnostics.getDiagnostics());
    }

    public static void execute(String javaCode) {
        String className = classNamePrefix + UUID.randomUUID().toString().replaceAll("-", "");
        Class<?> clazz = CodeDebuger.loadClass(className, executionWithVoid, javaCode);
        try {
            Method method = clazz.getMethod("getObject", new Class[0]);
            method.setAccessible(true);
            method.invoke(clazz.newInstance(), new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to execute target method.", e);
        }
        finally {
            File abondon = new File(classPath, className + ".class");
            if (abondon.exists()) {
                try {
                    FileUtils.deleteFile(abondon);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    public static Object executeAndReturn(String javaCode) {
        String className = classNamePrefix + UUID.randomUUID().toString().replaceAll("-", "");
        Class<?> clazz = CodeDebuger.loadClass(className, executionWithReturn, javaCode);
        try {
            Method method = clazz.getMethod("getObject", new Class[0]);
            method.setAccessible(true);
            Object object = method.invoke(clazz.newInstance(), new Object[0]);
            return object;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to execute target method.", e);
        }
        finally {
            File abondon = new File(classPath, className + ".class");
            if (abondon.exists()) {
                try {
                    FileUtils.deleteFile(abondon);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        CodeDebuger.execute("System.out.println(System.currentTimeMillis());");
    }

    static {
        System.out.println(classPath);
        StringBuilder javaSource = new StringBuilder();
        javaSource.append("public class $");
        javaSource.append("{");
        javaSource.append("    public Object getObject()");
        javaSource.append("    {");
        javaSource.append("        Object result = $;");
        javaSource.append("        return result;");
        javaSource.append("    }");
        javaSource.append("}");
        executionWithReturn = javaSource.toString();
        javaSource.delete(0, javaSource.length());
        javaSource = new StringBuilder();
        javaSource.append("public class $");
        javaSource.append("{");
        javaSource.append("    public Object getObject()");
        javaSource.append("    {");
        javaSource.append("        $;");
        javaSource.append("        return null;");
        javaSource.append("    }");
        javaSource.append("}");
        executionWithVoid = javaSource.toString();
    }
}

