/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.ArrayUtils;
import com.github.paganini2008.devtools.collection.CollectionUtils;
import java.util.Collection;

public abstract class Comparables {
    public static <T> T nullOrMax(T leftValue, T rightValue) {
        return leftValue == null ? rightValue : leftValue;
    }

    public static <T> T nullOrMin(T leftValue, T rightValue) {
        return leftValue == null ? leftValue : rightValue;
    }

    public static <T extends Comparable<T>> T getOrDefault(T left, T right) {
        return Comparables.getOrDefault(left, right, null);
    }

    public static <T extends Comparable<T>> T getOrDefault(T left, T right, T defaultValue) {
        if (Comparables.compareTo(left, right) == 0) {
            return defaultValue;
        }
        return left;
    }

    public static <T extends Comparable<T>> T minOrDefault(T left, T right, T defaultValue) {
        if (Comparables.compareTo(left, right) == 0) {
            return defaultValue;
        }
        return Comparables.min(left, defaultValue);
    }

    public static <T extends Comparable<T>> T maxOrDefault(T left, T right, T defaultValue) {
        if (Comparables.compareTo(left, right) == 0) {
            return defaultValue;
        }
        return Comparables.max(left, defaultValue);
    }

    public static <T extends Comparable<T>> T max(T[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return null;
        }
        T max = array[0];
        for (T t : array) {
            max = Comparables.max(max, t);
        }
        return max;
    }

    public static <T extends Comparable<T>> T min(T[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return null;
        }
        T min = array[0];
        for (T t : array) {
            min = Comparables.min(min, t);
        }
        return min;
    }

    public static <T extends Comparable<T>> T max(T a, T b) {
        return Comparables.compareTo(a, b) >= 0 ? a : b;
    }

    public static <T extends Comparable<T>> T min(T a, T b) {
        return Comparables.compareTo(a, b) <= 0 ? a : b;
    }

    public static <T extends Comparable<T>> boolean eqAny(T value, Collection<T> c) {
        if (CollectionUtils.isEmpty(c)) {
            return false;
        }
        for (Comparable t : c) {
            if (!Comparables.eq(value, t)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Comparable<T>> boolean eqAll(T value, Collection<T> c) {
        if (CollectionUtils.isEmpty(c)) {
            return false;
        }
        for (Comparable t : c) {
            if (!Comparables.ne(value, t)) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<T>> boolean ltAny(T value, Collection<T> c) {
        if (CollectionUtils.isEmpty(c)) {
            return false;
        }
        for (Comparable t : c) {
            if (!Comparables.lt(value, t)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Comparable<T>> boolean ltAll(T value, Collection<T> c) {
        if (CollectionUtils.isEmpty(c)) {
            return false;
        }
        for (Comparable t : c) {
            if (!Comparables.gte(value, t)) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<T>> boolean gtAny(T value, Collection<T> c) {
        if (CollectionUtils.isEmpty(c)) {
            return false;
        }
        for (Comparable t : c) {
            if (!Comparables.gt(value, t)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Comparable<T>> boolean gtAll(T value, Collection<T> c) {
        if (CollectionUtils.isEmpty(c)) {
            return false;
        }
        for (Comparable t : c) {
            if (!Comparables.lte(value, t)) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<T>> boolean lteAny(T value, Collection<T> c) {
        if (CollectionUtils.isEmpty(c)) {
            return false;
        }
        for (Comparable t : c) {
            if (!Comparables.lte(value, t)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Comparable<T>> boolean lteAll(T value, Collection<T> c) {
        if (CollectionUtils.isEmpty(c)) {
            return false;
        }
        for (Comparable t : c) {
            if (!Comparables.gt(value, t)) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<T>> boolean gteAny(T value, Collection<T> c) {
        if (CollectionUtils.isEmpty(c)) {
            return false;
        }
        for (Comparable t : c) {
            if (!Comparables.gte(value, t)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Comparable<T>> boolean gteAll(T value, Collection<T> c) {
        if (CollectionUtils.isEmpty(c)) {
            return false;
        }
        for (Comparable t : c) {
            if (!Comparables.lt(value, t)) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<T>> boolean between(T value, T minValue, T maxValue) {
        return Comparables.between(value, minValue, maxValue, false);
    }

    public static <T extends Comparable<T>> boolean between(T value, T minValue, T maxValue, boolean exclusive) {
        if (exclusive) {
            return Comparables.gt(value, minValue) && Comparables.lt(value, maxValue);
        }
        return Comparables.gte(value, minValue) && Comparables.lte(value, maxValue);
    }

    public static <T extends Comparable<T>> boolean ne(T left, T right) {
        return Comparables.compareTo(left, right) != 0;
    }

    public static <T extends Comparable<T>> boolean eq(T left, T right) {
        return Comparables.compareTo(left, right) == 0;
    }

    public static <T extends Comparable<T>> boolean gte(T left, T right) {
        return Comparables.compareTo(left, right) >= 0;
    }

    public static <T extends Comparable<T>> boolean gt(T left, T right) {
        return Comparables.compareTo(left, right) > 0;
    }

    public static <T extends Comparable<T>> boolean lte(T left, T right) {
        return Comparables.compareTo(left, right) <= 0;
    }

    public static <T extends Comparable<T>> boolean lt(T left, T right) {
        return Comparables.compareTo(left, right) < 0;
    }

    public static <T extends Comparable<T>> int compareTo(T left, T right) {
        if (left == null && right != null) {
            return -1;
        }
        if (left != null && right == null) {
            return 1;
        }
        if (left != null && right != null) {
            return Comparables.compareResult(left.compareTo(right));
        }
        return 0;
    }

    private static <T extends Comparable<T>> int compareResult(int result) {
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }
}

