/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.Comparables;
import com.github.paganini2008.devtools.FunctionalPredicate;
import com.github.paganini2008.devtools.MatchMode;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;

public class FunctionalPredicateImpl<T>
implements FunctionalPredicate<T> {
    protected Predicate<T> junction;

    public FunctionalPredicateImpl() {
        this(t -> true);
    }

    protected FunctionalPredicateImpl(Predicate<T> junction) {
        this.junction = junction;
    }

    @Override
    public <R extends Comparable<R>> FunctionalPredicate<T> nonNull(Function<T, R> supplier) {
        this.junction = this.junction.and(t -> supplier.apply(t) != null);
        return this;
    }

    @Override
    public <R extends Comparable<R>> FunctionalPredicate<T> isNull(Function<T, R> supplier) {
        this.junction = this.junction.and(t -> supplier.apply(t) == null);
        return this;
    }

    @Override
    public <R extends Comparable<R>> FunctionalPredicate<T> between(Function<T, R> supplier, R minValue, R maxValue, boolean exclusive) {
        this.junction = this.junction.and(t -> Comparables.between((Comparable)supplier.apply(t), minValue, maxValue, exclusive));
        return this;
    }

    @Override
    public <R extends Comparable<R>> FunctionalPredicate<T> eq(Function<T, R> supplier, R value) {
        this.junction = this.junction.and(t -> Comparables.eq((Comparable)supplier.apply(t), value));
        return this;
    }

    @Override
    public <R extends Comparable<R>> FunctionalPredicate<T> ne(Function<T, R> supplier, R value) {
        this.junction = this.junction.and(t -> Comparables.ne((Comparable)supplier.apply(t), value));
        return this;
    }

    @Override
    public <R extends Comparable<R>> FunctionalPredicate<T> lt(Function<T, R> supplier, R value) {
        this.junction = this.junction.and(t -> Comparables.lt((Comparable)supplier.apply(t), value));
        return this;
    }

    @Override
    public <R extends Comparable<R>> FunctionalPredicate<T> lte(Function<T, R> supplier, R value) {
        this.junction = this.junction.and(t -> Comparables.lte((Comparable)supplier.apply(t), value));
        return this;
    }

    @Override
    public <R extends Comparable<R>> FunctionalPredicate<T> gt(Function<T, R> supplier, R value) {
        this.junction = this.junction.and(t -> Comparables.gt((Comparable)supplier.apply(t), value));
        return this;
    }

    @Override
    public <R extends Comparable<R>> FunctionalPredicate<T> gte(Function<T, R> supplier, R value) {
        this.junction = this.junction.and(t -> Comparables.gte((Comparable)supplier.apply(t), value));
        return this;
    }

    @Override
    public <R extends Comparable<R>> FunctionalPredicate<T> eqAny(Function<T, R> supplier, Collection<R> values) {
        this.junction = this.junction.and(t -> Comparables.eqAny((Comparable)supplier.apply(t), values));
        return this;
    }

    @Override
    public <R extends Comparable<R>> FunctionalPredicate<T> eqAll(Function<T, R> supplier, Collection<R> values) {
        this.junction = this.junction.and(t -> Comparables.eqAll((Comparable)supplier.apply(t), values));
        return this;
    }

    @Override
    public <R extends Comparable<R>> FunctionalPredicate<T> ltAny(Function<T, R> supplier, Collection<R> values) {
        this.junction = this.junction.and(t -> Comparables.ltAny((Comparable)supplier.apply(t), values));
        return this;
    }

    @Override
    public <R extends Comparable<R>> FunctionalPredicate<T> ltAll(Function<T, R> supplier, Collection<R> values) {
        this.junction = this.junction.and(t -> Comparables.ltAll((Comparable)supplier.apply(t), values));
        return this;
    }

    @Override
    public <R extends Comparable<R>> FunctionalPredicate<T> lteAny(Function<T, R> supplier, Collection<R> values) {
        this.junction = this.junction.and(t -> Comparables.lteAny((Comparable)supplier.apply(t), values));
        return this;
    }

    @Override
    public <R extends Comparable<R>> FunctionalPredicate<T> lteAll(Function<T, R> supplier, Collection<R> values) {
        this.junction = this.junction.and(t -> Comparables.lteAll((Comparable)supplier.apply(t), values));
        return this;
    }

    @Override
    public <R extends Comparable<R>> FunctionalPredicate<T> gtAny(Function<T, R> supplier, Collection<R> values) {
        this.junction = this.junction.and(t -> Comparables.gtAny((Comparable)supplier.apply(t), values));
        return this;
    }

    @Override
    public <R extends Comparable<R>> FunctionalPredicate<T> gtAll(Function<T, R> supplier, Collection<R> values) {
        this.junction = this.junction.and(t -> Comparables.gtAll((Comparable)supplier.apply(t), values));
        return this;
    }

    @Override
    public <R extends Comparable<R>> FunctionalPredicate<T> gteAny(Function<T, R> supplier, Collection<R> values) {
        this.junction = this.junction.and(t -> Comparables.gteAny((Comparable)supplier.apply(t), values));
        return this;
    }

    @Override
    public <R extends Comparable<R>> FunctionalPredicate<T> gteAll(Function<T, R> supplier, Collection<R> values) {
        this.junction = this.junction.and(t -> Comparables.gteAll((Comparable)supplier.apply(t), values));
        return this;
    }

    @Override
    public FunctionalPredicate<T> matches(Function<T, String> supplier, String substr, MatchMode matchMode) {
        this.junction = this.junction.and(t -> matchMode.matches((String)supplier.apply(t), substr));
        return this;
    }

    @Override
    public boolean test(T t) {
        return this.junction.test(t);
    }
}

