/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.Observer;
import com.github.paganini2008.devtools.collection.MapUtils;
import java.util.ArrayDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.PriorityBlockingQueue;

public class Observable {
    public static final String DEFAULT_TOPIC = "default";
    private final ConcurrentMap<String, ObserverGroup> groups = new ConcurrentHashMap<String, ObserverGroup>();
    private final boolean repeated;

    protected Observable(boolean repeated) {
        this.repeated = repeated;
    }

    public void addObserver(Observer ob) {
        this.addObserver(DEFAULT_TOPIC, ob);
    }

    public void addObserver(String topic, Observer ob) {
        Assert.isNull(ob, "Observer must not be null.", new Object[0]);
        ObserverGroup obs = MapUtils.get(this.groups, topic, () -> new ObserverGroup(topic, this.repeated));
        obs.addObserver(ob);
    }

    public void deleteObservers(String topic) {
        ObserverGroup obs;
        if (this.groups.containsKey(topic) && (obs = (ObserverGroup)this.groups.remove(topic)) != null) {
            obs.clear();
        }
    }

    public void deleteObserver(String topic, Observer ob) {
        ObserverGroup obs;
        if (this.groups.containsKey(topic) && (obs = (ObserverGroup)this.groups.get(topic)) != null) {
            obs.deleteObserver(ob);
            if (obs.countOfObservers() == 0) {
                this.groups.remove(topic);
            }
        }
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    public void notifyObservers(Object arg) {
        this.notifyObservers(DEFAULT_TOPIC, arg);
    }

    public void notifyObservers(String topic, Object arg) {
        if (this.groups.containsKey(topic)) {
            ((ObserverGroup)this.groups.get(topic)).update(this, arg);
        }
    }

    public void clearObservers() {
        for (String topic : this.groups.keySet()) {
            this.deleteObservers(topic);
        }
    }

    public int countOfObservers() {
        int n = 0;
        for (ObserverGroup obs : this.groups.values()) {
            n += obs.countOfObservers();
        }
        return n;
    }

    public boolean hasTopic(String topicName) {
        return this.groups.containsKey(topicName);
    }

    public static Observable repeatable() {
        return new Observable(true);
    }

    public static Observable unrepeatable() {
        return new Observable(false);
    }

    static class ObserverGroup
    implements Observer {
        private final BlockingQueue<Observer> observers = new PriorityBlockingQueue<Observer>();
        private final String topic;
        private final boolean repeated;

        ObserverGroup(String topic, boolean repeated) {
            this.topic = topic;
            this.repeated = repeated;
        }

        public void addObserver(Observer observer) {
            if (observer != null && !this.observers.contains(observer)) {
                this.observers.offer(observer);
            }
        }

        public void deleteObserver(Observer observer) {
            if (observer != null) {
                this.observers.remove(observer);
            }
        }

        public int countOfObservers() {
            return this.observers.size();
        }

        public void clear() {
            this.observers.clear();
        }

        @Override
        public void update(Observable ob, Object arg) {
            if (this.observers.size() == 1) {
                Observer o = this.repeated ? (Observer)this.observers.peek() : (Observer)this.observers.poll();
                o.update(ob, arg);
            } else if (this.observers.size() > 1) {
                ArrayDeque<Object> q;
                if (this.repeated) {
                    q = new ArrayDeque<Observer>(this.observers);
                } else {
                    q = new ArrayDeque();
                    this.observers.drainTo(q);
                }
                while (q.size() > 0) {
                    Observer o = (Observer)q.poll();
                    o.update(ob, arg);
                }
            }
            if (this.observers.isEmpty()) {
                ob.deleteObservers(this.topic);
            }
        }
    }
}

