/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.TokenParser;
import java.util.function.Function;

public class PrefixationTokenParser
implements TokenParser<String, String> {
    private final String token;

    public PrefixationTokenParser(String token) {
        this.token = token;
    }

    @Override
    public String parse(String text, Function<String, Object> function) {
        int offset = 0;
        int start = text.indexOf(this.token, offset);
        if (start == -1) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        char[] src = text.toCharArray();
        StringBuilder variable = null;
        while (start > -1) {
            if (start > 0 && src[start - 1] == '\\') {
                builder.append(src, offset, start - offset - 1).append(this.token);
                offset = start + this.token.length();
            } else {
                builder.append(src, offset, start - offset);
                for (int i = start + this.token.length(); i < src.length && this.acceptCharacter(src[i]); ++i) {
                    if (variable == null) {
                        variable = new StringBuilder();
                    }
                    variable.append(src[i]);
                }
                if (StringUtils.isNotBlank(variable)) {
                    builder.append(function.apply(variable.toString()));
                    offset = start + this.token.length() + variable.length();
                } else {
                    offset = start + this.token.length();
                }
            }
            if (variable != null) {
                variable.delete(0, variable.length());
            }
            start = text.indexOf(this.token, offset);
        }
        if (offset < src.length) {
            builder.append(src, offset, src.length - offset);
        }
        return builder.toString();
    }

    protected boolean acceptCharacter(char ch) {
        return Character.isLetterOrDigit(ch);
    }
}

