/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.RandomUtils;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.time.DateUtils;
import com.github.paganini2008.devtools.time.LocalDateTimeUtils;
import com.github.paganini2008.devtools.time.LocalDateUtils;
import com.github.paganini2008.devtools.time.LocalTimeUtils;
import com.github.paganini2008.devtools.time.YearUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public abstract class RandomDateUtils {
    public static Year randomYear() {
        return RandomDateUtils.randomYear(YearUtils.MIN_YEAR, Year.now());
    }

    public static Year randomYear(Year fromYear, Year toYear) {
        return RandomDateUtils.randomYear(fromYear.getValue(), toYear.getValue());
    }

    public static Year randomYear(int fromYear, int toYear) {
        return Year.of(RandomUtils.randomYear(fromYear, toYear));
    }

    public static YearMonth randomYearMonth(Year year) {
        return RandomDateUtils.randomYearMonth(year, Month.JANUARY, Month.DECEMBER);
    }

    public static YearMonth randomYearMonth(Year year, Month fromMonth, Month toMonth) {
        Month month = RandomUtils.randomMonth(fromMonth, toMonth);
        return year.atMonth(month);
    }

    public static YearMonth randomYearMonth(Year fromYear, Year toYear, Month fromMonth, Month toMonth) {
        Year year = RandomDateUtils.randomYear(fromYear, toYear);
        return RandomDateUtils.randomYearMonth(year, fromMonth, toMonth);
    }

    public static YearMonth randomYearMonth(int year) {
        return RandomDateUtils.randomYearMonth(year, 0, 12);
    }

    public static YearMonth randomYearMonth(int year, int fromMonth, int toMonth) {
        Year isoYear = Year.of(year);
        Month month = Month.values()[RandomUtils.randomMonth(fromMonth, toMonth) - 1];
        return isoYear.atMonth(month);
    }

    public static YearMonth randomYearMonth(int fromYear, int toYear, int fromMonth, int toMonth) {
        int year = RandomUtils.randomYear(fromYear, toYear);
        return RandomDateUtils.randomYearMonth(year, fromMonth, toMonth);
    }

    public static LocalDate randomLocalDate() {
        return RandomDateUtils.randomLocalDate(Year.now());
    }

    public static LocalDate randomLocalDate(Year year) {
        return RandomDateUtils.randomLocalDate(year, 1, 366);
    }

    public static LocalDate randomLocalDate(Year year, int fromDayOfYear, int toDayOfYear) {
        int dayOfYear = RandomUtils.randomDayOfYear(year, fromDayOfYear, toDayOfYear);
        return year.atDay(dayOfYear);
    }

    public static LocalDate randomLocalDate(Year fromYear, Year toYear, int fromDayOfYear, int toDayOfYear) {
        Year year = RandomDateUtils.randomYear(fromYear, toYear);
        return RandomDateUtils.randomLocalDate(year, fromDayOfYear, toDayOfYear);
    }

    public static LocalDate randomLocalDate(Year year, Month month) {
        return RandomDateUtils.randomLocalDate(year, month, 1, 31);
    }

    public static LocalDate randomLocalDate(YearMonth yearMonth) {
        return RandomDateUtils.randomLocalDate(yearMonth, 1, 31);
    }

    public static LocalDate randomLocalDate(YearMonth yearMonth, int fromDayOfMonth, int toDayOfMonth) {
        int dayOfMonth = RandomUtils.randomDayOfMonth(yearMonth, fromDayOfMonth, toDayOfMonth);
        return yearMonth.atDay(dayOfMonth);
    }

    public static LocalDate randomLocalDate(Year year, Month month, int fromDayOfMonth, int toDayOfMonth) {
        return RandomDateUtils.randomLocalDate(year.atMonth(month), fromDayOfMonth, toDayOfMonth);
    }

    public static LocalDate randomLocalDate(Year year, Month fromMonth, Month toMonth, int fromDayOfMonth, int toDayOfMonth) {
        YearMonth yearMonth = RandomDateUtils.randomYearMonth(year, fromMonth, toMonth);
        return RandomDateUtils.randomLocalDate(yearMonth, fromDayOfMonth, toDayOfMonth);
    }

    public static LocalDate randomLocalDate(Year fromYear, Year toYear, Month fromMonth, Month toMonth, int fromDayOfMonth, int toDayOfMonth) {
        YearMonth yearMonth = RandomDateUtils.randomYearMonth(fromYear, toYear, fromMonth, toMonth);
        return RandomDateUtils.randomLocalDate(yearMonth, fromDayOfMonth, toDayOfMonth);
    }

    public static LocalDate randomLocalDate(int year, int month, int fromDayOfMonth, int toDayOfMonth) {
        int dayOfMonth = RandomUtils.randomDayOfMonth(year, month, fromDayOfMonth, toDayOfMonth);
        return LocalDateUtils.of(year, month, dayOfMonth);
    }

    public static LocalDate randomLocalDate(int year, int fromMonth, int toMonth, int fromDayOfMonth, int toDayOfMonth) {
        YearMonth yearMonth = RandomDateUtils.randomYearMonth(year, fromMonth, toMonth);
        return RandomDateUtils.randomLocalDate(yearMonth, fromDayOfMonth, toDayOfMonth);
    }

    public static LocalDate randomLocalDate(int fromYear, int toYear, int fromMonth, int toMonth, int fromDayOfMonth, int toDayOfMonth) {
        YearMonth yearMonth = RandomDateUtils.randomYearMonth(fromYear, toYear, fromMonth, toMonth);
        return RandomDateUtils.randomLocalDate(yearMonth, fromDayOfMonth, toDayOfMonth);
    }

    public static LocalDate randomLocalDate(String from, String to) {
        return RandomDateUtils.randomLocalDate(from, to, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static LocalDate randomLocalDate(String from, String to, DateTimeFormatter df) {
        LocalDate fromLocalDate = LocalDate.parse(from, df);
        LocalDate toLocalDate = LocalDate.parse(to, df);
        return RandomDateUtils.randomLocalDate(fromLocalDate, toLocalDate);
    }

    public static LocalDate randomLocalDate(LocalDate from, LocalDate to) {
        long days = from.until(to, ChronoUnit.DAYS);
        return from.plusDays(RandomUtils.randomInt(0, (int)days));
    }

    public static LocalDateTime randomLocalDateTime() {
        return RandomDateUtils.randomLocalDateTime(Year.now());
    }

    public static LocalDateTime randomLocalDateTime(Year year) {
        return RandomDateUtils.randomLocalDateTime(year, 1, 366);
    }

    public static LocalDateTime randomLocalDateTime(Year year, int fromDayOfYear, int toDayOfYear) {
        LocalDate localDate = RandomDateUtils.randomLocalDate(year, fromDayOfYear, toDayOfYear);
        LocalTime localTime = RandomDateUtils.randomLocalTime();
        return localDate.atTime(localTime);
    }

    public static LocalDateTime randomLocalDateTime(Year year, int dayOfYear, String from, String to) {
        return RandomDateUtils.randomLocalDateTime(year, dayOfYear, from, to, DateTimeFormatter.ISO_LOCAL_TIME);
    }

    public static LocalDateTime randomLocalDateTime(Year year, int dayOfYear, String from, String to, DateTimeFormatter df) {
        return RandomDateUtils.randomLocalDateTime(year, dayOfYear, LocalTime.parse(from, df), LocalTime.parse(to, df));
    }

    public static LocalDateTime randomLocalDateTime(Year year, int dayOfYear, LocalTime from, LocalTime to) {
        LocalDate localDate = LocalDateUtils.of(year, dayOfYear);
        return RandomDateUtils.randomLocalDateTime(localDate, from, to);
    }

    public static LocalDateTime randomLocalDateTime(Year year, int fromDayOfYear, int toDayOfYear, LocalTime from, LocalTime to) {
        LocalDate localDate = RandomDateUtils.randomLocalDate(year, fromDayOfYear, toDayOfYear);
        return RandomDateUtils.randomLocalDateTime(localDate, from, to);
    }

    public static LocalDateTime randomLocalDateTime(Year fromYear, Year toYear, int fromDayOfYear, int toDayOfYear, LocalTime from, LocalTime to) {
        LocalDate localDate = RandomDateUtils.randomLocalDate(fromYear, toYear, fromDayOfYear, toDayOfYear);
        return RandomDateUtils.randomLocalDateTime(localDate, from, to);
    }

    public static LocalDateTime randomLocalDateTime(LocalDate localDate, String from, String to) {
        return RandomDateUtils.randomLocalDateTime(localDate, from, to, DateTimeFormatter.ISO_LOCAL_TIME);
    }

    public static LocalDateTime randomLocalDateTime(LocalDate localDate, String from, String to, DateTimeFormatter df) {
        return RandomDateUtils.randomLocalDateTime(localDate, LocalTime.parse(from, df), LocalTime.parse(to, df));
    }

    public static LocalDateTime randomLocalDateTime(LocalDate localDate, LocalTime from, LocalTime to) {
        int fh = from.getHour();
        int fm = from.getMinute();
        int fs = from.getSecond();
        int th = to.getHour();
        int tm = to.getMinute();
        int ts = to.getSecond();
        return localDate.atTime(RandomUtils.randomHourOfDay(fh, th), RandomUtils.randomMinuteOrSecond(fm, tm), RandomUtils.randomMinuteOrSecond(fs, ts));
    }

    public static LocalDateTime randomLocalDateTime(Year year, Month month) {
        return RandomDateUtils.randomLocalDateTime(year, month, RandomUtils.randomInt(1, month.maxLength() + 1));
    }

    public static LocalDateTime randomLocalDateTime(Year year, Month month, int dayOfMonth) {
        LocalDate localDate = year.atMonth(month).atDay(dayOfMonth);
        return RandomDateUtils.randomLocalDateTime(localDate);
    }

    public static LocalDateTime randomLocalDateTime(Year year, Month month, int fromDayOfMonth, int toDayOfMonth) {
        LocalDate localDate = RandomDateUtils.randomLocalDate(year, month, fromDayOfMonth, toDayOfMonth);
        return RandomDateUtils.randomLocalDateTime(localDate);
    }

    public static LocalDateTime randomLocalDateTime(Year year, Month fromMonth, Month toMonth, int fromDayOfMonth, int toDayOfMonth) {
        LocalDate localDate = RandomDateUtils.randomLocalDate(year, fromMonth, toMonth, fromDayOfMonth, toDayOfMonth);
        return RandomDateUtils.randomLocalDateTime(localDate);
    }

    public static LocalDateTime randomLocalDateTime(Year fromYear, Year toYear, Month fromMonth, Month toMonth, int fromDayOfMonth, int toDayOfMonth) {
        LocalDate localDate = RandomDateUtils.randomLocalDate(fromYear, toYear, fromMonth, toMonth, fromDayOfMonth, toDayOfMonth);
        return RandomDateUtils.randomLocalDateTime(localDate);
    }

    public static LocalDateTime randomLocalDateTime(Year year, Month month, int dayOfMonth, String from, String to) {
        return RandomDateUtils.randomLocalDateTime(year, month, dayOfMonth, from, to, DateTimeFormatter.ISO_LOCAL_TIME);
    }

    public static LocalDateTime randomLocalDateTime(Year year, Month month, int dayOfMonth, String from, String to, DateTimeFormatter df) {
        return RandomDateUtils.randomLocalDateTime(year, month, dayOfMonth, LocalTime.parse(from, df), LocalTime.parse(to, df));
    }

    public static LocalDateTime randomLocalDateTime(Year year, Month month, int dayOfMonth, LocalTime fromTime, LocalTime toTime) {
        LocalDate localDate = year.atMonth(month).atDay(dayOfMonth);
        return RandomDateUtils.randomLocalDateTime(localDate, fromTime, toTime);
    }

    public static LocalDateTime randomLocalDateTime(Year year, Month month, int fromDayOfMonth, int toDayOfMonth, LocalTime fromTime, LocalTime toTime) {
        LocalDate localDate = RandomDateUtils.randomLocalDate(year, month, fromDayOfMonth, toDayOfMonth);
        return RandomDateUtils.randomLocalDateTime(localDate, fromTime, toTime);
    }

    public static LocalDateTime randomLocalDateTime(Year year, Month fromMonth, Month toMonth, int fromDayOfMonth, int toDayOfMonth, LocalTime fromTime, LocalTime toTime) {
        LocalDate localDate = RandomDateUtils.randomLocalDate(year, fromMonth, toMonth, fromDayOfMonth, toDayOfMonth);
        return RandomDateUtils.randomLocalDateTime(localDate, fromTime, toTime);
    }

    public static LocalDateTime randomLocalDateTime(Year fromYear, Year toYear, Month fromMonth, Month toMonth, int fromDayOfMonth, int toDayOfMonth, LocalTime fromTime, LocalTime toTime) {
        LocalDate localDate = RandomDateUtils.randomLocalDate(fromYear, toYear, fromMonth, toMonth, fromDayOfMonth, toDayOfMonth);
        return RandomDateUtils.randomLocalDateTime(localDate, fromTime, toTime);
    }

    public static LocalDateTime randomLocalDateTime(LocalDate fromLocalDate, LocalDate toLocalDate) {
        LocalDate localDate = RandomDateUtils.randomLocalDate(fromLocalDate, toLocalDate);
        return RandomDateUtils.randomLocalDateTime(localDate);
    }

    public static LocalDateTime randomLocalDateTime(LocalDate fromLocalDate, LocalDate toLocalDate, LocalTime fromTime, LocalTime toTime) {
        LocalDate localDate = RandomDateUtils.randomLocalDate(fromLocalDate, toLocalDate);
        return RandomDateUtils.randomLocalDateTime(localDate, fromTime, toTime);
    }

    public static LocalDateTime randomLocalDateTime(LocalDateTime startTime, LocalDateTime endTime) {
        long seconds = startTime.until(endTime, ChronoUnit.SECONDS);
        return startTime.plusSeconds(RandomUtils.randomInt(0, (int)seconds));
    }

    public static LocalDateTime randomLocalDateTime(String from, String to) {
        return RandomDateUtils.randomLocalDateTime(from, to, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public static LocalDateTime randomLocalDateTime(String from, String to, DateTimeFormatter dtf) {
        LocalDateTime startTime = LocalDateTime.parse(from, dtf);
        LocalDateTime endTime = LocalDateTime.parse(to, dtf);
        return RandomDateUtils.randomLocalDateTime(startTime, endTime);
    }

    public static LocalDateTime randomLocalDateTime(LocalDate localDate) {
        return RandomDateUtils.randomLocalDateTime(localDate, 0, 23, 0, 59, 0, 59);
    }

    public static LocalDateTime randomLocalDateTime(LocalDate localDate, int fromHourOfDay, int toHourOfDay, int fromMinute, int toMinute, int fromSecond, int toSecond) {
        LocalTime startTime = LocalTimeUtils.of(fromHourOfDay, fromMinute, fromSecond);
        LocalTime endTime = LocalTimeUtils.of(toHourOfDay, toMinute, toSecond);
        return RandomDateUtils.randomLocalDateTime(LocalDateTime.of(localDate, startTime), LocalDateTime.of(localDate, endTime));
    }

    public static LocalDateTime randomLocalDateTime(int year, int month, int dayOfMonth, int fromHourOfDay, int toHourOfDay, int fromMinute, int toMinute, int fromSecond, int toSecond) {
        LocalDate localDate = LocalDateUtils.of(year, month, dayOfMonth);
        return RandomDateUtils.randomLocalDateTime(localDate, fromHourOfDay, toHourOfDay, fromMinute, toMinute, fromSecond, toSecond);
    }

    public static LocalDateTime randomLocalDateTime(int fromYear, int toYear, int fromMonth, int toMonth, int fromDayOfMonth, int toDayOfMonth, int fromHourOfDay, int toHourOfDay, int fromMinute, int toMinute, int fromSecond, int toSecond) {
        LocalDateTime startTime = LocalDateTimeUtils.of(fromYear, fromMonth, fromDayOfMonth, fromHourOfDay, fromMinute, fromSecond);
        LocalDateTime endTime = LocalDateTimeUtils.of(toYear, toMonth, toDayOfMonth, toHourOfDay, toMinute, toSecond);
        return RandomDateUtils.randomLocalDateTime(startTime, endTime);
    }

    public static LocalTime randomLocalTime() {
        return RandomDateUtils.randomLocalTime(0, 23, 0, 59);
    }

    public static LocalTime randomLocalTime(int fromHourOfDay, int toHourOfDay, int fromMinute, int toMinute) {
        return RandomDateUtils.randomLocalTime(fromHourOfDay, toHourOfDay, fromMinute, toMinute, 0, 59);
    }

    public static LocalTime randomLocalTime(int fromHourOfDay, int toHourOfDay, int fromMinute, int toMinute, int fromSecond, int toSecond) {
        LocalTime startTime = LocalTimeUtils.of(fromHourOfDay, fromMinute, fromSecond);
        LocalTime endTime = LocalTimeUtils.of(toHourOfDay, toMinute, toSecond);
        return RandomDateUtils.randomLocalTime(startTime, endTime);
    }

    public static LocalTime randomLocalTime(String from, String to) {
        return RandomDateUtils.randomLocalTime(from, to, DateTimeFormatter.ISO_LOCAL_TIME);
    }

    public static LocalTime randomLocalTime(String from, String to, DateTimeFormatter df) {
        return RandomDateUtils.randomLocalTime(LocalTime.parse(from, df), LocalTime.parse(to, df));
    }

    public static LocalTime randomLocalTime(LocalTime from, LocalTime to) {
        long seconds = from.until(to, ChronoUnit.SECONDS);
        return from.plusSeconds(RandomUtils.randomInt(0, (int)seconds));
    }

    public static Date randomDate() {
        return RandomDateUtils.randomDate(DateUtils.getYear());
    }

    public static Date randomDate(int year) {
        return RandomDateUtils.randomDate(year, RandomUtils.randomMonth(1, 12));
    }

    public static Date randomDate(int year, int month) {
        return RandomDateUtils.randomDate(year, month, 1, 31);
    }

    public static Date randomDate(int year, int month, int fromDayOfMonth, int toDayOfMonth) {
        int dayOfMonth = RandomUtils.randomDayOfMonth(year, month, fromDayOfMonth, toDayOfMonth);
        LocalDate localDate = LocalDate.of(year, month, dayOfMonth);
        return DateUtils.toDate(localDate, null);
    }

    public static Date randomDate(int year, int fromMonth, int toMonth, int fromDayOfMonth, int toDayOfMonth) {
        Date fromDate = DateUtils.of(year, fromMonth, fromDayOfMonth);
        Date toDate = DateUtils.of(year, toMonth, toDayOfMonth);
        return RandomDateUtils.randomDate(fromDate, toDate);
    }

    public static Date randomDate(int fromYear, int toYear, int fromMonth, int toMonth, int fromDayOfMonth, int toDayOfMonth) {
        Date fromDate = DateUtils.of(fromYear, fromMonth, fromDayOfMonth);
        Date toDate = DateUtils.of(toYear, toMonth, toDayOfMonth);
        return RandomDateUtils.randomDate(fromDate, toDate);
    }

    public static Date randomDate(String from, String to, String datePattern) {
        Date fromDate = DateUtils.parse(from, datePattern);
        Date toDate = DateUtils.parse(to, datePattern);
        return RandomDateUtils.randomDate(fromDate, toDate);
    }

    public static Date randomDate(Date from, Date to) {
        long days = DateUtils.until(from, to, TimeUnit.DAYS);
        return DateUtils.addDayOfMonth(from, RandomUtils.randomInt(0, (int)days));
    }

    public static Date randomDateTime() {
        return RandomDateUtils.randomDateTime(DateUtils.getYear());
    }

    public static Date randomDateTime(int year) {
        return RandomDateUtils.randomDateTime(year, RandomUtils.randomMonth(1, 12));
    }

    public static Date randomDateTime(int year, int month) {
        return RandomDateUtils.randomDateTime(year, month, 1, 31);
    }

    public static Date randomDateTime(int year, int month, int fromDayOfMonth, int toDayOfMonth) {
        return RandomDateUtils.randomDateTime(year, month, fromDayOfMonth, toDayOfMonth, 0, 23, 0, 59, 0, 59);
    }

    public static Date randomDateTime(int fromYear, int toYear, int fromMonth, int toMonth, int fromDayOfMonth, int toDayOfMonth) {
        return RandomDateUtils.randomDateTime(fromYear, toYear, fromMonth, toMonth, fromDayOfMonth, toDayOfMonth, 0, 23, 0, 59, 0, 59);
    }

    public static Date randomDateTime(int year, int month, int dayOfMonth) {
        return RandomDateUtils.randomDateTime(year, month, dayOfMonth, 0, 23, 0, 59, 0, 59);
    }

    public static Date randomDateTime(int year, int month, int dayOfMonth, int fromHourOfDay, int toHourOfDay, int fromMinute, int toMinute, int fromSecond, int toSecond) {
        Date date = DateUtils.of(year, month, dayOfMonth);
        return RandomDateUtils.randomDateTime(date, fromHourOfDay, toHourOfDay, fromMinute, toMinute, fromSecond, toSecond);
    }

    public static Date randomDateTime(int year, int month, int fromDayOfMonth, int toDayOfMonth, int fromHourOfDay, int toHourOfDay, int fromMinute, int toMinute, int fromSecond, int toSecond) {
        Date from = DateUtils.of(year, month, fromDayOfMonth, fromHourOfDay, fromMinute, fromSecond);
        Date to = DateUtils.of(year, month, toDayOfMonth, toHourOfDay, toMinute, toSecond);
        return RandomDateUtils.randomDateTime(from, to);
    }

    public static Date randomDateTime(int year, int fromMonth, int toMonth, int fromDayOfMonth, int toDayOfMonth, int fromHourOfDay, int toHourOfDay, int fromMinute, int toMinute, int fromSecond, int toSecond) {
        Date from = DateUtils.of(year, fromMonth, fromDayOfMonth, fromHourOfDay, fromMinute, fromSecond);
        Date to = DateUtils.of(year, toMonth, toDayOfMonth, toHourOfDay, toMinute, toSecond);
        return RandomDateUtils.randomDateTime(from, to);
    }

    public static Date randomDateTime(int fromYear, int toYear, int fromMonth, int toMonth, int fromDayOfMonth, int toDayOfMonth, int fromHourOfDay, int toHourOfDay, int fromMinute, int toMinute, int fromSecond, int toSecond) {
        Date from = DateUtils.of(fromYear, fromMonth, fromDayOfMonth, fromHourOfDay, fromMinute, fromSecond);
        Date to = DateUtils.of(toYear, toMonth, toDayOfMonth, toHourOfDay, toMinute, toSecond);
        return RandomDateUtils.randomDateTime(from, to);
    }

    public static Date randomDateTime(Date date, int fromHourOfDay, int toHourOfDay, int fromMinute, int toMinute, int fromSecond, int toSecond) {
        Date from = DateUtils.setTime(date, fromHourOfDay, fromMinute, fromSecond);
        Date to = DateUtils.setTime(date, toHourOfDay, toMinute, toSecond);
        return RandomDateUtils.randomDateTime(from, to);
    }

    public static Date randomDateTime(Date date, String from, String to, String datePattern) {
        Date fromTime = DateUtils.parse(from, datePattern);
        Date toTime = StringUtils.isNotBlank(to) ? DateUtils.parse(to, datePattern) : new Date();
        Date fromDateTime = DateUtils.setTime(date, fromTime);
        Date toDateTime = DateUtils.setTime(date, toTime);
        return RandomDateUtils.randomDateTime(fromDateTime, toDateTime);
    }

    public static Date randomDateTime(String from, String to, String datePattern) {
        Date fromDateTime = DateUtils.parse(from, datePattern);
        Date toDateTime = StringUtils.isNotBlank(to) ? DateUtils.parse(to, datePattern) : new Date();
        return RandomDateUtils.randomDateTime(fromDateTime, toDateTime);
    }

    public static Date randomDateTime(Date from, Date to) {
        long seconds = DateUtils.until(from, to, TimeUnit.SECONDS);
        return DateUtils.addSeconds(from, RandomUtils.randomInt(0, (int)seconds));
    }
}

