/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.ArrayUtils;
import com.github.paganini2008.devtools.math.BigDecimalUtils;
import com.github.paganini2008.devtools.primitives.Doubles;
import com.github.paganini2008.devtools.primitives.Floats;
import com.github.paganini2008.devtools.primitives.Ints;
import com.github.paganini2008.devtools.primitives.Longs;
import com.github.paganini2008.devtools.primitives.Shorts;
import com.github.paganini2008.devtools.reflection.MethodUtils;
import com.github.paganini2008.devtools.time.TimeAssert;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public abstract class RandomUtils {
    public static byte randomChoice(byte[] choice) {
        return choice[RandomUtils.randomInt(0, choice.length)];
    }

    public static byte randomChoice(byte[] choice, int length) {
        return choice[RandomUtils.randomInt(0, Math.min(length, choice.length))];
    }

    public static short randomChoice(short[] choice) {
        return choice[RandomUtils.randomInt(0, choice.length)];
    }

    public static short randomChoice(short[] choice, int length) {
        return choice[RandomUtils.randomInt(0, Math.min(length, choice.length))];
    }

    public static int randomChoice(int[] choice) {
        return choice[RandomUtils.randomInt(0, choice.length)];
    }

    public static int randomChoice(int[] choice, int length) {
        return choice[RandomUtils.randomInt(0, Math.min(length, choice.length))];
    }

    public static long randomChoice(long[] choice) {
        return choice[RandomUtils.randomInt(0, choice.length)];
    }

    public static long randomChoice(long[] choice, int length) {
        return choice[RandomUtils.randomInt(0, Math.min(length, choice.length))];
    }

    public static float randomChoice(float[] choice) {
        return choice[RandomUtils.randomInt(0, choice.length)];
    }

    public static float randomChoice(float[] choice, int length) {
        return choice[RandomUtils.randomInt(0, Math.min(length, choice.length))];
    }

    public static double randomChoice(double[] choice) {
        return choice[RandomUtils.randomInt(0, choice.length)];
    }

    public static double randomChoice(double[] choice, int length) {
        return choice[RandomUtils.randomInt(0, Math.min(length, choice.length))];
    }

    public static char randomChoice(char[] choice) {
        return choice[RandomUtils.randomInt(0, choice.length)];
    }

    public static char randomChoice(char[] choice, int length) {
        return choice[RandomUtils.randomInt(0, Math.min(length, choice.length))];
    }

    public static boolean randomChoice(boolean[] choice) {
        return choice[RandomUtils.randomInt(0, choice.length)];
    }

    public static boolean randomChoice(boolean[] choice, int length) {
        return choice[RandomUtils.randomInt(0, Math.min(length, choice.length))];
    }

    public static <T> T randomChoice(T[] choice) {
        return choice[RandomUtils.randomInt(0, choice.length)];
    }

    public static <T> T randomChoice(T[] choice, int length) {
        return choice[RandomUtils.randomInt(0, Math.min(length, choice.length))];
    }

    public static <T> T randomChoice(List<T> list) {
        return list.get(RandomUtils.randomInt(0, list.size()));
    }

    public static <T> T randomChoice(List<T> list, int length) {
        return list.get(RandomUtils.randomInt(0, Math.min(length, list.size())));
    }

    public static boolean randomBoolean() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    public static byte randomByte(byte from, byte to) {
        return (byte)RandomUtils.randomInt(from, to);
    }

    public static char randomChar(char from, char to) {
        return (char)RandomUtils.randomInt(from, to);
    }

    public static short randomShort(short from, short to) {
        return (short)RandomUtils.randomInt(from, to);
    }

    public static short[] randomShorts(int length, short from, short to) {
        return RandomUtils.randomShorts(length, from, to, false);
    }

    public static short[] randomShorts(int length, short from, short to, boolean existsAllowed) {
        short[] results = new short[length];
        for (int i = 0; i < length; ++i) {
            short s;
            do {
                s = RandomUtils.randomShort(from, to);
            } while (!existsAllowed && Shorts.contains(results, s));
            results[i] = s;
        }
        return results;
    }

    public static int randomInt() {
        return RandomUtils.randomInt(0, Integer.MAX_VALUE);
    }

    public static int defineInt(int precision) {
        if (Math.log10(2.147483647E9) <= (double)precision) {
            throw new IllegalArgumentException("Exceed maximum integer value");
        }
        int from = (int)Math.pow(10.0, precision - 1);
        int to = (int)Math.pow(10.0, precision);
        return RandomUtils.randomInt(from, to);
    }

    public static int[] defineInts(int length, int precision) {
        return RandomUtils.defineInts(length, precision, false);
    }

    public static int[] defineInts(int length, int precision, boolean existsAllowed) {
        int[] results = new int[length];
        for (int i = 0; i < length; ++i) {
            int a;
            do {
                a = RandomUtils.defineInt(precision);
            } while (!existsAllowed && Ints.contains(results, a));
            results[i] = a;
        }
        return results;
    }

    public static int randomInt(int from, int to) {
        return from != to ? ThreadLocalRandom.current().nextInt(from, to) : from;
    }

    public static int[] randomInts(int length, int from, int to) {
        return RandomUtils.randomInts(length, from, to, false);
    }

    public static int[] randomInts(int length, int from, int to, boolean existsAllowed) {
        int[] results = new int[length];
        for (int i = 0; i < length; ++i) {
            int a;
            do {
                a = RandomUtils.randomInt(from, to);
            } while (!existsAllowed && Ints.contains(results, a));
            results[i] = a;
        }
        return results;
    }

    public static long defineLong(int precision) {
        if (Math.log10(9.223372036854776E18) <= (double)precision) {
            throw new IllegalArgumentException("Exceed maximum long value");
        }
        long from = (long)Math.pow(10.0, precision - 1);
        long to = (long)Math.pow(10.0, precision);
        return RandomUtils.randomLong(from, to);
    }

    public static long[] defineLongs(int length, int precision) {
        return RandomUtils.defineLongs(length, precision, false);
    }

    public static long[] defineLongs(int length, int precision, boolean existsAllowed) {
        long[] results = new long[length];
        for (int i = 0; i < length; ++i) {
            long l;
            do {
                l = RandomUtils.defineLong(precision);
            } while (!existsAllowed && Longs.contains(results, l));
            results[i] = l;
        }
        return results;
    }

    public static long randomLong(long from, long to) {
        return from != to ? ThreadLocalRandom.current().nextLong(from, to) : from;
    }

    public static long[] randomLongs(int length, long from, long to) {
        return RandomUtils.randomLongs(length, from, to, false);
    }

    public static long[] randomLongs(int length, long from, long to, boolean existsAllowed) {
        long[] results = new long[length];
        for (int i = 0; i < length; ++i) {
            long l;
            do {
                l = RandomUtils.randomLong(from, to);
            } while (!existsAllowed && Longs.contains(results, l));
            results[i] = l;
        }
        return results;
    }

    public static float randomFloat() {
        return ThreadLocalRandom.current().nextFloat();
    }

    public static float randomFloat(float from, float to) {
        return from != to ? RandomUtils.randomFloat() * (to - from) + from : from;
    }

    public static float randomFloat(float from, float to, int scale) {
        float rand = RandomUtils.randomFloat(from, to);
        return Floats.toFixed(rand, scale);
    }

    public static float defineFloat(int precision, int scale) {
        long from = (long)Math.pow(10.0, precision - 1);
        long to = (long)Math.pow(10.0, precision);
        float rand = RandomUtils.randomFloat(from, to);
        return Floats.toFixed(rand, scale);
    }

    public static float[] defineFloats(int length, int precision, int scale) {
        return RandomUtils.defineFloats(length, precision, scale, false);
    }

    public static float[] defineFloats(int length, int precision, int scale, boolean existsAllowed) {
        float[] results = new float[length];
        for (int i = 0; i < length; ++i) {
            float f;
            do {
                f = RandomUtils.defineFloat(precision, scale);
            } while (!existsAllowed && Floats.contains(results, f));
            results[i] = f;
        }
        return results;
    }

    public static float[] randomFloats(int length, float from, float to) {
        return RandomUtils.randomFloats(length, from, to, false);
    }

    public static float[] randomFloats(int length, float from, float to, boolean existsAllowed) {
        float[] results = new float[length];
        for (int i = 0; i < length; ++i) {
            float a;
            do {
                a = RandomUtils.randomFloat(from, to);
            } while (!existsAllowed && Floats.contains(results, a));
            results[i] = a;
        }
        return results;
    }

    public static double randomDouble() {
        return ThreadLocalRandom.current().nextDouble();
    }

    public static double randomDouble(double from, double to) {
        return from != to ? ThreadLocalRandom.current().nextDouble(from, to) : from;
    }

    public static double randomDouble(double from, double to, int scale) {
        double rand = RandomUtils.randomDouble(from, to);
        return Doubles.toFixed(rand, scale);
    }

    public static double defineDouble(int precision, int scale) {
        long from = (long)Math.pow(10.0, precision - 1);
        long to = (long)Math.pow(10.0, precision);
        double rand = RandomUtils.randomDouble(from, to);
        return Doubles.toFixed(rand, scale);
    }

    public static double[] defineDoubles(int length, int precision, int scale) {
        return RandomUtils.defineDoubles(length, precision, scale, false);
    }

    public static double[] defineDoubles(int length, int precision, int scale, boolean existsAllowed) {
        double[] results = new double[length];
        for (int i = 0; i < length; ++i) {
            double d;
            do {
                d = RandomUtils.defineDouble(precision, scale);
            } while (!existsAllowed && Doubles.contains(results, d));
            results[i] = d;
        }
        return results;
    }

    public static double[] randomDoubles(int length, double from, double to) {
        return RandomUtils.randomDoubles(length, from, to, false);
    }

    public static double[] randomDoubles(int length, double from, double to, boolean existsAllowed) {
        double[] results = new double[length];
        for (int i = 0; i < length; ++i) {
            double d;
            do {
                d = RandomUtils.randomDouble(from, to);
            } while (!existsAllowed && Doubles.contains(results, d));
            results[i] = d;
        }
        return results;
    }

    public static BigInteger randomBigInteger(long from, long to) {
        return RandomUtils.randomBigInteger(BigInteger.valueOf(from), BigInteger.valueOf(to));
    }

    public static BigInteger randomBigInteger(BigInteger from, BigInteger to) {
        return RandomUtils.randomBigDecimal(new BigDecimal(from), new BigDecimal(to)).toBigInteger();
    }

    public static BigDecimal randomBigDecimal(double from, double to, int scale) {
        return RandomUtils.randomBigDecimal(BigDecimal.valueOf(from), BigDecimal.valueOf(to), scale);
    }

    public static BigDecimal randomBigDecimal(BigDecimal from, BigDecimal to) {
        int p = BigDecimalUtils.getPrecision(to);
        int s = BigDecimalUtils.getScale(to);
        return RandomUtils.randomBigDecimal(from, to, Math.max(16, p + s));
    }

    public static BigDecimal randomBigDecimal(BigDecimal from, BigDecimal to, int scale) {
        BigDecimal rand = RandomUtils.randomBigDecimal(scale);
        return rand.multiply(to.subtract(from)).add(from).stripTrailingZeros();
    }

    public static BigDecimal randomBigDecimal(int scale) {
        BigInteger m;
        ThreadLocalRandom r = ThreadLocalRandom.current();
        BigInteger n = BigInteger.TEN.pow(scale);
        while ((m = new BigInteger(n.bitLength(), r)).compareTo(n) >= 0) {
        }
        return new BigDecimal(m, scale);
    }

    public static BigDecimal defineBigDecimal(int precision, int scale) {
        BigDecimal from = BigDecimal.TEN.pow(precision - 1);
        BigDecimal to = BigDecimal.TEN.pow(precision);
        int newScale = BigDecimalUtils.getPrecision(to) + scale;
        BigDecimal value = RandomUtils.randomBigDecimal(from, to, newScale);
        return scale >= 0 ? value.setScale(scale, RoundingMode.HALF_UP) : value;
    }

    public static BigDecimal[] defineBigDecimals(int length, int precision, int scale) {
        return RandomUtils.defineBigDecimals(length, precision, scale, false);
    }

    public static BigDecimal[] defineBigDecimals(int length, int precision, int scale, boolean existsAllowed) {
        Object[] results = new BigDecimal[length];
        for (int i = 0; i < length; ++i) {
            BigDecimal b;
            do {
                b = RandomUtils.defineBigDecimal(precision, scale);
            } while (!existsAllowed && ArrayUtils.contains(results, b));
            results[i] = b;
        }
        return results;
    }

    public static BigInteger defineBigInteger(int precision) {
        return RandomUtils.defineBigDecimal(precision, 0).toBigInteger();
    }

    public static BigInteger[] defineBigIntegers(int length, int precision) {
        return RandomUtils.defineBigIntegers(length, precision, false);
    }

    public static BigInteger[] defineBigIntegers(int length, int precision, boolean existsAllowed) {
        Object[] results = new BigInteger[length];
        for (int i = 0; i < length; ++i) {
            BigInteger b;
            do {
                b = RandomUtils.defineBigInteger(precision);
            } while (!existsAllowed && ArrayUtils.contains(results, b));
            results[i] = b;
        }
        return results;
    }

    public static <E extends Enum<E>> E randomEnum(Class<E> enumClass) {
        Enum[] enums = (Enum[])MethodUtils.invokeStaticMethod(enumClass, "values", new Object[0]);
        return (E)RandomUtils.randomChoice(enums);
    }

    public static int randomYear(int fromYear, int toYear) {
        TimeAssert.validateYear(fromYear);
        TimeAssert.validateYear(toYear);
        return RandomUtils.randomInt(fromYear, toYear + 1);
    }

    public static int randomMonth(int fromMonth, int toMonth) {
        TimeAssert.validateMonth(fromMonth);
        TimeAssert.validateMonth(toMonth);
        return RandomUtils.randomInt(fromMonth, toMonth + 1);
    }

    public static Month randomMonth(Month start, Month end) {
        return Month.values()[RandomUtils.randomMonth(start.ordinal() + 1, end.ordinal() + 1) - 1];
    }

    public static int randomDayOfYear(Year year, int fromDayOfYear, int toDayOfYear) {
        TimeAssert.validateDayOfYear(year, fromDayOfYear);
        toDayOfYear = Math.min(toDayOfYear, year.isLeap() ? 366 : 365);
        return RandomUtils.randomInt(fromDayOfYear, toDayOfYear + 1);
    }

    public static int randomDayOfMonth(YearMonth yearMonth, int fromDayOfMonth, int toDayOfMonth) {
        TimeAssert.validateDayOfMonth(yearMonth, fromDayOfMonth);
        toDayOfMonth = Math.min(toDayOfMonth, yearMonth.atEndOfMonth().getDayOfMonth());
        return RandomUtils.randomInt(fromDayOfMonth, toDayOfMonth + 1);
    }

    public static int randomDayOfMonth(int year, int month, int fromDayOfMonth, int toDayOfMonth) {
        TimeAssert.validateDayOfMonth(year, month, fromDayOfMonth);
        toDayOfMonth = Math.min(toDayOfMonth, YearMonth.of(year, month).atEndOfMonth().getDayOfMonth());
        return RandomUtils.randomInt(fromDayOfMonth, toDayOfMonth + 1);
    }

    public static int randomHourOfDay(int fromHourOfDay, int toHourOfDay) {
        TimeAssert.validateHourOfDay(fromHourOfDay);
        TimeAssert.validateHourOfDay(toHourOfDay);
        return RandomUtils.randomInt(fromHourOfDay, toHourOfDay + 1);
    }

    public static int randomMinuteOrSecond(int from, int to) {
        TimeAssert.validateMinuteOrSecond(from);
        TimeAssert.validateMinuteOrSecond(to);
        return RandomUtils.randomInt(from, to + 1);
    }
}

