/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class Sequence {
    public static Iterable<Integer> forEach(int to) {
        return Sequence.forEach(0, to);
    }

    public static Iterable<Integer> forEach(int from, int to) {
        return Sequence.forEach(from, to, 1);
    }

    public static Iterable<Integer> forEach(final int from, final int to, final int interval) {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new IntegerSequence(from, to, interval);
            }
        };
    }

    public static List<Integer> range(int to) {
        return Sequence.range(0, to);
    }

    public static List<Integer> range(int from, int to) {
        return Sequence.range(from, to, 1);
    }

    public static List<Integer> range(int from, int to, int interval) {
        ArrayList<Integer> range = new ArrayList<Integer>();
        for (Integer i : Sequence.forEach(from, to, interval)) {
            range.add(i);
        }
        return range;
    }

    public static Iterable<Long> forEach(long to) {
        return Sequence.forEach(0L, to);
    }

    public static Iterable<Long> forEach(long from, long to) {
        return Sequence.forEach(from, to, 1);
    }

    public static Iterable<Long> forEach(final long from, final long to, final int interval) {
        return new Iterable<Long>(){

            @Override
            public Iterator<Long> iterator() {
                return new LongSequence(from, to, interval);
            }
        };
    }

    public static List<Long> range(long to) {
        return Sequence.range(0L, to);
    }

    public static List<Long> range(long from, long to) {
        return Sequence.range(from, to, 1);
    }

    public static List<Long> range(long from, long to, int interval) {
        ArrayList<Long> range = new ArrayList<Long>();
        for (Long l : Sequence.forEach(from, to, interval)) {
            range.add(l);
        }
        return range;
    }

    static class IntegerSequence
    implements Iterator<Integer> {
        private final AtomicInteger counter;
        private final int to;
        private final int interval;

        IntegerSequence(int from, int to, int interval) {
            this.counter = new AtomicInteger(from);
            this.to = to;
            this.interval = interval;
        }

        @Override
        public boolean hasNext() {
            return this.counter.get() < this.to;
        }

        @Override
        public Integer next() {
            return this.counter.getAndAdd(this.interval);
        }
    }

    static class LongSequence
    implements Iterator<Long> {
        private final AtomicLong counter;
        private final long to;
        private final int interval;

        LongSequence(long from, long to, int interval) {
            this.counter = new AtomicLong(from);
            this.to = to;
            this.interval = interval;
        }

        @Override
        public boolean hasNext() {
            return this.counter.get() < this.to;
        }

        @Override
        public Long next() {
            return this.counter.getAndAdd(this.interval);
        }
    }
}

