/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.ServiceNotFoundException;
import com.github.paganini2008.devtools.collection.LruMap;
import com.github.paganini2008.devtools.io.ResourceUtils;
import com.github.paganini2008.devtools.reflection.ConstructorUtils;
import java.util.LinkedHashMap;
import java.util.Map;

public class ServiceLoader<T> {
    private static final String DEFAULT_LOOKUP_PATH = "META-INF/spi/com/github/paganini2008/devtools/";
    private static String lookupPath = "META-INF/spi/com/github/paganini2008/devtools/";
    private final Class<T> interfaceClass;
    private final ClassLoader classLoader;
    private final Map<String, Class<T>> serviceClasses = new LinkedHashMap<String, Class<T>>();
    private final LruMap<String, T> serviceBeanCache = new LruMap();

    public static void lookupPath(String lookupPath) {
        ServiceLoader.lookupPath = lookupPath;
    }

    ServiceLoader(Class<T> interfaceClass, ClassLoader classLoader) {
        Map<String, String> mapper;
        if (interfaceClass == null || !interfaceClass.isInterface()) {
            throw new ServiceNotFoundException("This class '" + interfaceClass + "' is not a interface class.");
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        try {
            String name = lookupPath + "/" + interfaceClass.getName();
            mapper = ResourceUtils.getResource(name, classLoader);
        }
        catch (Exception e) {
            throw new ServiceNotFoundException("Cannot find service '" + interfaceClass.getName() + "' on '" + lookupPath + "'.");
        }
        for (Map.Entry<String, String> en : mapper.entrySet()) {
            Class<?> cl;
            try {
                cl = Class.forName(en.getValue(), true, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new ServiceNotFoundException("Service class '" + en.getValue() + "' is not found.", e);
            }
            if (!interfaceClass.isAssignableFrom(cl)) {
                throw new ServiceNotFoundException("Service class '" + en.getValue() + "' doesn't implement for '" + interfaceClass.getName() + "'.");
            }
            this.serviceClasses.put(en.getKey(), cl);
        }
        this.interfaceClass = interfaceClass;
        this.classLoader = classLoader;
    }

    private T createObject(Class<T> serviceClass, Object[] parameters) {
        try {
            return ConstructorUtils.invokeConstructor(serviceClass, parameters);
        }
        catch (Exception e) {
            throw new ServiceNotFoundException("Service class '" + serviceClass.getName() + "' cannot access.", e);
        }
    }

    public static <T> ServiceLoader<T> load(Class<T> interfaceClass) {
        return new ServiceLoader<T>(interfaceClass, null);
    }

    public static <T> ServiceLoader<T> load(Class<T> interfaceClass, ClassLoader classLoader) {
        return new ServiceLoader<T>(interfaceClass, classLoader);
    }

    public T getFirst(Object ... parameters) {
        return this.get("default", parameters);
    }

    public T get(String alias, Object ... parameters) {
        T instance = this.serviceBeanCache.get(alias);
        if (instance == null) {
            if (!this.serviceClasses.containsKey(alias)) {
                throw new ServiceNotFoundException("For alias: " + alias);
            }
            this.serviceBeanCache.put(alias, this.createObject(this.serviceClasses.get(alias), parameters));
            instance = this.serviceBeanCache.get(alias);
        }
        return instance;
    }
}

