/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.TokenParser;
import java.util.function.Function;

public class SimpleTokenParser
implements TokenParser<Integer, String> {
    private final String placeholder;

    public SimpleTokenParser(String placeholder) {
        this.placeholder = placeholder;
    }

    @Override
    public String parse(String text, Function<Integer, Object> function) {
        int offset = 0;
        int start = text.indexOf(this.placeholder, offset);
        if (start == -1) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        char[] src = text.toCharArray();
        int n = 0;
        while (start > -1) {
            if (start > 0 && src[start - 1] == '\\') {
                builder.append(src, offset, start - offset - 1).append(this.placeholder);
                offset = start + this.placeholder.length();
            } else {
                builder.append(src, offset, start - offset);
                builder.append(function.apply(n++));
                offset = start + this.placeholder.length();
            }
            start = text.indexOf(this.placeholder, offset);
        }
        if (offset < src.length) {
            builder.append(src, offset, src.length - offset);
        }
        return builder.toString();
    }
}

