/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.primitives.Booleans;
import com.github.paganini2008.devtools.primitives.Bytes;
import com.github.paganini2008.devtools.primitives.Doubles;
import com.github.paganini2008.devtools.primitives.Floats;
import com.github.paganini2008.devtools.primitives.Ints;
import com.github.paganini2008.devtools.primitives.Longs;
import com.github.paganini2008.devtools.primitives.Shorts;

public abstract class SystemPropertyUtils {
    public static Boolean getBoolean(String key) {
        return SystemPropertyUtils.getBoolean(key, null);
    }

    public static Boolean getBoolean(String key, Boolean defaultValue) {
        return Booleans.valueOf(SystemPropertyUtils.getString(key), defaultValue);
    }

    public static Float getFloat(String key) {
        return SystemPropertyUtils.getFloat(key, null);
    }

    public static Float getFloat(String key, Float defaultValue) {
        return Floats.valueOf(SystemPropertyUtils.getString(key), defaultValue);
    }

    public static Double getDouble(String key) {
        return SystemPropertyUtils.getDouble(key, null);
    }

    public static Double getDouble(String key, Double defaultValue) {
        return Doubles.valueOf(SystemPropertyUtils.getString(key), defaultValue);
    }

    public static Byte getByte(String key) {
        return SystemPropertyUtils.getByte(key, null);
    }

    public static Byte getByte(String key, Byte defaultValue) {
        return Bytes.valueOf(SystemPropertyUtils.getString(key), defaultValue);
    }

    public static Short getShort(String key) {
        return SystemPropertyUtils.getShort(key, null);
    }

    public static Short getShort(String key, Short defaultValue) {
        return Shorts.valueOf(SystemPropertyUtils.getString(key), defaultValue);
    }

    public static Integer getInteger(String key) {
        return SystemPropertyUtils.getInteger(key, null);
    }

    public static Integer getInteger(String key, Integer defaultValue) {
        return Ints.valueOf(SystemPropertyUtils.getString(key), defaultValue);
    }

    public static Long getLong(String key) {
        return SystemPropertyUtils.getLong(key, null);
    }

    public static Long getLong(String key, Long defaultValue) {
        return Longs.valueOf(SystemPropertyUtils.getString(key), defaultValue);
    }

    public static Character getCharacter(String key) {
        return SystemPropertyUtils.getCharacter(key, null);
    }

    public static Character getCharacter(String key, Character defaultValue) {
        try {
            return Character.valueOf(SystemPropertyUtils.getString(key).charAt(0));
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static String getString(String key) {
        return SystemPropertyUtils.getString(key, null);
    }

    public static String getString(String key, String defaultValue) {
        String value = System.getProperty(key);
        if (StringUtils.isBlank(value)) {
            value = System.getenv(key);
        }
        if (StringUtils.isBlank(value)) {
            value = defaultValue;
        }
        return value;
    }
}

